/* monflags.h -- Definitions for RAM-Monitor external variables and flags
 * copyright (c) 1984  American Information Systems Corporation
 *
 *	Daniel Steinberg
 *	July, 1984
 */
#ifndef MONFLAGS
#define MONFLAGS

#include "promhdr.h"
#include "3200config.h"
#include "mondef.h"
#include "cflags.h"


/* The following symbols are defined by the loader for all tasks */
extern unsigned end, etext, edata;


/* Define the start addresses of Absolute-Addressed RAM segments */
#define ZRAMSTART (0x40)
#define RAMSTART (256 * 1024)


/* Define the bounds of the low memory segment */
#define ZERORAMSTART (0x0)
#define ZRAMEND (ZRAMSTART + sizeof(ZERO_RAM))
#define ZERORAMEND ((ZRAMEND + (GRAIN - 1)) & ~(GRAIN - 1))


/* Define macros to simplify future definitions */

#define Makezram(type, name) type ZRAM_/**/name;
#define Makezdef(name) ((ZERO_RAM*)ZRAMSTART)->ZRAM_/**/name

#define Makeram(type, name) type RAM_/**/name;
#define Makedef(name) ((MONITOR_RAM*)RAMSTART)->RAM_/**/name


/*
 * Define the structure of the Absolute-Addressed RAM that must be
 * mapped (read-only) by the Target Operating System Kernel
 */

typedef struct {

			/* Define Mod Tables & Interrupt Dispatch Tables */

Makezram( char	,defmod[MOD_SIZE])	/* Default Module Table Entry */
#define defmod Makezdef(defmod)

Makezram( char	,intmod[MOD_SIZE])	/* Interrupt Module Table Entry */
#define intmod Makezdef(intmod)

Makezram( int*	,mondispatch[TRAPS+VECTORS])	/* Monitor Dispatch Table */
#define mondispatch Makezdef(mondispatch)

Makezram( int*	,viosdispatch[TRAPS+VECTORS])	/* VIOS Dispatch Table */
#define viosdispatch Makezdef(viosdispatch)

Makezram( int*	,oskdispatch[TRAPS+VECTORS])	/* OS Kernel Dispatch Table */
#define oskdispatch Makezdef(oskdispatch)

Makezram( int*	,osidispatch[TRAPS+VECTORS])	/* OS K Completion Disp Table */
#define osidispatch Makezdef(osidispatch)

Makezram( int*	,osudispatch[TRAPS+VECTORS])	/* OS User Dispatch Table */
#define osudispatch Makezdef(osudispatch)

			/* System Info */

Makezram( char	,membitmap[MAPSIZ])	/* Memory Bitmap */
#define membitmap Makezdef(membitmap)

Makezram( char	,debug_user_state)	/* TRUE: monitor traps User-State bpt */
#define debug_user_state Makezdef(debug_user_state)

Makezram( int*	,reset_addr)		/* address of soft reset code */
#define reset_addr Makezdef(reset_addr)

	}  ZERO_RAM;		/* end of low-core mapped RAM */



/*
 * Define the structure of the AIS/RAM-Monitor portion of
 *	Absolute-Addressed RAM and define variables
 */

typedef struct {

			/* System Info */

Makeram( int	,memsize)		/* #bytes of good RAM */
#define memsize Makedef(memsize)

Makeram( int*	,cataddr)		/* current catch frame address */
#define cataddr Makedef(cataddr)

Makeram( int	,lasthrown)		/* last thrown error */
#define lasthrown Makedef(lasthrown)

Makeram( int	,emergency[8+5])	/* Emergency Register Dump */
#define emergency Makedef(emergency)		/* r0-r7,sp,fp,sb,mod,intbase */

			/* RAM-Monitor tables and pointers */

Makeram( INTSTACK*	,env)		/* Environment Pointer */
#define env Makedef(env)

Makeram( BRKPNT	,brktab[MAXBRK])	/* breakpoint table */
#define brktab Makedef(brktab)

Makeram( char	,autobuf[MAXINP])	/* auto-print buffer */
#define autobuf Makedef(autobuf)

Makeram( SYMBOL	,symtab[MAXSYM])	/* symbol table */
#define symtab Makedef(symtab)


Makeram( int	,tmpclrbr)		/* last cleared breakpoint */
#define tmpclrbr Makedef(tmpclrbr)

Makeram( int	,tempbrk)		/* Address for temporary breakpoint */
#define tempbrk Makedef(tempbrk)

Makeram( char*	,autoptr)		/* pointer to auto-print buffer */
#define autoptr Makedef(autoptr)

Makeram( SYMBOL*	,symstart)	/* address of 1st symbol table entry */
#define symstart Makedef(symstart)

			/* Various RAM-Monitor flags */

Makeram( int	,cflags)	       	/* control flags for debugger */
#define cflags Makedef(cflags)

Makeram( int	,stepcnt)		/* Single Step count */
#define stepcnt Makedef(stepcnt)

Makeram( int	,procnt)		/* Proceed count */
#define procnt Makedef(procnt)

Makeram( char*	,svbrka)		/* Saved break address */
#define svbrka Makedef(svbrka)

Makeram( short*	,savpsr)		/* Global ptr to saved psr */
#define savpsr Makedef(savpsr)

Makeram( int	,instr_len)		/* Length of instruction at dot */
#define instr_len Makedef(instr_len)

Makeram( unsigned	,curaddr)	/* current address */
#define curaddr Makedef(curaddr)		/* default: 0 */

Makeram( char	,curbase)		/* current output base */
#define curbase Makedef(curbase)		/* default: hexidecimal */

Makeram( unsigned char	,cursize)	/* current output size */
#define cursize Makedef(cursize)		/* default: double, 32bits */
						/* byte (backquote) */
						/* word (backslash) */
						/* double (slash) */

Makeram( char	,initflag)		/* TRUE: RAM-Monitor initialized */
#define initflag Makedef(initflag)

			/* Disassembler symbols */

Makeram( int	,acontext)		/* size(b,w,d) of displayed object */
#define acontext Makedef(acontext)

Makeram( char*	,ibuf)
#define ibuf Makedef(ibuf)

Makeram( unsigned	,lastmod)	/* last module (for error checking) */
#define lastmod Makedef(lastmod)

Makeram( int	,firsthex)
#define firsthex Makedef(firsthex)

Makeram( int	,opcxpd)
#define opcxpd Makedef(opcxpd)

Makeram( int	,context)
#define context Makedef(context)

Makeram( int	,instr)
#define instr Makedef(instr)

Makeram( int	,istart)
#define istart Makedef(istart)

Makeram( int	,ilen)
#define ilen Makedef(ilen)

Makeram( int	,mapping)
#define mapping Makedef(mapping)

Makeram( char	,inbuf[IBUFFERSIZE])
#define inbuf Makedef(inbuf)

Makeram( int	,lmapsym)
#define lmapsym Makedef(lmapsym)

			/* Input Processing storage (input.c) */

Makeram( char	,lastinp[MAXINP])
#define lastinp Makedef(lastinp)

Makeram( char	,lastcmd)
#define lastcmd Makedef(lastcmd)

			/* AIS/RAM-Monitor/VIOS Stack area */

#ifdef DEBUG_MONITOR /************ Monitor Debugging *************************/
Makeram( char	,d__monstack[MON_STACKSIZE])		/* debug stack */
Makeram( int	,debug_monstack)	/* start of debug stack */
#define debug_monstack Makedef(debug_monstack)

Makeram( int	,recursive)		/* Recursive trap flag */
#define recursive Makedef(recursive)
#endif /* DEBUG_MONITOR ********** Monitor Debugging *************************/

Makeram( char	,_monstack[MON_STACKSIZE])		/* RAM-Monitor stack */
Makeram( int	,monstack)		/* start of RAM-Monitor stack */
#define monstack Makedef(monstack)

Makeram( char	,_viosstack[VIOS_STACKSIZE])		/* VIOS stack */
Makeram( int	,viosstack)		/* start of VIOS stack */
#define viosstack Makedef(viosstack)

	} MONITOR_RAM;		/* end of RAM-Monitor Absolute-Addressed RAM */

#endif
