/* rodata.c -- read only data for the monitor
 *	(stuff that can't be 'xstringed')
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  July, 1984
 */

/* various messages */

char corporation[]=
	"American Information Systems Corporation";
char copyright[]  =
	"\r\ncopyright (c) 1984  ";

char productmsg[] =
	"\r\nAIS/3200\r\n";

char memtestmsg[] = "\n...mapping memory...";
char memcntmsg[]  = "... %x bytes available\r\n";

char ckfailmsg[]  = "\007PROM Checksum Failure";
char ldfailmsg[]  = "\007Load Address Error";
char memfailmsg[] = "\007Bank 0 Memory Error";
char badboardmsg[]= "\007Intermittent AIS/Bus or Memory";
char spcresetmsg[]= "\007Host Non-Destructive Reset";

char parerrmsg[]  = "\r\n   Parity Error at %x  ";

#ifdef DEBUG3   /*************************************************************/
char badnmimsg[]  = "\007  ?NMI?  ";
#endif /* DEBUG3 *************************************************************/

char romtrapmsg[] = "\007   Unexpected trap: ";
char rectrapmsg[] = "   Recursive trap: %s at %x\r\n";


/* characters strings referenced by the ramless monitor */
char RMbootmsg[] = "\r\nAIS/3200  Ramless Monitor (V2.0)\r\n";
char fifomsg[] = "\r\ninput overflow\n\r";

/* character strings used by both the ramless monitor and the ram monitor */
char loadmsg[] = "\r\nLoader Started ";
char badtxchk[] = "\007Bad TX Checksum\r\n";
char badmemchk[] = "\007Bad Mem Checksum\r\n";
char loadaddrmsg[] = "load address=";
char sizemsg[] = " size=";
char cmdc[] = "compare";
char cmdcsyn[] = "<addr1> <addr2> <count> c";
char cmdd[] = "dump";
char cmddsyn[] = "<addr> <count> d";
char cmdf[] = "fill";
char cmdfsyn[] = "<addr> <count> <value> f";
char cmdg[] = "go";
char cmdgsyn[] = "{addr} g -- ints disabled";
char cmdh[] = "help";
char cmdhsyn[] = "?";
char cmdi[] = "image loader";
char cmdisyn[] = "(read program image from uart1) i";
char cmdm[] = "move";
char cmdmsyn[] = "<src> <dest> <count> m";
char cmdo[] = "open";
char cmdosyn[] = "{addr} </(double),\\(word),`(byte)>|@|<count>(+|-)|<val>(LF|^|CR)}";
char cmdz[] = "zap";
char cmdzsyn[] = "<addr> <data> <b|w|d> z";

/* trap names (referenced in xsrodata.c) */
char rsv[] = "RSV";
char vec[] = "VEC";


/* used in disasm.c */
char fieldtype[] = {'c','b','S','C','G','R','P','M','s'};
char indexm[] = {'b','w','d','q'};

#include "vctype.h"

char _vctype_[] = {
	0,
	_C,	_C,	_C,	_C,	_C,	_C,	_C,	_C|_S,
	_C|_S,	_C|_S,	_C|_S,	_C|_S,	_C|_S,	_C|_S,	_C,	_C,
	_C,	_C,	_C,	_C,	_C,	_C,	_C,	_C,
	_C,	_C,	_C,	_C,	_C,	_C,	_C,	_C,
	_S,	_P,	_P,	_P,	_P,	_P,	_P,	_P,
	_P,	_P,	_P,	_P,	_P,	_P,	_P,	_P,
	_N,	_N,	_N,	_N,	_N,	_N,	_N,	_N,
	_N,	_N,	_P,	_P,	_P,	_P,	_P,	_P,
	_P,	_U|_X,	_U|_X,	_U|_X,	_U|_X,	_U|_X,	_U|_X,	_U,
	_U,	_U,	_U,	_U,	_U,	_U,	_U,	_U,
	_U,	_U,	_U,	_U,	_U,	_U,	_U,	_U,
	_U,	_U,	_U,	_P,	_P,	_P,	_P,	_P,
	_P,	_L|_X,	_L|_X,	_L|_X,	_L|_X,	_L|_X,	_L|_X,	_L,
	_L,	_L,	_L,	_L,	_L,	_L,	_L,	_L,
	_L,	_L,	_L,	_L,	_L,	_L,	_L,	_L,
	_L,	_L,	_L,	_P,	_P,	_P,	_P,	_C
};
