
/*
 * nromio.S -- Character i/o subroutines for the RAMless-Monitor
 * copyright (c) American Information Systems Corporation
 *	Dock Williams
 *	February, 1984		updated for system 5.2 July, 1984
 *
 *
 * printm -- print the null terminated message at the address in r3
 *	in:	r5	string address
 *	in:	r7	return address for when finished printing string
 * uses:
 *	r5 next character to output, low byte
 *	r5 pointer to string, upper three bytes
 *	r6 gets return address for outc
 *	r7 return address, hi level, when finished printing string
 */
printm:
	movb	0(r5),r6	/* get character to print */
	addqd	1,r5		/* increment string pointer */
	cmpqb	0,r6		/* check for null */
	beq	prtret		/* are we finished yet */
	rotd	8,r5		/* store pointer in upper bytes */
	movb	r6,r5		/* byte to output */
	addr	outret,r6	/* return address for outc */
	br	outc		/* go print the character */
outret:
	rotd	-8,r5
	br	printm
prtret:


	jump	0(r7)		/* message out use return address */

/*  */


	/* outc -- print out the charcter in r5 to the console
	 *	in:	R5	character to print
	 *	in:	R6	return address for outc
	 *	in:	R7	return address for high level
	 * uses R4, MOD, and SP registers
	 */

outc:

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* characters to read */
	bfs	rxc
	tbitb	U_B_TXRDY,@(UART0+U_STAT)	/* wait til ok to write more */
	bfc	outc
	movb	r5,@(UART0+U_ODATA)		/* write out character */

outcret:
	tbitb	U_B_TXEMPTY,@(UART0+U_STAT)	/* wait for transmitter empty */
	bfc	outcret				/* before returning */
#endif /************************* CPU REVISION-2A **********************/
	jump	0(r6)			/* use return address */
rxc:
	lprw	mod,r5			/* save the output character */
	lprd	fp,r6			/* and return address */

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
	movb	@(UART0+U_IDATA),r5	/* read the pending character */
#endif /************************* CPU REVISION-2A **********************/

	addr	rxlp,r6		/* set a dummy return address */
	cmpb	r5,CTRL_S	/* stop output? */
	beq	inc		/* yes...go wait for an input */
	cmpb	r5,ESC		/* cancel output? */
	beq	ramless_quiet	/* yes...jump to monitor entry */
	br	outc		/* otherwise, throw it away */
rxlp:
	cmpb	r5,ESC		/* got an input character after CTRL_S */
	beq	ramless_quiet	/* jump back quietly */
	cmpb	r5,CTRL_Q	/* enable output? */
	bne	inc		/* no....keep reading */
dooutc:
	sprd	mod,r5		/* CTRL_Q arrived so restore print state */
	sprd	fp,r6		/* and return address */
	br	outc		/* and retry character output */

/*  */

	/* inc */
	/* read a character from the console port */
	/* r5 character read in */
	/* r6 return address */
inc:	

#ifdef REV_1A /****************** CPU REVISION-1A **********************/
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming character ready? */
	bfc	inc			/* no....wait forever */
	movb	@(UART0+U_IDATA),r5		/* yes...get the character */
#endif /************************* CPU REVISION-1A **********************/

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming character ready? */
	bfc	inc			/* no....wait forever */
	movb	@(UART0+U_IDATA),r5		/* yes...get the character */
#endif /************************* CPU REVISION-2A **********************/

	andb	0x7f,r5		/* only look at seven bits */
	cmpb	r5,0x61		/* map to upper case */
	blo	uprcas
	cmpb	r5,0x7a
	bhi	uprcas
	subb	0x20,r5
uprcas:				/* check for escape */
	cmpb	ESC,r5
	beq	ramless_quiet
r6ret:	jump	0(r6)		/* return to caller */

/*  */

	/* inc1 */
	/* read a character from the alternate port */
	/* abort if ESC from console port */
	/* r5 character read in */
	/* r6 return address */
inc1:	

#ifdef REV_1A /****************** CPU REVISION-1A **********************/
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming char on UART-0? */
	bfc	inc1chk			/* no....check UART-1 */
	movb	@(UART0+U_IDATA),r5	/* yes...read it from UART-0 */
	andb	0x7F,r5			/* clear extra bits */
	cmpb	r5,ESC			/* ESCAPE? */
	beq	ramless_quiet		/* yes...quit waiting for UART-1 */
inc1chk:
	tbitb	U_B_RXRDY,@(UART1+U_STAT)	/* incoming char ready? */
	bfc	inc1			/* no....try again */
	movb	@(UART1+U_IDATA),r5	/* yes...get the character */
#endif /************************* CPU REVISION-1A **********************/

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
	tbitb	U_B_RXRDY,@(UART0+U_STAT)	/* incoming char on UART-0? */
	bfc	inc1chk			/* no....check UART-1 */
	movb	@(UART0+U_IDATA),r5	/* yes...read it from UART-0 */
	andb	0x7F,r5			/* clear extra bits */
	cmpb	r5,ESC			/* ESCAPE? */
	beq	ramless_quiet		/* yes...quit waiting for UART-1 */
inc1chk:
	tbitb	U_B_RXRDY,@(UART1+U_STAT)	/* incoming char ready? */
	bfc	inc1			/* no....try again */
	movb	@(UART1+U_IDATA),r5	/* yes...get the character */
#endif /************************* CPU REVISION-2A **********************/

	br	r6ret			/* use return address */

