
struct real_time_clock {	/* offset - R/W, usage, legal values */
	int	control;	/* 0 - split R/W control register */
	int	tenthsec;	/* 4 - read only, tenths of seconds; 0-9 */
	int	sec;		/* 8 - R/W, unit seconds; 0-9 */
	int	tensec;		/* c - R/W, tens of seconds; 0-5 */
	int	min;		/* 10 - R/W, unit minutes; 0-9 */
	int	tenmin;		/* 14 - R/W, tens of minutes; 0-5 */
	int	hour;		/* 18 - R/W, unit hours; 0-9 */
	int	tenhour;	/* 1c - R/W, tens of hours; 0 or 1 */
	int	dayom;		/* 20 - R/W, day of month, unit; 0-9 */
	int	tendayom;	/* 24 - R/W, tens of day of month; 1-3 */
	int	month;		/* 28 - R/W, unit month; 0-9 */
	int	tenmonth;	/* 2c - R/W, tens of months; 0 or 1 */
	int	year;		/* 30 - R/W, units year; 0-9  */
	int	tenyear;	/* 34 - R/W, tens of years; 0-9 */
	int	weekday;	/* 38 - R/W, day of week; 1-7 */
	int	interrupt;	/* 3c - interrupt control */
} RTC;

/* structure for holding time */
struct time_val {
	char	tenthsec;
	char	sec;	
	char	tensec;
	char	min;
	char	tenmin;
	char	hour;
	char	tenhour;
	char	dayom;
	char	tendayom;
	char	month;	
	char	tenmonth;
	char	year;	
	char	tenyear;
	char	weekday;
} TIMEVAL;

/* control register definitions */
#define RTC_INIT	0x0f;		/* disable interrupts */
					/* stop clock and interrupt timers */
#define RTC_CLKSET	0x05;		/* select normal, clock setting */
					/* clock and interrutps stopped */
#define	RTC_START	0x00;		/* start the real time clock */

/* interrupt register definitions */
#define	RTC_NOINTS	0x00;		/* no interrupts */

