






































	.file	"raml.s"






















































































































































































































































































































































					


						




						





						


						


						


						


						



						







































































































	
















































































































































































































				







































	.set	BCKSPC,0x08
	.set	TAB,0x09
	.set	SPC,0x20	
	.set	BELL,0x07
	.set	CR,0x0D
	.set	LF,0x0A
	.set	ESC,0x1B
	.set	CTRL_Q,0x11
	.set	CTRL_S,0x13
	.set	SLASH,0x2f
	.set	BACKSLASH,0x5c
	.set	DEL,0x7F

	.globl	_ramless_monitor
	.globl	ramless_quiet
	.globl	epushc
	.globl	pushc	
	.globl	erase	





_ramless_monitor:
	







	movb	$((0x08 | 0x10 | 0x20 | 0x40) | 0x80), @(0x00FFFF02 + 0x3C)

	addr	_RMbootmsg,r5		
	addr	lab1,r7			
	br	printm
lab1:
	addr	_copyright,r5		
	addr	lab2,r7			
	br	printm
lab2:
	addr	_corporation,r5		
	addr	ramless_quiet,r7	
	br	printm

break:
	bpt				
	br	_ramless_monitor	





ramless_quiet:				

	
	movb	$0x20,@(0x3C+0x00FFFF43)

	
	movb	$((0x08 | 0x10 | 0x20 | 0x40) | 0x80), @(0x00FFFF02 + 0x3C)

	movqd	$0,r0
	lprw	mod,r0		


	lmr	msr,r0		


	addr	getinpl,r7	
	br	crlf		
getinpl:
	bicpsrw	$(0x0800 | 0x0200 | 0x0100) 
	addr	sprompt,r5
	addr	getv,r7
	br	printm
sprompt:
	.byte	0x52		
	.byte	0x4d
	.byte	0x3e
	.byte	SPC
	.byte	0

getv:
	movqd	$0,r0		
	movqd	$0,r1
	movqd	$0,r2
	movqd	$0,r3
	movqd	$0,r4
	movqd	$0,r5
	bispsrw	$0x0200		
	lprd	sp,r0		
	bicpsrw	$0x0200		

	
getc:
	addr	chkinc,r6
	br	inc



	
chkinc:
	cmpb	r5,$TAB
	beq	pushspc
	cmpb	r5,$BCKSPC
	beq	erase
	cmpb	r5,$DEL
	beq	erase
	cmpb	r5,$LF
	beq	openchk
	cmpb	r5,$CR
	beq	openchk
	cmpb	r5,$'^'
	beq	openchk
	cmpb	r5,$'+'
	beq	openchk
	cmpb	r5,$'-'
	beq	openchk
	cmpb	r5,$'?'
	beq	epushc
	cmpb	r5,$'@'
	beq	openchk
	cmpb	r5,$SPC
	blt	getc		
	beq	epushc
	cmpb	r5,$'`'
	beq	reopen
	cmpb	r5,$BACKSLASH
	beq	reopen
	cmpb	r5,$SLASH
	beq	reopen
	cmpb	r5,$'0'
	blt	getc		
	cmpb	r5,$'9'
	ble	epushc
	cmpb	r5,$'A'
	blt	getc		
	cmpb	r5,$'Z'
	ble	epushc
	br	getc		



openchk:
	sprd	mod,r6
	cmpb	$SLASH,r6	
	beq	savtype
	cmpb	$BACKSLASH,r6
	beq	savtype
	cmpb	$'`',r6
	beq	savtype
	cmpb	$'^',r5		
	beq	error
	cmpb	$'+',r5
	beq	error
	cmpb	$'-',r5
	beq	error
	cmpb	$'@',r5
	beq	error

	movd	r5,r6
	movqd	$0,r7		
	movqb	$0,r5		
rechk:
	cmpb	r6,$CR		
	beq	rshift6		
	cmpb	r6,$SPC
	beq	rshift6
	cmpb	r6,$TAB
	beq	rshift6
	cmpqb	$0,r6
	beq	ramless_quiet
	lprd	mod,r6		
	br	convertinput	
rshift6:
	lshd	$-8,r6
	addb	$-8,r7		
	lshd	r7,r5		
	movqb	$0,r5		
	negb	r7,r7		
	lshd	r7,r5
	negb	r7,r7		
	br	rechk



savtype:
	rotd	$-8,r6		
	movb	r5,r6		
	rotd	$8,r6
	lprw	mod,r6		
	cmpb	$'^',r5		
	beq	echocmd		
	cmpb	$'@',r5		
	bne	convertinput	
echocmd:
	addr	convertinput,r6	
	br	outc

reopen:
	addr	openecho,r6	
	br	outc		
openecho:
	lprd	mod,r5
	rotd	$-8,r5
	cmpqb	$0,r5
	beq	open
	rotd	$8,r5
	br	convertinput	



	
	
	
pushspc:
	movb	$SPC,r5
	br	epushc

	#echo and then push onto the input queue
epushc:
	addr	chkqueue,r6
	br 	boutc
chkqueue: 			
	cmpqb	$0,r0		
	bne	fifovflow

	
	addr	getc,r7

	
pushc:	
	rotd	$8,r1
	movb	r1,r0
	rotd	$-8,r0
	rotd	$8,r2
	movb	r2,r1
	rotd	$8,r3
	movb	r3,r2
	rotd	$8,r4
	movb	r4,r3
	rotd	$8,r5
	movb	r5,r4
	jump	0(r7)



	
erase:	
	rotd	$-8,r5
	cmpqb	$0,r5		
	rotd	$8,r5
	beq	getc		
	
	movb	$BCKSPC,r5	
	addr	erase1,r6
	br	boutc
erase1:
	movb	$SPC,r5
	addr	backspace,r6
	br	boutc
backspace:
	movb	$BCKSPC,r5
	addr	popc,r6
boutc:	br	outc

popc:				
	movb	r4,r5
	rotd	$-8,r5
	movb	r3,r4
	rotd	$-8,r4
	movb	r2,r3
	rotd	$-8,r3
	movb	r1,r2
	rotd	$-8,r2
	movb	r0,r1
	rotd	$-8,r1
	movqb	$0,r0
	rotd	$8,r0
	br	getc



	
	

convertinput:
	movqd	$0,r6

	
head5:
	cmpqb	$0,r0		
	beq	pump5		
	cmpb	$SPC,r0
	bne	conv5
pump5:
	movqb	$0,r5

	
	cmpqd	$0,r0
	bne	gotsome
	cmpqd	$0,r1
	bne	gotsome
	cmpqd	$0,r2
	bne	gotsome
	cmpqd	$0,r3
	bne	gotsome
	cmpqd	$0,r4
	bne	gotsome
	cmpqd	$0,r5
	beq	svinr2		
gotsome:
	addr	head5,r7
	br	pushc
		
conv5:
	movb	r0,r5

	cmpb	r5,$'0'
	blt	svinr4
	cmpb	r5,$'9'
	ble	digitcv5
	cmpb	r5,$'A'
	blt	svinr4
	cmpb	r5,$'F'
	ble	atoxcv5
	br	svinr4
digitcv5:
	subb	$0x30,r5
	br	shiftd5
atoxcv5:
	subb	$0x37,r5
shiftd5:
	lshd	$4,r6
	orb	r5,r6
	movqb	$0,r5

	
	bispsrw	$0x0200		
	adjspb	$-1		
	bicpsrw	$0x0200		

	addr	conv5,r7
	br	pushc



	
svinr4:
	movd	r6,r4
	movqd	$0,r6

	
head4:
	cmpb	$SPC,r0
	bne	conv4
pump4:
	addr	head4,r7
push4c:
	rotd	$8,r1
	movb	r1,r0
	rotd	$-8,r0
	rotd	$8,r2
	movb	r2,r1
	rotd	$8,r3
	movb	r3,r2
	movqb	$0,r3
	jump	0(r7)
conv4:
	movb	r0,r5
	cmpb	r5,$'0'
	blt	svinr3
	cmpb	r5,$'9'
	ble	digitcv4
	cmpb	r5,$'A'
	blt	svinr3
	cmpb	r5,$'F'
	ble	atoxcv4
	br	svinr3
digitcv4:
	subb	$0x30,r5
	br	shiftd4
atoxcv4:
	subb	$0x37,r5
shiftd4:
	lshd	$4,r6
	orb	r5,r6
	movqb	$0,r5

	addr	conv4,r7
	br	push4c



	
svinr3:
	movd	r6,r3
	movqd	$0,r6

head3:
	cmpb	$SPC,r0
	bne	conv3
pump3:
	addr	head3,r7
push3c:
	rotd	$8,r1
	movb	r1,r0
	rotd	$-8,r0
	rotd	$8,r2
	movb	r2,r1
	movqb	$0,r2
	jump	0(r7)

conv3:
	movb	r0,r5

	cmpb	r5,$'0'
	blt	svinr2
	cmpb	r5,$'9'
	ble	digitcv3
	cmpb	r5,$'A'
	blt	svinr2
	cmpb	r5,$'F'
	ble	atoxcv3
	br	svinr2
digitcv3:
	subb	$0x30,r5
	br	shiftd3
atoxcv3:
	subb	$0x37,r5
shiftd3:
	lshd	$4,r6
	orb	r5,r6

	addr	conv3,r7
	br	push3c





svinr2:
	movd	r6,r2		
	movd	r3,r1		
	movd	r4,r0		

	sprd	mod,r6
	cmpb	$SLASH,r6
	beq	opchk
	cmpb	$BACKSLASH,r6
	beq	opchk
	cmpb	$'`',r6
	bne	docommand
opchk:
	rotd	$-8,r6
	cmpb	$'+',r6
	beq	forward
	cmpb	$'-',r6
	beq	backward
	cmpb	$CR,r6
	beq	wrt
	cmpb	$LF,r6
	beq	nxtwrt
	cmpb	$'^',r6
	beq	prevwrt
	cmpb	$'@',r6
	beq	movtoloc
	lprd	fp,r0
	br	open



	
	
	
forward:
	movb	r6,r5
	addr	echoforw,r6
	br	outc
echoforw:
	cmpqb	$0,r0
	beq	plusdef
	addr	0(fp),r6
	addd	r0,r6
	lprd	fp,r6
	br	opcrlf

plusdef:
	sprw	mod,r6
	cmpb	$SLASH,r6
	beq	plus4
	cmpb	$BACKSLASH,r6
	beq	plus2
	cmpb	$'`',r6
	bne	error
plus1:
	addr	1(fp),r6
	lprd	fp,r6
	br	opcrlf
plus2:
	addr	2(fp),r6
	lprd	fp,r6
	br	opcrlf
plus4:
	addr	4(fp),r6
	lprd	fp,r6
	br	opcrlf

opcrlf:
	addr	open,r7		
	br	crlf		



	
	
backward:
	movb	r6,r5
	addr	echoback,r6
	br	outc
echoback:
	cmpb	$0,r0
	beq	minusdef
	addr	0(fp),r6
	subd	r0,r6
	lprd	fp,r6
	br	opcrlf
minusdef:
	sprw	mod,r6
	cmpb	$SLASH,r6
	beq	minus4
	cmpb	$BACKSLASH,r6
	beq	minus2
	cmpb	$'`',r6
	bne	error
minus1:
	addr	-1(fp),r6
	lprd	fp,r6
	br	opcrlf
minus2:
	addr	-2(fp),r6
	lprd	fp,r6
	br	opcrlf
minus4:
	addr	-4(fp),r6
	lprd	fp,r6
	br	opcrlf



	
	
prevwrt:
	bispsrw	$0x0200		
	sprd	sp,r6
	bicpsrw	$0x0200		
	cmpqd	$0,r6
	beq	minusdef
	addr	minusdef,r7
	br	wrtaloc

	
	
nxtwrt:
	bispsrw	$0x0200		
	sprd	sp,r6
	bicpsrw	$0x0200		
	cmpqd	$0,r6
	beq	plusdef		
	addr	plusdef,r7	
	br	wrtaloc

	
	
wrt:
	bispsrw	$0x0200		
	sprd	sp,r6
	bicpsrw	$0x0200		
	cmpqd	$0,r6
	beq	ramless_quiet
	addr	ramless_quiet,r7
	br	wrtaloc



	
wrtaloc:
	sprd	mod,r6		
	cmpb	$SLASH,r6
	beq	wrtdouble
	cmpb	$BACKSLASH,r6
	beq	wrtword
	cmpb	$'`',r6
	bne	error
wrtbyte:
	movb	r0,0(fp)
	br	r7ret
wrtword:
	movw	r0,0(fp)
	br	r7ret
wrtdouble:
	movd	r0,0(fp)
r7ret:
	jump	0(r7)



movtoloc:
	movd	0(fp),r6
	lprd	fp,r6
	br	opcrlf



error:
	addr	errmsg,r5
	addr	getinpl,r7
	br	printm

errmsg:	.byte	CR		
	.byte	LF		
	.byte	0x3f		
	.byte	0x3f		
	.byte	0

fifovflow:
	addr	_fifomsg,r5
	addr	ramless_quiet,r7
	br	printm
















	.globl	_loadmsg
	.globl	_badtxchk
	.globl	_badmemchk
	.globl	_loadaddrmsg
	.globl	_sizemsg
	.globl	cmddsp

docommand:
	addr	cmddsp,r7
	br	crlf
cmddsp:		
	sprd	mod,r3		
	cmpqd	$0,r3		
	beq	getinpl		
	cmpb	$'C',r3		
	beq	rmlcmp
	cmpb	$'D',r3		
	beq	rmldump
	cmpb	$'F',r3		
	beq	rmlfill
	cmpb	$'G',r3		
	beq	rmlgo
	cmpb	$'M',r3		
	beq	rmlmove
	cmpb	$'I',r3		
	beq	rmlload
	cmpb	$'X',r3		
	beq	wrlp
	cmpb	$'Y',r3		
	beq	rdlp
	cmpb	$'Z',r3		
	beq	zap
				

	cmpb	$'R',r3		
	beq	ramdiag
	cmpb	$'?',r3		
	beq	rmlhelp
	br	getinpl




	
	
	
	
	
ramdiag:
	jump	ram_DIAG


	
	
	
rmlgo:
	jump	0(r0)


	
	
	
	
	
rmlmove:
	movb	0(r0),0(r1)	
	addqd	$1,r0
	addqd	$1,r1
	acbd	$-1,r2,rmlmove
	br	getinpl


	
	
	
	
	
rmlfill:
	movb	r2,0(r0)
	addqd	$1,r0
	acbd	$-1,r1,rmlfill
	br	getinpl


	
	
	
	
	
	
	
zap:
	cmpb	r3,$0x0d	
	beq	dwrt
	cmpb	r3,$0x0b	
	beq	bwrt
wwrt:				
	movw	r1,0(r0)
	br	getinpl
bwrt:
	movb	r1,0(r0)	
	br	getinpl
dwrt:
	movd	r1,0(r0)	
	br	getinpl



	
	
	
	
	
rmlcmp:
	cmpb	0(r0),0(r1)	
	beq	nbytcmp

	movd	r0,r5
	addr	val2eq,r7
	br	cvprtd
val2eq:
	movb	$'=',r5
	addr	valr2,r6
	br	outc
valr2:
	movb	0(r0),r5
	addr	spcout,r7
	br	cvprtb
spcout:
	movb	$SPC,r5
	addr	adrr1,r6
	br	outc
adrr1:
	movd	r1,r5
	addr	val1eq,r7
	br	cvprtd
val1eq:
	movb	$'=',r5
	addr	valr1,r6
	br	outc
valr1:
	movb	0(r1),r5
	addr	docrlf,r7
	br	cvprtb
docrlf:
	addr	nbytcmp,r7
	br	crlf
nbytcmp:
	addqd	$1,r0
	addqd	$1,r1
	acbd	$-1,r2,rmlcmp
	br	getinpl



	
	
	
	
	
rmldump:
	addr	datapr,r7		
	movd	r0,r5
	br	cvprt3
datapr:	movd	$16,r2			
spc0:	addr	pr3spc,r5		
	addr	spc1,r7
	br	printm
pr3spc: 
	.byte	SPC
	.byte	SPC
	.byte	SPC
	.byte	0
spc1:	movb	0(r0),r5		
	addr	spc2,r7
	br	cvprtb
spc2:	movb	$SPC,r5			
	addr	incr1,r6
	br	outc
incr1:
	addqd	$1,r0			
	addqd	$-1,r1			
	cmpqd	$0,r1
	bge	ramless_quiet		
	acbd	$-1,r2,spc1		
	addr	rmldump,r7		
	br	crlf			



	
	
	
rmlenable:
	cmpqb	$0,r0			
	beq	mapoff

	
	movb	$0x08,@(0x00FFFF43 + 0x38)
	br	getout
mapoff:
	
	movb	$0x08,@(0x00FFFF43 + 0x3C)
getout:	br	ramless_quiet




	
	
LSYNC:
				
	.byte	0x4c		
	.byte	0x53		
	.byte	0x49		
	.byte	0x41		
rmlload:
	addr	_loadmsg,r5
	addr    gsync,r7
	br	printm
gsync:
	movb	$0x20,@(0x38+0x00FFFF43)	

	addr	sychk,r6	
	br	inc1
sychk:	movb	r5,r4
	cmpd	LSYNC,r4
	lshd	$8,r4
	bne	gsync

	movqd	$4,r3		
ldadrlp:
	addr	ldadr,r6
	br	inc1
ldadr:	rotd	$8,r0
	movb	r5,r0
	acbd	$-1,r3,ldadrlp
	lprd	sb,r0


	movb	$'.',@(0x00FFFF02+0x0C)


	movqd	$4,r3		
numbylp:
	addr	numby,r6
	br	inc1
numby:	rotd	$8,r1
	movb	r5,r1
	acbd	$-1,r3,numbylp
	lprd	sp,r1


	movb	$'.',@(0x00FFFF02+0x0C)


	movqd	$4,r3		
chksmlp:
	addr	chksm,r6
	br	inc1
chksm:	rotd	$8,r2
	movb	r5,r2
	acbd	$-1,r3,chksmlp


	movb	$'.',@(0x00FFFF02+0x0C)


	movqd	$0,r4		
readdat:
	addr	calcu,r6
	br	inc1		
calcu:
	movzbd	r5,r5		
	addd	r5,r4		
	movb	r5,0(r0)	
	addqd	$1,r0		
	acbd	$-1,r1,readdat	

	cmpd	r2,r4		
	beq	goodtc		
badtchk:
	addr	_badtxchk,r5	
badchk:
	addr	ramless_quiet,r7	
	br	printm

badmchk:
	addr	_badmemchk,r5
	br	badchk

goodtc:				
	movqd	$0,r4		
	sprd	sb,r0		
	sprd	sp,r1		
mchklp:
	movzbd	0(r0),r5	
	addd	r5,r4		
	addqd	$1,r0		
	acbd	$-1,r1,mchklp	
	
	cmpd	r2,r4
	bne	badmchk			
goodmc:
	addr	_loadaddrmsg,r5		
	addr	prtaddr,r7
	br	printm
prtaddr:
	sprd	sb,r5			
	addr	printsize,r7
	br	cvprt3
printsize:
	addr	_sizemsg,r5		
	addr	prtsize,r7
	br	printm
prtsize:
	sprd	sp,r5			
	addr	ramless_quiet,r7	
	br	cvprt3



	
	
	
open:
	sprd	mod,r2		
	sprd	fp,r5		
	addr	pr1sp,r7
	br	cvprt3		
pr1sp:
	movb	$SPC,r5		
	addr	sizsel,r6
	br	outc
sizsel:
	cmpb	$SLASH,r2
	beq	dvpr		
	cmpb	$BACKSLASH,r2
	beq	wvpr		
	cmpb	$'`',r2
	beq	bvpr		

	
	
dvpr:
	movd	0(fp),r5	
	addr	getdv,r7
	br	cvprtd
getdv:
	movb	$SPC,r5
	addr	getv,r6
	br	outc		

	
	
wvpr:
	movw	0(fp),r5	
	addr	getwv,r7
	br	cvprtw
getwv:
	movb	$SPC,r5
	addr	getv,r6
	br	outc		

	
	
bvpr:
	movb	0(fp),r5	
	addr	getbv,r7
	br	cvprtb
getbv:
	movb	$SPC,r5
	addr	getv,r6
	br	outc		



	
wrlp:	addr	wrlp,r7		
	movb	r1,0(r0)
	br	chkesc		

	
rdlp:	addr	rdlp,r7		
	movb	0(r0),r1
	br	chkesc		

	
wrrdlp:	addr	wrrdlp,r7	
	movb	r1,0(r0)
	movb	0(r0),r2
				













	.globl	chkesc
chkesc:



	tbitb	$0,@(0x00FFFF02+0x04)	
	bfc	noescape		
	movb	@(0x00FFFF02+0x0C),r6	


	andb	$0x7F,r6		
	cmpb	r6,$ESC			
	beq	ramless_quiet		
noescape:
	jump	0(r7)			














	
cvprtd: movd	r5,r4
	movxbd	$-28,r3		
	br	conv

	
cvprt3: movd	r5,r4
	movxbd	$-20,r3		
	br	conv

	
cvprtw: movd	r5,r4
	movxbd	$-12,r3		
	br	conv

	
cvprtb: movd	r5,r4
	movqd	$-4,r3		
conv:
	lshd	r3,r5		
	andb	$0x0f,r5	
	cmpb	r5,$0x0a	
	bge	pralph		
	addb	$0x30,r5	
prout:
	addr	nxt4,r6
	br	outc		
pralph:	
	addb	$0x37,r5	
	br	prout
nxt4:
	movd	r4,r5		
	addqd	$4,r3		
	cmpqb	$4,r3		
	ble	cvret
	br	conv		
cvret:	jump	0(r7)		




	
	
crlf:
	movb	$CR,r5		
	addr	plf,r6
	br	outc
plf:
	movb	$LF,r5		
	movd	r7,r6
	br	outc



















	.globl	printm
	.globl	inc
	.globl	inc1
	.globl	outc

printm:
	movb	0(r5),r6	
	addqd	$1,r5		
	cmpqb	$0,r6		
	beq	prtret		
	rotd	$8,r5		
	movb	r6,r5		
	addr	outret,r6	
	br	outc		
outret:
	rotd	$-8,r5
	br	printm
prtret:


	jump	0(r7)		




	






outc:


	tbitb	$0,@(0x00FFFF02+0x04)	
	bfs	rxc
	tbitb	$2,@(0x00FFFF02+0x04)	
	bfc	outc
	movb	r5,@(0x00FFFF02+0x0C)		

outcret:
	tbitb	$3,@(0x00FFFF02+0x04)	
	bfc	outcret				

	jump	0(r6)			
rxc:
	lprw	mod,r5			
	lprd	fp,r6			


	movb	@(0x00FFFF02+0x0C),r5	


	addr	rxlp,r6		
	cmpb	r5,$CTRL_S	
	beq	inc		
	cmpb	r5,$ESC		
	beq	ramless_quiet	
	br	outc		
rxlp:
	cmpb	r5,$ESC		
	beq	ramless_quiet	
	cmpb	r5,$CTRL_Q	
	bne	inc		
dooutc:
	sprd	mod,r5		
	sprd	fp,r6		
	br	outc		



	
	
	
	
inc:	




	tbitb	$0,@(0x00FFFF02+0x04)	
	bfc	inc			
	movb	@(0x00FFFF02+0x0C),r5		


	andb	$0x7f,r5	
	cmpb	r5,$0x61	
	blo	uprcas
	cmpb	r5,$0x7a
	bhi	uprcas
	subb	$0x20,r5
uprcas:				
	cmpb	$ESC,r5
	beq	ramless_quiet
r6ret:	jump	0(r6)		



	
	
	
	
	
inc1:	




	tbitb	$0,@(0x00FFFF02+0x04)	
	bfc	inc1chk			
	movb	@(0x00FFFF02+0x0C),r5	
	andb	$0x7F,r5			
	cmpb	r5,$ESC			
	beq	ramless_quiet		
inc1chk:
	tbitb	$0,@(0x00FFFF22+0x04)	
	bfc	inc1			
	movb	@(0x00FFFF22+0x0C),r5	


	br	r6ret			












	.globl _cmdc
	.globl _cmdcsyn
	.globl _cmdd
	.globl _cmddsyn
	.globl _cmdf
	.globl _cmdfsyn
	.globl _cmdg
	.globl _cmdgsyn
	.globl _cmdh
	.globl _cmdhsyn
	.globl _cmdi
	.globl _cmdisyn
	.globl _cmdm
	.globl _cmdmsyn
	.globl _cmdo
	.globl _cmdosyn
	.globl _cmdz
	.globl _cmdzsyn
	.globl _cmdr
	.globl _cmdrsyn

msgarray:	
	.double _cmdh
	.double _cmdhsyn
	.double _cmdc
	.double _cmdcsyn
	.double _cmdd
	.double _cmddsyn
	.double _cmdf
	.double _cmdfsyn
	.double _cmdg
	.double _cmdgsyn
	.double _cmdi
	.double _cmdisyn
	.double _cmdm
	.double _cmdmsyn
	.double _cmdo
	.double _cmdosyn
	.double _cmdz
	.double _cmdzsyn
	.double _cmdr
	.double _cmdrsyn
	.double 0,0
dashstr:
	.byte	0x20,0x2d,0x20,0	

rmlhelp:
	addr	msgarray,r0
sprloop:
	movd	0(r0),r5		
	addr	sprdash,r7
	br	printm
sprdash:
	addr	dashstr,r5		
	addr	sprsyn,r7
	br	printm
sprsyn:	
	addqd	$4,r0			
	movd	0(r0),r5
	addr	sprret,r7
	br	printm
sprret:
	addr	sprchk,r7		
	br	crlf
sprchk:
	addqd	$4,r0
	cmpqd	$0,0(r0)			
	bne	sprloop			
	br	getinpl			

