/*
 * romsub.s -- Subroutines for the RAMless-Monitor
 * copyright (c) American Information Systems Corporation
 *	Dock Williams
 *	February, 1984		updated for system 5.2 July, 1984
 *
 * chkesc -- Check for ESCAPE on UART-0
 *	in:	r7	return address
 *	Jumps to ramless_quiet of <ESC> typed
 *	Uses R6
 */
	.globl	chkesc
chkesc:
#ifdef REV_1A /****************** CPU REVISION-1A **********************/
	tbitb	$U_B_RXRDY,@(UART0+U_STAT) /*  incoming char on UART-0? */
	bfc	noescape		/*  no....there is no escape */
	movb	@(UART0+U_IDATA),r6	/* yes...read it from UART-0 */
#endif /************************* CPU REVISION-1A **********************/

#ifdef REV_2A /****************** CPU REVISION-2A **********************/
	tbitb	$U_B_RXRDY,@(UART0+U_STAT)	/*  incoming char on UART-0? */
	bfc	noescape		/*  no....there is no escape */
	movb	@(UART0+U_IDATA),r6	/*  yes...read it from UART-0 */
#endif /************************* CPU REVISION-2A **********************/

	andb	$0x7F,r6		/* clear extra bits */
	cmpb	r6,$ESC			/* ESCAPE? */
	beq	ramless_quiet		/* yes...quit waiting for UART-1 */
noescape:
	jump	0(r7)			/* use return address */

/*  */

/*
 * cvprtb - cvprtw - cvprt3 - cvprtd -- Print hex values
 *	in:	R5	Value to print
 *	in:	R7	Return address
 *	R4	copy of value to print
 *	R3	shift to get significant byte into low byte of register
 *	Prints the hex value (byte, word, or double)
 *	in R5 on the console terminal, and returns thru R7.
 *	Uses R3-R6 for the conversion algorithm.
 */

	/* convert the double word value in r5 to hex and print it */
cvprtd: movd	r5,r4
	movxbd	$-28,r3		/* shift distance */
	br	conv

	/* convert the 3 byte value in r5 to hex and print it */
cvprt3: movd	r5,r4
	movxbd	$-20,r3		/* shift distance */
	br	conv

	/* convert the word value in r5 to hex and print it */
cvprtw: movd	r5,r4
	movxbd	$-12,r3		/* shift distance */
	br	conv

	/* convert the byte value in r5 to hex and print it */
cvprtb: movd	r5,r4
	movqd	$-4,r3		/* shift distance */
conv:
	lshd	r3,r5		/* get nibble in lower byte */
	andb	$0x0f,r5	/* mask off the rest */
	cmpb	r5,$0x0a	/* is it a digit */
	bge	pralph		/* no, print the alpha character */
	addb	$0x30,r5	/* yes convert to digit hex */
prout:
	addr	nxt4,r6
	br	outc		/* print the converted nibble */
pralph:	
	addb	$0x37,r5	/* convert to alpha hex */
	br	prout
nxt4:
	movd	r4,r5		/* restore r5 */
	addqd	$4,r3		/* rotate more */
	cmpqb	$4,r3		/* check if done */
	ble	cvret
	br	conv		/* convert another digit */
cvret:	jump	0(r7)		/* return */

/*  */


	/* crlf -- output a carriage return and line feed */
	/* 	in:	R7	return address */
crlf:
	movb	$CR,r5		/* output carriage return */
	addr	plf,r6
	br	outc
plf:
	movb	$LF,r5		/* output line feed */
	movd	r7,r6
	br	outc

/*  */
