/*  3200mmu.h -- Define Memory Management Unit Structures
 *  copyright (c) American Information Systems Corporation
 *
 *	Daniel Steinberg
 *	November, 1984
 */
#ifndef MMU3200
#define MMU3200

#ifdef CSOURCE
/* Define page table structures */

typedef char  PAGE_[512];			/* each Page is 512 bytes */

typedef PAGE_*  PAGE_TABLE[128];		/* each Page Table maps 64Kb */

typedef PAGE_TABLE*  SEGMENT_TABLE[256];	/* Segment Table maps 16Mb */
#endif


/* Define constants for mapping virtual to physical addresses */

#define INDEX1	0xFF0000
#define ISHFT1	14
#define INDEX2	0x00FE00
#define ISHFT2	7
#define PFN	0xFFFE00
#define OFFSET	0x0001FF
#define VALID	1


#endif
