/* cflags.h -- RAM-Monitor program execution flags
 *	Dock Williams
 *	October, 1983
 */
#ifndef CFLAGS
#define CFLAGS

/* bit definitions for cflags */
#define	CF_ESCHIT	1		/* escape character hit */
#define	CF_OUTHLD	2		/* hold ouput of characters */
#define CF_BRKREP	4		/* replace a brkpnt when step */
#define	CF_SSTEP	8		/* single stepping flag */
#define CF_TRACE	16		/* program flow tracing flag */
#define	CF_PHIDE	32		/* print hidden symbols flag */
#define CF_REGP		64		/* print regs after single stepping */
#define CF_PCPRT	128		/* print pc as stepping */
#define CF_SYMP		256		/* print symbols instead of address */
#define CF_BRKPRO	512		/* proceeding through brkpnts flag */
#define	CF_AUTOP	1024		/* autoprint when return from a */
					/* single-step or breakpoint */
#define CF_MMUBRK	2048		/* mmu breakpointing flag */
#define	CF_PHYS		4096		/* map physical address override */
#define CF_TMPBRK	8192		/* a temporary breakpoint is set */


/* bit definitions for symbol table flags */
#define	S_USED	1		/* symbol is used flag */
#define	S_HIDE	2		/* symbol is hidden, dont print when listing */
#define S_SHIDE 4		/* symbol is sometimes hidden print for opens */
#define S_PHYS	8		/* symbol refers to physical memory */

/* bit definitions for brk table flags */
#define B_NORM	1		/* this is a normal breakpoint */
#define B_TEMP	2		/* this is a temporary breakpoint */
#define B_REPL  4		/* temporarily cleared, will be replaced */

/* parameters for storage allocation */
#define	MAXSYM	75		/* maximum number of symbols */
#define	MAXINP	133		/* maximum number of input chars */
#define	MAXARG	5		/* maximum arguments for a debugger command */
	/* MAXNAM must be greater than MAXVBS for psym */
#define MAXNAM	11		/* maximum characters for a symbol name */
#define MAXVBS	9		/* maximum symbol name printed in verbose */
#define	MAXBRK	16		/* number of breakpoints */
#define MAXTRC	23		/* maximum number of tracings in trace table */

/* define special start-up initialization trap id */
#define MON_INIT -5
#define MON_START -6

/* size of name entry in breakpoint table */
/* this size is maximum that will fit neatly in brktab */
#define BRKNMSZ 9

#endif
