/* mondef.c -- type definitions for monitor data structures
 * copyright (c) 1984  American Information Systems Corporation
 *	Dock Williams
 *	July, 1984
 */

#ifndef MONDEF
#define MONDEF

#include "cflags.h"

/* Define various oft-used structures */

/* an entry in the breakpoint table */
typedef struct brkpntent {
	char	*addr;
	char	flag;
	char	ins;
	char	map;	/* one of: PHYS / T_SUPER / T_USER */
	char	name[BRKNMSZ];
} BRKPNT; 

/* entries in the opcode format tables of the disassembler */
typedef struct o1 {
	char *name;
	short val;
	char extra;
} OP1;
typedef struct o2 {
	short val, mask;
	char *name;
	char allow, type;
	char extra;
} OP2;
typedef struct o3 {
	short val, mask;
	char *name;
	char f1, f2, regf, typef;
	char extra;
} OP3;

/* an entry in the command synopsis table */
typedef struct synopent {
    char	key;
    char	*cmd;
    char	*desc;
} SYNOP;

/* a symbol table entry */
typedef struct symbol {
	struct symbol *next, *prev;
	unsigned int value;
	char	flags;
	char	name[MAXNAM];
}  SYMBOL;

/* structure for storage of mmu register contents for debugger */
typedef struct {
	int	pf1;		/* program flow register 1 */
	int	pf0;		/* program flow register 0 */
	int	sc;		/* sequential count register */
	int	bpr1;		/* breakpoint register 1 */
	int	bpr0;		/* breakpoint register 0 */
	int	bcnt;		/* breakpoint count register */
	int	eia;		/* error/invalidate address register */
	int	ptb1;		/* page table base 1 */
	int	ptb0;		/* page table base 0 */
}  MMUR;

/* definition of a structure for storing fpu registers */
typedef struct {
	int	f7;		/* the floating point registers */
	int	f6;
	int	f5;
	int	f4;
	int	f3;
	int	f2;
	int	f1;
	int	f0;
	int	fsr;
}  FPUR;


/* stucture of stack when we enter debugger */
typedef struct {
	FPUR	fpu;		/* fpu registers */
	MMUR	mmu;		/* mmu registers */
	int	id;		/* trap id */
	int	sp1;		/* user stack pointer */
	int	fp;		/* frame pointer */
	int	sb;		/* static base */
	int	r7;		/* the general purpose registers */
	int	r6;
	int	r5;
	int	r4;
	int	r3;
	int	r2;
	int	r1;
	int	r0;
	int	intbase;	/* interrupt base */
	int	sp0;		/* interrupt stack pointer */
	int	pc;		/* program counter */
	short	mod;		/* module register */
	short	psr;		/* processor status register */
	int	msr;		/* saved msr at trap */
}  INTSTACK;


#endif
