h39639
s 00038/00000/00000
d D 3.1 84/11/13 16:29:07 dan 1 0
c date and time created 84/11/13 16:29:07 by dan
e
u
U
t
T
I 1
/*  poolfuncs.h -- Declare VIOS external pool-handling functions
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef POOLFUNCS
#define POOLFUNCS


/* pool.c */

/* Lowest level pool allocation subroutines */
extern _i_pool();		/* Initialize pool structures */
extern char **_a_pool();	/* Allocate pool */
extern char **al_pool();	/* Allocate and throw ALL_FAIL on failure */
extern unsigned _f_pool();	/* Free pool */
extern unsigned vf_pool();	/* Free pool and restart waiting processes */
extern BOOLEAN chk_pool();	/* Verify that an address is a bufptr */
 
/* Interface names for low-level pool subroutines */
#define alloc(siz)	_a_pool(siz)
#define alloc_pkt(x)	((PKT_PTR)_a_pool(sizeof(IO_PACKET)))

#define free(ptr)	_f_pool(ptr)
#define free_pkt(ptr)	_f_pool(ptr)

/* Pool allocation subroutines that may throw V_ALL_FAILURE errors */
#define valloc(siz)	al_pool(siz)
#define valloc_pkt(x)	((PKT_PTR)al_pool(sizeof(IO_PACKET)))

/* vfree and vfree_pkt are used to restart any processes waiting for pool */
#define vfree(ptr)	vf_pool(ptr)
#define vfree_pkt(ptr)	vf_pool(ptr)


#endif

E 1
