/*  hostflags.h -- Define VIOS<->Host flags and static variables
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef HOSTFLAGS
#define HOSTFLAGS

#include "abusflags.h"
#include "3200config.h"
#include "hostprot.h"

/* Define some global flags, etc. */

#define Host_CSR	((UB16*)HOST_CSR)	/* Addr of on-board CSR */
#define Host_INT	((UB16*)HOST_INT)	/* Addr of Host Int Reg */



/* (AISBUSEND defined in abusflags.h) */

/* Define start of AIS/VIOS-Host Absolute-Addressed RAM */
#define HOSTSTART AISBUSEND
#define HOSTEND (HOSTSTART + sizeof(HOST_RAM))


/* Define macros to simplify future definitions */

#define Makehram(type, name) type HOST_/**/name;
#define Makehdef(name) ((HOST_RAM*)HOSTSTART)->HOST_/**/name


/*
 * Define the structure of the AIS/VIOS-Host portion of
 *	Absolute-Addressed RAM and define variables
 */

typedef struct {
				/* Define Host Protocol flags */

Makehram( PROTOCOL_BLOCK*	,Host_protocol)		/* addr of host prot */
#define Host_protocol Makehdef(Host_protocol)

				/* Host_vector must be at least sizeof(VCMD) */
Makehram( unsigned	,Host_vector)		/* host int. vector */
#define Host_vector Makehdef(Host_vector)

Makehram( unsigned	,Dp_address)		/* addr of host d-p */
#define Dp_address Makehdef(Dp_address)

Makehram( unsigned	,Dp_maxalloc)		/* bytes in largest dp buffer */
#define Dp_maxalloc Makehdef(Dp_maxalloc)

Makehram( BOOLEAN	,Dp_locked)		/* Data-page locked */
#define Dp_locked Makehdef(Dp_locked)

Makehram( BOOLEAN	,Host_connected)	/* host connected */
#define Host_connected Makehdef(Host_connected)

Makehram( BOOLEAN	,Host_crashed)		/* host had crashed */
#define Host_crashed Makehdef(Host_crashed)

Makehram( BOOLEAN	,Host_available)	/* ok to send cmd */
#define Host_available Makehdef(Host_available)

Makehram( BOOLEAN	,Host_cmdpending)	/* cmd received */
#define Host_cmdpending Makehdef(Host_cmdpending)

Makehram( BOOLEAN	,Host_unlckpending)	/* unlock data-page */
#define Host_unlckpending Makehdef(Host_unlckpending)

Makehram( short	,Host_lckpending)		/* lock data-page */
#define Host_lckpending Makehdef(Host_lckpending)

Makehram( int	,Dp_lockcnt)			/* D-p lock counter */
#define Dp_lockcnt Makehdef(Dp_lockcnt)


	}  HOST_RAM;


#endif
