/*  viosconf.h -- Header file for AIS VIOS compilations
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef VIOSCONF
#define VIOSCONF

/* define debug flags for conditional compilation */
/* #define DEBUG0	/* Enable requested info */
/* #define DEBUG1	/* Enable unrequested info */
#define DEBUG2		/* Enable data-base corruption crashes */
#define DEBUG3		/* Enable unlikely event crashes */

/* #define DEBUG_MAP	/* Enable pool mapping */

/* If the following is NOT defined, errors will issue ONLY a BPT */
/* #define DEBUG_ERROR_MSGS	/* Full messages for unrecoverable errors */


/* define Virtual Operating System support */
/* #define V_OS */


/* define VIOS pool size (in bytes) */
#define POOLSIZE (16*1024)

/* define free-running clock frequency */
#define CLOCK_HERTZ 10

#define BUFIOSIZE 0	/* maximum byte count of buffered i/o */


#ifndef ASOURCE /*** If not .S source file, include other headers ***/

/* Include configuration file for appropriate processor */
#include "vios3200.h"

/* Include standard configuration files */
#include "ais.h"
#include "vctype.h"

/* Include miscellaneous flags, etc. */
#include "viosdefs.h"

/* Include static variable definitions */
#include "viosflags.h"

#endif /* ASOURCE **************************************************/

#endif
