/*
 * promcrt0.S -- PROM Startup initialization code
 * copyright (c) American Information Systems Corporation
 *
 * Daniel Steinberg
 *	July, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 *	This module contains the initial startup code for entering the
 *	AIS Monitor/VIOS.  It MUST be located at the first address in
 *	the program text area, but will work correctly regardless of the
 *	actual address for which it is linked and/or executed.
 *
 *	On initial execution, this code determines where it is running.
 *	If it is at location 0, then a Hard Reset has just occurred
 *	and ROM is mapped over RAM address 0.  If this is the case,
 *	a branch is taken to ensure that the actual ROM addresses are issued.
 *	Once this is done, RAM Mapping may be safely enabled.
 *
 *	To build, the following files must be concatenated (in any order)
 *	after this file:
 *		romtrap.S
 */
	.file	"promcrt.s"

#include "3200config.h"

	.text

	.globl	start
start:
addr0:
	addr	.,r0		/* get current pc */

	cmpqd	$0,r0		/* if zero, reset */
	bne	relocated	/* not reset, someone jumped here */
	movd	$ROMSTART,r0	/* set address of PROM */

#ifdef ABS_AS /****************** ABSOLUTE ADDRESSING ******************/
	jump	relocated	/* skip to absolute location */
#endif /************************* ABSOLUTE ADDRESSING ******************/

#ifdef REL_AS /****************** PC-RELATIVE ADDRESSING ***************/
	jump	(relocated-start)(r0)	/* jump to offset in PROM */
#endif /************************* PC-RELATIVE ADDRESSING ***************/

				/* r0 has address of 'start' */
relocated:
	jump	prominit	/* go to initialization code in prominit.S */
