/* ramtrap.S -- RAM-Monitor trap handling
 * copyright (c) 1984  American Information Systems Corporation
 *	Daniel Steinberg
 *	July, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 *	This file establishes an interrupt dispatch table and module table entry
 *	for trap handling within the AIS/RAM-Monitor.  All traps and interrupts
 *	are caught by this module and dispatched to the current handler with
 *	interrupts disabled.
 *
 *	*** NOTE ON SB USAGE:                                              ***
 *	*** The dispatch algorithm assumes that the Static Base entry in   ***
 *	*** the Interrupt Module Table Entry is the address of a dispatch  ***
 *	*** table that contains the actual trap handling routine addresses ***
 *
 */
	.file	"ramtrap.S"

#include "32032.h"
#include "RAMmonaddr.m"

	.text

/* define macro to compute local routine offsets */
#define RVECTOR(x)	.word	A_intmod, ((x) - RAMDISPATCH)

	.align	4

RAMVECTORS:		/* RAM-Monitor Interrupt Dispatch Table */
	RVECTOR(RAMnvi)
	RVECTOR(RAMnmi)
	RVECTOR(RAMabt)
	RVECTOR(RAMfpu)
	RVECTOR(RAMill)
	RVECTOR(RAMsvc)
	RVECTOR(RAMdvz)
	RVECTOR(RAMflg)
	RVECTOR(RAMbpt)
	RVECTOR(RAMtrc)
	RVECTOR(RAMund)
	RVECTOR(RAMrsv)
	RVECTOR(RAMrsv)
	RVECTOR(RAMrsv)
	RVECTOR(RAMrsv)
	RVECTOR(RAMrsv)
	/* Interrupt handlers */
	RVECTOR(RAMvec0)
	RVECTOR(RAMvec1)
	RVECTOR(RAMvec2)
	RVECTOR(RAMvec3)
	RVECTOR(RAMvec4)
	RVECTOR(RAMvec5)
	RVECTOR(RAMvec6)
	RVECTOR(RAMvec7)
	RVECTOR(RAMvec8)
	RVECTOR(RAMvec9)
	RVECTOR(RAMvec10)
	RVECTOR(RAMvec11)
	RVECTOR(RAMvec12)
	RVECTOR(RAMvec13)
	RVECTOR(RAMvec14)
	RVECTOR(RAMvec15)

/*  */
/* RAMtrapinit() -- Initialize RAM-Monitor Module Table and interrupt dispatch
 * uses R1
 */
	.globl	RAMtrapinit
RAMtrapinit:
	jsr	init_mondispatch	/* set up dispatch table (montrap.S) */
	addr	RAMDISPATCH,@A_intmod+MOD_PB	/* Program Base in Int Mod */
	addr	@A_mondispatch,@A_state	/* dispatch to Monitor entry points */
	lprd	mod,$A_defmod		/* set default mod table address */

#ifdef IMM_AS /*************** IMMEDIATE ADDRESS FLAG ******************/
	lprd	intbase,$RAMVECTORS	/* enable trap handling */
#else  /********************** IMMEDIATE ADDRESS FLAG ******************/
	addr	RAMVECTORS,r1		/* get address of vector table */
	lprd	intbase,r1		/* load to enable trap handling */
#endif /********************** IMMEDIATE ADDRESS FLAG ******************/

	ret	$0


/* trap routines */
RAMDISPATCH:

RAMnvi:				/* interrupts disabled on nvi, nmi, & abt */
	jump	0((0*4)(sb))	/* trap number 0 */
RAMnmi:
	jump	0((1*4)(sb))	/* trap number 1 */
RAMabt:
	jump	0((2*4)(sb))	/* trap number 2 */
RAMfpu:
	bicpsrw	$PSR_I		/* disable interrupts on all other traps */
	jump	0((3*4)(sb))	/* trap number 3 */
RAMill:
	bicpsrw	$PSR_I
	jump	0((4*4)(sb))	/* trap number 4 */
RAMsvc:
	bicpsrw	$PSR_I
	jump	0((5*4)(sb))	/* trap number 5 */
RAMdvz:
	bicpsrw	$PSR_I
	jump	0((6*4)(sb))	/* trap number 6 */
RAMflg:
	bicpsrw	$PSR_I
	jump	0((7*4)(sb))	/* trap number 7 */
RAMbpt:
	bicpsrw	$PSR_I
	jump	0((8*4)(sb))	/* trap number 8 */
RAMtrc:
	bicpsrw	$PSR_I
	jump	0((9*4)(sb))	/* trap number 9 */
RAMund:
	bicpsrw	$PSR_I
	jump	0((10*4)(sb))	/* trap number 10 */
RAMrsv:
	bicpsrw	$PSR_I
	jump	0((11*4)(sb))	/* reserved traps */

RAMvec0:			/* interrupts disabled on vectored ints */
	jump	0((16*4)(sb))	/* vectored interrupts */
RAMvec1:
	jump	0((17*4)(sb))
RAMvec2:
	jump	0((18*4)(sb))
RAMvec3:
	jump	0((19*4)(sb))
RAMvec4:
	jump	0((20*4)(sb))
RAMvec5:
	jump	0((21*4)(sb))
RAMvec6:
	jump	0((22*4)(sb))
RAMvec7:
	jump	0((23*4)(sb))
RAMvec8:
	jump	0((24*4)(sb))
RAMvec9:
	jump	0((25*4)(sb))
RAMvec10:
	jump	0((26*4)(sb))
RAMvec11:
	jump	0((27*4)(sb))
RAMvec12:
	jump	0((28*4)(sb))
RAMvec13:
	jump	0((29*4)(sb))
RAMvec14:
	jump	0((30*4)(sb))
RAMvec15:
	jump	0((31*4)(sb))

