h36988
s 00099/00000/00000
d D 3.1 84/11/13 16:27:38 dan 1 0
c date and time created 84/11/13 16:27:38 by dan
e
u
U
t
T
I 1
/*  hostprot.h -- Define VIOS<->Host Communications Protocol
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef HOSTPROT
#define HOSTPROT


/* Define the VIOS<->Host command codes */

    /* Vcmd values for VIOS->Host interrupts */
#define V_RESET1   4	/* IOP Reset Level 1 */
#define V_RESET2   5	/* IOP REset Level 2 */
#define V_LOCK	   6	/* Lock host data-page */
#define V_UNLOCK   7	/* Unlock host data-page */

#define V_PIOCMD   9	/* Send Physical I/O command to IOP */
				/* hi: IOP Unit # / lo: Command code */
				/* VIOS I/O Packet Number */
				/* Parameter 1 */
				/* Parameter 2 */
				/* Parameter 3 */
				/* Parameter 4 */

#define V_VIOSTAT 10	/* Report Virtual I/O status to IOP */
				/* Offset, in data-page, of status */

#define H_ACK	   1	/* Host acknowledged VIOS command */


    /* Hcmd values for Host->VIOS interrupts */
#define H_BRK	   3	/* Break to Debugging Monitor */
#define H_RESET1   4	/* VIOS Reset Level 1 */
#define H_RESET2   5	/* VIOS Reset Level 2 */

#define H_ADDR	   6	/* Host reporting data-page address */
				/* Host address of data-page */

#define H_PIOST	   9	/* Host reporting Physical I/O status */
				/* hi: Aux. stat / lo: Status code */
				/* VIOS I/O Packet Number */
				/* Auxilliary Status 1 */
				/* Auxilliary Status 2 */
				/* Auxilliary Status 3 */
				/* Auxilliary Status 4 */

#define H_VIOCM	  10	/* Host issuing command to VIOS */
				/* Offset, in data-page, of command */

#define H_RESRC	  12	/* Host reporting "Resource Available" */
#define H_DOWN	  31	/* Host going down (IOP terminated) */

#define V_ACK	   1	/* VIOS acknowledged Host command */
#define V_CNCT	   2	/* VIOS acknowledged Host connect */


#define MAXHOSTFUNC 31	/* Max host cmd value that is not connect addr */



/* Define the VIOS<->Host protocol items */
typedef UB16 VCMD;	/* 16-bit command word */

typedef UB32 PPARAM;	/* 32-bit parameters */
			/* (although the implementation is quite tricky) */

/* Define the Host Protocol Block */
typedef struct
	{
	VCMD	hp_hcmd;	/* Host->VIOS command block */
	UB16	hp_hp[12];	/* Host->VIOS parameters */
	VCMD	hp_vcmd;	/* VIOS->Host command block */
	UB16	hp_vp[12];	/* VIOS->Host parameters */
	}  PROTOCOL_BLOCK;

/* Define macros to extract fields from the protocol block */
#define Hcmd(x)		((x).hp_hcmd)
#define Hp1lo(x)	((x).hp_hp[0])
#define Hp1hi(x)	((x).hp_hp[1])
#define Hp1(x)		(*((UB32*)(&((x).hp_hp[0]))))
#define Hp2(x)		(*((UB32*)(&((x).hp_hp[2]))))
#define Hp3(x)		(*((UB32*)(&((x).hp_hp[4]))))
#define Hp4(x)		(*((UB32*)(&((x).hp_hp[6]))))
#define Hp5(x)		(*((UB32*)(&((x).hp_hp[8]))))
#define Hp6(x)		(*((UB32*)(&((x).hp_hp[10]))))

#define Vcmd(x)		((x).hp_vcmd)
#define Vp1lo(x)	((x).hp_vp[0])
#define Vp1hi(x)	((x).hp_vp[1])
#define Vp1(x)		(*((UB32*)(&((x).hp_vp[0]))))
#define Vp2(x)		(*((UB32*)(&((x).hp_vp[2]))))
#define Vp3(x)		(*((UB32*)(&((x).hp_vp[4]))))
#define Vp4(x)		(*((UB32*)(&((x).hp_vp[6]))))
#define Vp5(x)		(*((UB32*)(&((x).hp_vp[8]))))
#define Vp6(x)		(*((UB32*)(&((x).hp_vp[10]))))

#endif
E 1
