/*  viosflags.h -- Define VIOS external flags and static variables
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef VIOSFLAGS
#define VIOSFLAGS

#include "viostypes.h"
#include "RAMmonsize.h"
#include "32032.h"

/* (A_monramstart and A_monramsize defined in RAMmonsize.h) */


/* Define start of AIS/VIOS Absolute-Addressed RAM */
#define VIOSSTART (A_monramstart + A_monramsize)
#define VIOSEND (VIOSSTART + sizeof(VIOS_RAM))


/* Define macros to simplify future definitions */

#define Makeram(type, name) type VIOS_/**/name;
#define Makedef(name) ((VIOS_RAM*)VIOSSTART)->VIOS_/**/name


/*
 * Define the structure of the AIS/VIOS portion of
 *	Absolute-Addressed RAM and define variables
 */

typedef struct {
				/* Define Pool structures and flags */

Makeram( unsigned	,vios_pool_start)	/* Start Address of Pool */
#define vios_pool_start Makedef(vios_pool_start)

Makeram( unsigned	,vios_pool_end)		/* End Address of Pool */
#define vios_pool_end Makedef(vios_pool_end)

Makeram( POOL_MGE	,pool)		/* Pool Management Block */
#define pool Makedef(pool)

Makeram( unsigned	,poolsize)	/* size of pool */
#define poolsize Makedef(poolsize)

Makeram( int	,All_failed)		/* True if allocation failure */
#define All_failed Makedef(All_failed)


#ifdef DEBUG_MAP   /***********************************************************/

Makeram( char*	,poolmap)		/* ptr to pool map */
#define poolmap Makedef(poolmap)

Makeram( unsigned	,mapsize)	/* size of pool map */
#define mapsize Makedef(mapsize)

#endif /* DEBUG_MAP ***********************************************************/


				/* Define Queue listheads */

Makeram( LIST_HEAD	,Vdevices)	/* Virtual Device Listhead */
#define Vdevices Makedef(Vdevices)

Makeram( LIST_HEAD	,Pdevices)	/* Physical Device Listhead */
#define Pdevices Makedef(Pdevices)


Makeram( LIST_HEAD	,Vqueue)	/* VI/O active request queue */
#define Vqueue Makedef(Vqueue)

Makeram( LIST_HEAD	,Pqueue)	/* PI/O active request queue */
#define Pqueue Makedef(Pqueue)

Makeram( LIST_HEAD	,Wqueue)	/* I/O request Wait queue */
#define Wqueue Makedef(Wqueue)


Makeram( LIST_HEAD	,Imp_modules)	/* Implementation modules */
#define Imp_modules Makedef(Imp_modules)

Makeram( LIST_HEAD	,Class_modules)	/* Class handling modules */
#define Class_modules Makedef(Class_modules)

Makeram( LIST_HEAD	,Operating_systems)	/* OS list */
#define Operating_systems Makedef(Operating_systems)


				/* Define VIOS flags and counters */

Makeram( unsigned	,ticks)		/* Count of clock interrupts */
#define ticks Makedef(ticks)

Makeram( OSD_PTR	,Current_os)	/* currently scheduled OS */
#define Current_os Makedef(Current_os)

Makeram( int*	,osutraps[TRAPS])	/* OS entry points for User Traps */
#define osutraps Makedef(osutraps)

Makeram( char	,Vioexecuting)		/* True during VIO execution */
#define Vioexecuting Makedef(Vioexecuting)

Makeram( char	,Vioscheduled)		/* True if VIO rescheduled */
#define Vioscheduled Makedef(Vioscheduled)

Makeram( char	,OSscheduled)		/* True if OS interrupts queued */
#define OSscheduled Makedef(OSscheduled)

Makeram( char	,OS_Completion)		/* True if OS completion ints enabled */
#define OS_Completion Makedef(OS_Completion)

Makeram( char	,Intstate)		/* True during interrupts */
#define Intstate Makedef(Intstate)

Makeram( int	,Intdepth)		/* Interrupt enable/disable depth */
#define Intdepth Makedef(Intdepth)


				/* Define VIOS Command Interpreter flags */

Makeram( char	,vc_name[MAX_NAMELENGTH])	/* Device name in command */
#define vc_name Makedef(vc_name)

Makeram( char	,vc_tname[MAX_NAMELENGTH])	/* Aux string in command */
#define vc_tname Makedef(vc_tname)

Makeram( unsigned	,vc_params[4])		/* Various command paramters */
#define vc_params Makedef(vc_params)


	}  VIOS_RAM;


#endif
