h50153
s 00065/00000/00000
d D 3.1 84/11/13 16:28:24 dan 1 0
c date and time created 84/11/13 16:28:24 by dan
e
u
U
t
T
I 1
/* monsize.c -- C source to create RAMmonsize.m
 * copyright (c) 1984  American Information Systems Corporation
 *
 *	Daniel Steinberg
 *	July, 1984
 *
 *	This file is compiled to produce assembly language output that
 *	is editted (thru abs.sed) to become RAMmonsize.m in which the
 *	initialized values below are turned into assembler .set directives.
 *	RAMmonsize.m is used by the VIOS in order to locate the end of the
 *	AIS/RAM-Monitor portion of Absolute-Addressed RAM area.
 *
 *	NOTE:
 *	Non-fatal warnings will be generated by the c-compiler when symbols
 *	for array locations are compiled.
 */

#include "monflags.h"



/* Define macros to make symbol definitions */

#define Makesym(x) unsigned A_/**/x = (unsigned)&x;
#define Makeval(x,v) unsigned A_/**/x = (unsigned)(v);


/* Define some special locations and values */

#define RAMSIZE (sizeof(MONITOR_RAM))

Makeval(monramstart, RAMSTART)
Makeval(monramend, (RAMSTART + RAMSIZE))
Makeval(monramsize, RAMSIZE)
Makeval(Grain, GRAIN)


/* Define symbols for the low-memory RAM */
Makeval(zeroramstart,ZERORAMSTART)
Makeval(zramend,ZRAMEND)
Makeval(zeroramend,ZERORAMEND)
Makeval(zeroramsize,ZERORAMEND-ZERORAMSTART)
Makeval(zeroramgrains,(ZERORAMEND-ZERORAMSTART)/GRAIN)

/* Reference some variables from AIS/RAM-Monitor Absolute-Addressed RAM */

unsigned A_state = (unsigned)&intmod + MOD_SB;	/* Interrupt Dispatch State */

Makesym(emergency)		/* Emergency Register Dump */
Makesym(mondispatch)		/* Monitor Trap Dispatch Table */
Makesym(viosdispatch)		/* VIOS Trap Dispatch Table */
Makesym(oskdispatch)		/* OS Kernel Trap Dispatch Table */
Makesym(osidispatch)		/* OS K Completion Trap Dispatch Table */
Makesym(osudispatch)		/* OS User Trap Dispatch Table */

Makesym(membitmap)		/* Memory Bitmap */
Makesym(reset_addr)		/* address of soft reset code */
Makesym(memsize)		/* #bytes of good RAM */
Makesym(cataddr)		/* current catch frame address */
Makesym(lasthrown)		/* last thrown error */

Makesym(debug_user_state)	/* TRUE: monitor traps User-State bpt */

Makesym(viosstack)		/* VIOS stack */

E 1
