
C **************************************************************
C  PROGRAM AMDHST.FOR 
C
C  REVISION HISTORY
C  REV  DATE MODIFIED  AUTHOR   REASON FOR CHANGE
C   A  6/30/82         CLIF P   INITIAL FORTRAN
C   B  8/10/82         CLIF P   CHANGE PROTOCOL ATTEMPT TO REESTABLISH 
C                               COMMUNICATIONS  
C   C  12/17/82        CLIF P   REPLACED TABS, LINE FEEDS AND CARRIAGE
C				RETURNS AND PERIOD.
C              			WITH ASCII CHARACTERS 28-31	
C				THESE CHANGES WERE MADE IN STRLN
 AND
C				DOWNLOAD.  FOR SYSTEM 29 COMMUNICATION

C   D  1/13/83		        ADDED COMMENTED CODE FOR VAXES RUNNING
C				VMS. THE CODE IS UNTESTED PEOPLE USING
C				A VAX SHOULD REPLACE THE 2 READS WITH
C				A SYSTEM CALL AND THE 'WTQIO' WITH
C				A 'SYS$ASSIGN' 
C				SEARCH FOR THE KEYWORD 'VAX'
C
C   THIS PROGRAM SUPPORTS FILE TRANSFERS BETWEEN BOTH RTE16 AND AMDSYS29
C   AND A HOST MACHINE. (EITHER RSX11 OR RT11)
C   THE PROGRAM CONSTANTLY LISTENS TO RTE16 OR AMSYS29 AND WILL ATTEMPT
C   TO COMPLETE A TRANSFER REQUEST REGARDLESS OF INVALID CONDITIONS.
C   THE RTE16/AMDSYS29 PROGRAMS MONITOR THE COMMUNICATION LINES AND
C   WILL ISSUE A CANCEL TO ANY  INVALID REQUEST.
C   THIS PROGRAM WILL ALSO MONITOR THE COMMUNICATION LINES AND WILL ALWAYS
C   EXCEPT A REQUEST TO CANCEL ( A CONTROL X)  AT ANY TIME. 
C
C  THIS PROGRAM WAS WRITTEN IN RATFOR (RATIONAL FORTRAN) WHICH PROVIDES
C  PASCAL LIKE CONTROL CONSTRUCTS. HENCE, THE RATHER STRANGE "IF"    
C  STATEMENTS.  RATFOR HAS THE FOLLOWING FLOW OF CONTROL STATEMENTS
C  REPEAT <STATEMENTS>  UNTIL (CONDITION)
C  WHILE (CONDITION)  <STATEMENT> ENDWHILE
C  SWITCH (VARIABLE)  THIS IS EQUIVALENT TO A PASCAL CASE STATEMENT
C  FOR (CONDITION INCREMENT VARIABLE) <STATEMENT>  ENDFOR
C       RATFOR TRANSLATES STATEMENTS LIKE
C    IF (CONDITION) THEN BEGIN
C         STATEMENTS
C    END ELSE BEGIN
C        STATEMENTS
C    END
C    INTO  THE FOLLOWING FORTUR
C     IF (.NOT. (CONDITION)) GOTO LABEL1
C        STATEMENTS
C     GOTO LABEL2
C LABEL1    CONTINUE
C        STATEMENTS
C LABEL2    CONTINUE
C      THE COMMENTS, "WHILE", "ENDWHILE", "FOR", "ENDFOR", "REPEAT"  
C      "SWITCH" REFER TO THE RATFOR CONTROL STATEMENTS.
C      RATFOR GENERATES ALL LABELS GREATER THAN 23000
C      LABEL 0 -99 ARE FOR ERROR CONDITIONS
C      LABELS 200 - 900 ARE BRANCHS
C      LABELS 1000  -2000 ARE FORMAT STATEMENTS
C      THIS PROGRAM WAS WRITTEN TO RUN UNDER THE RSX11 OR RT11 OPERATING 
C      SYSTEM RUNNING DEC FORTRAN IV.  IT SHOULD WORK WITH WITH ONLY MINOR
C      MODIFICATIONS, TO THE SYNTAX OF OPEN STATEMENTS, WITH ANY
C      ANSI STANDARD FORTRAN IV WHICH HAS SOME METHOD OF HANDLING 
C      CHARACTER VARIABLES. 
C    
C   THE MESSAGE FORMAT IS DESCRIBED AS FOLLOWS :
C       HEADER RECORD
C       -------------
C         START    FILENAME                              END    CARRIAGE
C       OF HEADER   LENGTH   TYPE  FILENAME  CKSUM  OF TEXT   RETURN
C       ................................................................
C
C          SOH        XX      XX   XXXXXXXX     XX       ETX       CR
C
C       WHERE
C           TYPE CAN BE 1: CALL DOWNLOAD FILE,
C                       2: UPSAVE FILE,
C                       3: UPSAVE PRINT FILE,
C                       4: CLOSE PRINT FILE,
C                       5: REOPEN PRINT FILE,
C                       6: DELETE FILE
C           FILENAME IS OF LENGTH UP TO 8 BYTE,
C           CKSUM IS THE SUM OF ALL BYTE FROM LENGTH FIELD TO FILENAME
C               FIELD,
C
C       DATA RECORD
C       -----------
C
C        START    DATA    BLOCK   DATA              END    CARRIAGE
C       OF TEXT  LENGTH  NUMBER  BLOCK  CKSUM  OF TEXT   RETURN
C       ...........................................................
C
C         STX      XX      XX    XXXXX     XX       ETX       CR
C
C       WHERE
C           DATA BLOCK IS OF LENGTH UP TO 128 BYTE (CORRESPONDING TO 64
C               BYTES AFTER PACKED),
C           CKSUM IS THE SUM OF ALL BYTE FROM LENGTH FIELD TO DATA
C               BLOCK FIELD,
C
C       END RECORD
C       ----------
C
C        START            BLOCK              END    CARRIAGE
C       OF TEXT  LENGTH  NUMBER  CKSUM  OF TEXT   RETURN
C       ....................................................
C
C         STX      00      00       C0       ETX       CR
C
C  N.B.  ALL FILES WHICH ARE TO BE DOWNLOADED MUST BE IN THE FOLLOWING 
C        FORMAT: 1 .. 79 ASCII CHARACTERS FOLLOWED BY A 
C        NEWLINE CHARACTER(S) . HEXBINFX PRODUCES CORRECTLY 
C        FORMATTED DATA.
C       
C        PRINT FILES WILL HAVE A MAXIMUM OF 32 CHARACTERS / LINE.
C******************************************************
C  RTE16 REQUEST 
C DEFINE        DOWNLD  1        HOST TO RTE 
C DEFINE        UPSAV           2        RTE TO HOST 
C DEFINE        PRSAV   3        RTE TO HOST PRINT FILE 
C DEFINE        CLOSE1          4        CLOSE PRINT FILE 
C DEFINE        REOPN           5        REOPEN PRINT NAME 
C DEFINE        DELET           6        DELETE FILE 
C SYNC CHARACTERS 
C DEFINE        SOH             0X1      START OF HEADER 
C DEFINE        STX             0X2      START OF TEXT 
C DEFINE        ETX             0X3      END OF TEXT A PERIOD
C DEFINE        ENQ             0X5      ENQUIRY 
C DEFINE        ACK             0X6      ACKNOWLEDGE 
C DEFINE        LF              0X0A     LINE FEED 
C DEFINE        NAK             0X16     NEGATIVE ACKNOWLEDGE 
C DEFINE        CAN             0X18     CANCEL 
C DEFINE        FILLEN  8        FILE NAME LENGTH 
C DEFINE        DATLEN  64               DATA BLOCK LENGTH 
C DEFINE        BLKSIZ  25       BLOCK BUFFER LENGTH 
C **********************
C   G L O B A L
C   ENDRECORD: RECORD TO END TRANSMISSION,
C   BLOCK, BLOCKCOUNT      & BLOCKINDEX: BLOCK BUFFER, COUNT AND INDEX,
C   BUFFER, LENGTH      & INDEX: MESSAGE BUFFER, LENGTH AND INDEX,
C   SINBUF STANDARD INPUT BUFFER
C   CHKSUM, CK12      & ETX, IETX: 
C   CKSUM AND CETX AND THE INTEGER REPRESENTATIVE OF CETX
C   FILENAME      & PRINTNAME: FILE NAMES,
C   CANCEL: RTE16 REQUEST TO CANCEL FLAG,
C   SOH: SOH RECEIVD, CANCEL FLAG ALSO SET,
C   DEBUG: .TRUE. TO ENABLE DEBUGGING MESSAGE,
C   PBLOCKNO: PRINT SAVE BLOCK NUMBER
C******************************************************
      PROGRAM AMDHST
C******************************************************
C   M A I N
C       LOCAL  - TRANSACTION: TRANSX TYPE,
C                REOPN: PRINT SAVE INTERRUPTED FLAG,
C                FD: FILE PTR,
C                I, ITEMP, CTEMP      & C: MISCELLANEOUS;
C
C    IT WAITS FOR AND PROCESSES THE FOLLOWING REQUEST FROM RTE16 :
C
C       DOWNLOAD        
C       UPSAVE
C       PRINT SAVE
C       CLOSE
C       REOPEN
C       DELETE
C
CTHE COMMUNICATION ALWAYS STARTS AT RTE16 SENDING A HEADER RECORD TO THE
C    HOST.  HOST WILL DETERMINE THE REQUEST AND TALK BACK TO RTE16.
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
C  GLOBAL VARIABLES ARE REPRESENTED BY THE USE OF COMMON STATEMENTS
C  DUE TO THE ANSI PROHIBITION OF MIXING CHARACTER AND INTEGER TYPES
C  MOST VARIABLES ARE TREATED AS INTEGER IN THE MAIN PROGRAM AND
C  CHARACTER TYPES IN THE SUBROUTINES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     & ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
C      COMMON /LOG/ ITBILN, IMASK(16)
C LOCAL VARIABLES
C  GETRTE IS AN CHARACTER OR BYTE FUNCTION 
      BYTE DNAME(10) , GETRTE,SIG
      BYTE  FNAM1(10),PRNAM(10),DNAM1(10)
      BYTE  PRNTMP(40)
      INTEGER I,ITEMP,TRANSX,ITEMP1
      LOGICAL FOREVE,IOERR,REOPEN
      EQUIVALENCE (FNAME,FNAM1), (PRNAME,PRNAM1),(DNAME,DNAM1)
CONSTANT DATA
      DATA ENDREC/'0','0','0','0','C','0'/
      DATA DOWNLD/1/,UPSAV/2/,PRSAV/3/,CLOSE1/4/,REOPN/5/,DELET/6/
      DATA SOH/1/,STX/2/,ETX/46/,ENQ/5/,ACK/6/,LF/10/,NAK/22/,CAN/24/,
     &CR/13/
      DATA ENDSIZ/8/,FILLEN/10/,DATLEN/64/,BLKSIZ/25/
      DATA SOHW/"0401/,STXW/"1002/,ETXW/"1403/,ENQW/"2403/,ACKW/
     &"3006/,LFW/"5012/,NAKW/"21042/CANW/"14030/,CRW/"6415/
C      DATA IBITLN /15/
C      DATA IMASK( 1) /1/,IMASK( 2) /2/
C      DATA IMASK( 3) /4/,IMASK( 4) /8/
C      DATA IMASK( 5) /16/,IMASK( 6) / 32/
C      DATA IMASK( 7) /64/,IMASK( 8) / 128/
C      DATA IMASK( 9) /256/,IMASK(10) / 512/
C      DATA IMASK(11) /1024/,IMASK(12) / 2048/
C      DATA IMASK(13) /4096/,IMASK(14) / 8192/
C      DATA IMASK(15) /16384/,IMASK(16) / 32768/
      DATA FOREVE/.TRUE./
      VSOH = .FALSE.
      REOPEN = .FALSE.
      DEBUG = .FALSE.
C     CALL FOR RSX SYSTEMS TO ENABLE TERMINAL I/O DELETE FOR A VAX
      CALL WTQIO(768,5,1)
C****************************************************************
C		VAX
C  THE FOLLOWING CODE IS SUPPOSED TO WORK FOR VAXES RUNNING
C  VMS. IT HAS NEVER BEEN TESTED
C  
C     CALL SYS$ASSIGN('TT:',CHAN,)
C  CHAN SHOULD BE INTEGER*4 DECLARED IN A COMMON BLOCK
C  LOOK IN THE VAX I/O USERSGUIDE VOL 1 FOR FURTHER DETAILS
C***************************************************************
C
C SIGN ON
      TYPE 1000
      TYPE 1010
1000  FORMAT(' AMD       AMDHSTFX        V1.0    1/25/83')
1010  FORMAT(' ---------------------------------------')
C     ENABLE DEBUGGING ? 
      TYPE 1020
1020  FORMAT(' WANT DEBUG OPTION (Y/N) ? ')
      READ (5,990) (BUFFER(II) , II=1,80)
990   FORMAT(80A1)
      DEBUG = (BUFFER(1) .EQ. 'Y') .OR. (BUFFER(1) .EQ. 'Y')
C     WHILE
23000 IF(.NOT.(FOREVE))GOTO 23001
C        WAIT FOR SOH 
         IF(.NOT.(.NOT.VSOH))GOTO 23002
C           REPEAT
23004          CONTINUE
               CALL PRTSI('WAIT1     ',SOH)
               SIG = GETRTE(DUM)
               ITEMP1 = SIG
               CANCEL = .FALSE.
23005          IF(.NOT.(ITEMP1 .EQ. SOH))GOTO 23004
C        CLEAR VSOH AND CANCEL AGAIN 
23002    CONTINUE
         CALL PRTSI('GOT      ',SOH)
         VSOH = .FALSE.
         CANCEL = .FALSE.
         IOERR = .FALSE.
         EOF = .FALSE.
C        GET ONE MESSAGE  
         TRANSX = RECEIV(DUM)
C        CHECK FOR OBVIOUS ERROR 
         IF(.NOT.((LENGTH .LE. FILLEN) .AND. (DOWNLD .LE. TRANSX) .AND.(
     &TRANSX .LE. DELET) .AND. (CK12 .EQ. CKSUM) .AND. (IETX .EQ. 
     &     ETX)))GOTO 23007
C            PROCESSING 
C           SWITCH
            I23009 = (TRANSX)
            IF(.NOT.(I23009.EQ.( DOWNLD)))GOTO 23010
C                    SAVE FILE NAME 
               CALL CLRBUF(FNAME,10)
C              FOR
               I=1
23011          IF(.NOT.(I.LE.LENGTH))GOTO 23013
                  FNAME(I) = BUFFER(I)
                   I=I+1
                  GOTO 23011
C              ENDFOR
23013          CONTINUE
               CALL PRTSS(FNAME,'CALL DWNLD')
               OPEN(UNIT=1,ERR=10,NAME=FNAM1 ,TYPE='OLD',FORM=
     &           'FORMATTED', RECORDSIZE=1)
               GOTO 210
10             CALL PUTRTE(NAKW)
C                   CAN'T OPEN FILE 
               IOERR=.TRUE.
210            CONTINUE
               IF(.NOT.(.NOT.IOERR))GOTO 23014
                  FD=1
                  REWIND 1
C                          ACKNOWLEDGE 
                  CALL PUTRTE(ACKW)
C                         PROCESS DOWNLD 
                  CALL DWNLD(FD)
C                           CLOSE FILE 
                  CLOSE(UNIT=1)
23014          CONTINUE
               GOTO 23009
23010          CONTINUE
            IF(.NOT.(I23009.EQ.( UPSAV)))GOTO 23016
C                    SAVE FILE NAME 
               CALL CLRBUF(FNAME,10)
C              FOR
               I=1
23017          IF(.NOT.(I.LE.LENGTH))GOTO 23019
                  FNAME(I) = BUFFER(I)
                   I=I+1
                  GOTO 23017
C              ENDFOR
23019          CONTINUE
               CALL PRTSS(FNAME,' UPSAVE  ')
                OPEN(UNIT=2,ERR=20,NAME=FNAM1,TYPE ='UNKNOWN',
     &          FORM='FORMATTED',RECORDSIZE=1)
               FD =2
               GOTO 220
               CALL PRTSS('UPSAVE NACK',FNAM1)
20             CALL PUTRTE(NACKW)
               IOERR = .TRUE.
220            CONTINUE
               IF(.NOT.(.NOT.IOERR))GOTO 23020
C                           ACKNOWLEDGE 
                  CALL PUTRTE(ACKW)
C                           PROCESS UPSAV 
                  ITEMP = UPSAVE(FD)
                  CLOSE(UNIT=2)
23020          CONTINUE
               GOTO 23009
23016          CONTINUE
            IF(.NOT.(I23009.EQ.( PRSAV)))GOTO 23022
               CALL CLRBUF(PRNAME,10)
C                    SAVE FILE NAME 
C              FOR
               I=1
23023          IF(.NOT.(I.LE.LENGTH))GOTO 23025
                  PRNAME(I) = BUFFER(I)
                   I=I+1
                  GOTO 23023
C              ENDFOR
23025          CONTINUE
               CALL PRTSS(PRNAME,' PRTSAV   ')
               OPEN (UNIT=3,ERR=30,FORM='FORMATTED',TYPE='NEW',NAME=
     &           PRNAM1 ,RECORDSIZE=1)
               FD =3
               GOTO 230
30             CONTINUE
               CALL PUTRTE(NACKW)
               IOERR=.TRUE.
230            CONTINUE
C                        ACKNOWLEDGE 
               IF(.NOT.(.NOT.IOERR))GOTO 23026
                  CALL PUTRTE(ACKW)
C                        PROCESS PRSAV - INITIALIZE PBLKNO 
                  PBLKNO = 0
                  ITEMP = PRTSAV(FD)
                  CLOSE(UNIT=3)
C                        SOH ? 
                  IF(.NOT.(ITEMP .EQ. SOH))GOTO 23028
                     REOPEN = .TRUE.
23028             CONTINUE
23026          CONTINUE
               GOTO 23009
23022          CONTINUE
            IF(.NOT.(I23009.EQ.( CLOSE1)))GOTO 23030
               CALL PRTSS('   CLOSE  ',PRMAN1)
C                    ACKNOWLEDGE 
               CALL PUTRTE(ACKW)
C                    CLOSE PRINT FILE AND IGNORE ERRORS 
               CLOSE(UNIT=FD)
               GOTO 23009
23030          CONTINUE
            IF(.NOT.(I23009.EQ.( REOPN)))GOTO 23031

               CALL PRTSS(PRNAME,' REOPEN   ')
               OPEN(UNIT=3,ERR=40,NAME=PRNAM1,FORM='FORMATTED',TYPE=
     &           'OLD',DISPOSE='DELETE',RECORDSIZE=1)
               OPEN(UNIT=7,ERR=40,NAME='PRN.TMP',FORM='FORMATTED',TYPE=
     &           'NEW',DISPOSE='DELETE',RECORDSIZE=1)
42             CONTINUE
                READ(3,45,END=47) PRNTMP
45              FORMAT(40A1)
                WRITE (7,45) PRNTMP
                GOTO 42
47              CONTINUE
C SUCCESFULLY FILE COPY
                CLOSE (UNIT=3)

               GOTO 240
40             CALL PUTRTE(NACKW)
               IOERR=.TRUE.
240            CONTINUE
               IF(.NOT.(REOPEN .AND. (.NOT.IOERR)))GOTO 23032
C                        ACKNOWLEDGE 
                  CALL PUTRTE(ACKW)
C                        PROCESS PRSAV - DON'T INITIALIZE PBLKNO 
                  ITEMP =PRTSAV(3)
                  IF(.NOT.(ITEMP .NE.ACK))GOTO 23034
C
                     REWIND 7
                        OPEN(UNIT=3,ERR=40,NAME=PRNAM1,FORM='FORMATTED',
     &                      TYPE='NEW',RECORDSIZE=1)
49                      CONTINUE
                        READ(7,45,END=50)PRNTMP
                        WRITE(3,45) PRNTMP
                        GOTO 49
50                      CONTINUE
                        CLOSE(UNIT=7)

                     CLOSE(UNIT=3)
C                        SOH ? 
                     REOPEN = .FALSE.
                     IF(.NOT.(ITEMP .EQ. SOH))GOTO 23036
                        REOPEN = .TRUE.
23036                CONTINUE
23034             CONTINUE
23032          CONTINUE
               GOTO 23009
23031          CONTINUE
            IF(.NOT.(I23009.EQ.( DELET)))GOTO 23038
               CALL PRTSS(' DELETE   ',DNAM1)
C                    ACKNOWLEDGE 
               CALL PUTRTE(ACKW)
               CALL CLRBUF(DNAME,10)
C              FOR
               I=1
23039          IF(.NOT.(I.LE.LENGTH))GOTO 23041
                  DNAME(I) =BUFFER(I)
                   I=I+1
                  GOTO 23039
C              ENDFOR
23041          CONTINUE
               OPEN(UNIT=4,NAME=DNAM1 ,TYPE='UNKNOWN')
               CLOSE(UNIT=4,DISPOSE='DELETE')
C                    DELETE FILE AND IGNORE ERRORS 
23038          CONTINUE
23009       CONTINUE
            GOTO 23008
C        ELSE
23007       CONTINUE
            CALL PUTRTE(NAKW)
        IF (DEBUG) TYPE 2000,LENGTH,FILLEN,TRANSX,CK12,CKSUM,IETX,ETX
2000        FORMAT(' LEN=',I4,'FILLEN=',I4,' TRANSX=',I4,'CK12=',I4,
     &         'CKSUM=',I4,'IETX=',I4,' ETX=',I4)
C       MESSAGE ERROR 
23008    CONTINUE
         GOTO 23000
C     ENDWHILE
23001 CONTINUE
      STOP
      END
C******************************************************
C    P R I N T S S
C
C    ENTRY - STR1,STR2:  STRINGS
C
C    IT PRINTS OUT DEBUGGING MESSAGE.
C******************************************************
      SUBROUTINE PRTSS(STR1,STR2)
      IMPLICIT INTEGER (A-Z)
      BYTESTR1(10) ,STR2(10)
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
      IF(.NOT.(DEBUG))GOTO 23042
         TYPE 1000,STR1,STR2
23042 CONTINUE
1000  FORMAT(' ',      'PRTSS=',2(10A1))
      RETURN
      END
C******************************************************
C    P R I N T S I
C
C    ENTRY - STR1: STRINGS,
C           SYNC: SYNC CHARACTER
C
C    IT PRINTS OUT DEBUGGING MESSAGE.
C******************************************************
      SUBROUTINE PRTSI(STR1,SYNC)
C LOCAL VARIABLES
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
CLOCAL VARIABLES
      BYTE STR1(10)
      INTEGER*2 SYNC
      IF(.NOT.(DEBUG))GOTO 23044
         TYPE 1000,STR1
1000     FORMAT(1H$,10A1)
C        SWITCH
         I23046 = (SYNC)
         IF(.NOT.(I23046.EQ.( ACK)))GOTO 23047
            TYPE 1010
            GOTO 23046
23047       CONTINUE
         IF(.NOT.(I23046.EQ.( CAN)))GOTO 23048
            TYPE 1020
            GOTO 23046
23048       CONTINUE
         IF(.NOT.(I23046.EQ.( ENQ)))GOTO 23049
            TYPE 1030
            GOTO 23046
23049       CONTINUE
         IF(.NOT.(I23046.EQ.( NAK)))GOTO 23050
            TYPE 1040
            GOTO 23046
23050       CONTINUE
         IF(.NOT.(I23046.EQ.( SOH)))GOTO 23051
            TYPE 1050
            GOTO 23046
23051       CONTINUE
         IF(.NOT.(I23046.EQ.( STX)))GOTO 23052
            TYPE 1060
23052       CONTINUE
23046    CONTINUE
1010     FORMAT(' ACK')
1020     FORMAT(' CAN')
1030     FORMAT(' ENQ')
1040     FORMAT(' NAK')
1050     FORMAT(' SOH')
1060     FORMAT(' STX')
23044 CONTINUE
      RETURN
      END
C******************************************************
C                    CLRBUF
C CLEAR A BUFFER OF SIZE
C******************************************************
      SUBROUTINE CLRBUF(STRING,ISIZE)
      BYTE STRING(ISIZE)
      INTEGER I,ISIZE
C     FOR
      I=1
23053 IF(.NOT.(I.LE.ISIZE))GOTO 23055
         STRING(I) = ' '
         I = I +1
         GOTO 23053
C     ENDFOR
23055 CONTINUE
      RETURN
      END
C******************************************************
C    G E T R T E
C
C       GLOBAL - CANCEL: CANCEL FLAG,
C                CHKSUM: CKSUM
C
C       LOCAL  - CTEMP: BYTE
C
C    IT READS ONE CHARACTER FROM RTE16 AND ACCUMULATES CHKSUM.
C
C    WHENEVER CAN OR SOH IS RECEIVED, IT SETS 
C    UP 'CANCEL' FLAG TO FORCE 'GETRTE(DUM)'
C    TO RETURN CAN ON FUTURE CALL.
C
C    THE PURPOSE OF 'CANCEL' FLAG IS TO AVOID 
C    UNEXPECTED CANCEL REQUEST OR START OF 
C    ANOTHER HEADER RECORD FROM RTE16.
C
C    IT WORKS BY FORCING CONTROL TO FLOW TO 
C    CERTAIN POINTS WHERE 'CANCEL' IS
C    CHECKED FOR.
C
C    'CANCEL' FLAG WILL BE CLEARED AFTER 
C    FLOW OF CONTROL RETURNS TO THE TOP
C    LEVEL WHERE SOH IS EXPECTED.
C
C    RETN  - NEXT CHARACTER FROM RTE16
C******************************************************
      LOGICAL FUNCTION GETRTE*1(DUM)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
C  LOCAL VARIABLES
      BYTECTEMP,NEXTCH
C     CHECK 'CANCEL' FLAG 
      IF(.NOT.(CANCEL))GOTO 23056
         GETRTE = (CAN)
         RETURN
C     COMPUTE 'CHECKSUM' 
23056 CONTINUE
      CTEMP = NEXTCH(SINBUF,CANCEL)
      ITEMP = CTEMP
      CKSUM = CKSUM + ITEMP
C     SET UP 'CANCEL' AND 'VSOH' FLAG
      IF(.NOT.(CTEMP .EQ. CAN))GOTO 23058
         CANCEL = .TRUE.
23058 CONTINUE
      IF(.NOT.(CTEMP .EQ. SOH))GOTO 23060
         CANCEL = .TRUE.
         VSOH = .TRUE.
23060 CONTINUE
      GETRTE = (CTEMP)
      RETURN
      END
C******************************************************
C  NEXTCH  RETURNS THE NEXT CHARACTER FORM THE STANDARD INPUT
C  BUFFER .  IF THEIR IS NO DATA WAITING TO BE READ 
C  NEXTCH WAITS FOR DATA TO BE ENTERED. IF THE RTE SYSTEM APPEARS
C  TO BE DEAD, IT IS PROBABLY NEXTCH WAITING FOR DATA.
C******************************************************
      LOGICAL FUNCTION NEXTCH*1(SINBUF)
C       
      IMPLICIT INTEGER (A-Z)
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
      BYTE SINBUF(80)
      INTEGER CHCNT,SINLEN,STRLN
      LOGICAL DATAIS,CANCEL
      DATA CHCNT/0/
      IF(.NOT.((CHCNT .EQ.0) .OR. (CHCNT.EQ.80) .OR. (CHCNT .GE. SINLEN 
     &  .OR. (CANCEL))))GOTO 23062
         CHCNT=0
C CONTINUE TRYING TO READ STANDARD INPUT UNTIL SOME DATA IS SEEN
C THEN STORE THE DATA IN THE STANDARD INPUT BUFFER (SINBUF)
C        REPEAT
23064       CONTINUE
            DATAIS = .TRUE.
            DO 15 I=1,80 
               SINBUF(I) = 0
15          CONTINUE
C**************************************************************
C 	CHANGE FOR VAX RUNNING VMS
C	REPLACE READ WITH THE FOLLOWING 
C      
C      
C      SYS$QIOW(,%VAL(CHAN),%VAL(IO$_RDDBK),,,,SINBUF,%VAL(80)
C     1         ,,TERM,)
C     %VAL(),
C     NOTE 1  TERM IS AN INTEGER*4 ARRAY
C	      TERM(1) =0
C	      TERM(2) = "2EDFE080" IN HEX
C     NOTE 2  IO$_RDDBK CAN BE REPLACED WITH IO$M_NOECHO
C     NOTE 3  MORE INFORMATION ON THE SYS$QIOW CAN BE FOUND
C             ON PAGE 171 OF THE SYSTEM SERVICE MANUAL
C     NOTE 4  CHAN HAS TO BE DECLARED IN COMMON OR PASSED AS A PARAMETER
C********************** END OF VAX CHANGE ************************

            READ(5,1000,END=10) SINLEN,(SINBUF(I), I=1,SINLEN)
1000        FORMAT(Q,80A1)
            GOTO 210
10          CONTINUE
            IF(.NOT.(I .EQ.1))GOTO 23067
               DATAIS = .FALSE.
23067       CONTINUE
23065       IF(.NOT.(DATAIS))GOTO 23064
23062 CONTINUE
210   CONTINUE
      CHCNT= CHCNT+1
      NEXTCH = (SINBUF(CHCNT))
      RETURN
      END
C******************************************************
C    G E T R T E 2
C
C       LOCAL  - CTEMP      & CTEMP1: BYTES
C                ITEMP : INTEGER
C
C    IT PACKS TWO CHARACTERS FROM RTE16 AND ACCUMULATES CHKSUM.
C
C    RETN  - TWO CHARACTERS FROM RTE16 PACKED INTO ONE
C******************************************************
      INTEGER FUNCTION GET2B(DUM)
      IMPLICIT INTEGER (A-Z)
      INTEGER CTEMP,CTEMP1
      INTEGER ITEMP,BAND
      BYTE CH, CH1, GETRTE
      CH = GETRTE(DUM)
      CH1 = GETRTE(DUM)
C     CONVERT HEX TO BINARY 
      CALL ASC2H(CH,CTEMP)
      CALL ASC2H(CH1,CTEMP1)
      ITEMP = SHIFTL(CTEMP,4) + CTEMP1
      GET2B = (ITEMP)
      RETURN
      END
C******************************************************
C    P U T R T E
C
C    ENTRY - SIGNAL: THE CHARACTER
C
C    IT SENDS ONE CHARACTER TO RTE16.
C******************************************************
      SUBROUTINE PUTRTE (SIGNAL)
      IMPLICIT INTEGER (A-Z)
      BYTE SIGNAL
      TYPE 1040,SIGNAL
1040  FORMAT(1X,A1)
      RETURN
      END
C******************************************************
C    P U T B U F
C
C    ENTRY - CHAR : THE CHARACTER
C
C       GLOBAL - BUFFER()      & INDEX: MESSAGE BUFFER AND INDEX,
C                CHKSUM: CKSUM
C
C    IT WRITES ONE CHARACTER INTO 'BUFFER(INDEX)' AND COMPUTES CHKSUM.
C
C    'INDEX' IS INCREMENTED BY 1.
C******************************************************
      SUBROUTINE PUTBUF (CHAR)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
CLOCAL VARIABLE
      BYTECHAR
C     COMPUTES 'CHECKSUM' 
      INDEX = INDEX +1
      BUFFER(INDEX) =CHAR
      ITEMP = CHAR
      CKSUM = CKSUM + ITEMP
      RETURN
      END
C******************************************************
C   P U T B U F 2
C
C    ENTRY - BYTE: THE CHARACTER
C
C   ITEMPL      & ITEMPH : THE LOW AND HIGH NIBBLE OF THE CHARACTER
C
C    IT UNPACKS THE CHARACTER INTO TWO, STORES THEM AT 'BUFFER(INDEX)' AND
C    'BUFFER(INDEX+1)', AND COMPUTES 'CHECKSUM'.
C
C    'INDEX' IS INCREMENTED BY 2.
C******************************************************
      SUBROUTINE PUTBF2 (BYTE1)
      IMPLICIT INTEGER (A-Z)
      INTEGER BYTE1,ITEMPL,ITEMPH
      BYTE CH
      ITEMPH = MOD(RSHFT(BYTE1,4),16)
      ITEMPL = MOD(BYTE1,16)
      CALL H2ASCI(CH,ITEMPH)
      CALL PUTBUF(CH)
      CALL H2ASCI(CH,ITEMPL)
      CALL PUTBUF(CH)
      RETURN
      END
C******************************************************
C                    H2ASCI (HEX TO ASCII CONVERSION)
C  CONVERTS THE VALUE IN NIBBLE INTO A CHARACTER RETURNED IN  CH
C******************************************************
       SUBROUTINE H2ASCI(CH,NIBBLE)
C
      IMPLICIT INTEGER (A-Z)
       INTEGER NIBBLE
        BYTE CH,HEX2A(16)
      DATA HEX2A/'0','1','2','3','4','5','6','7','8','9','A','B','C',
     &  'D','E','F'/
         CH = HEX2A(NIBBLE +1)
      RETURN
      END
C******************************************************
C    P A C K 2
C
C       GLOBAL - BUFFER()      & INDEX: MESSAGE BUFFER AND INDEX
C
C       LOCAL  - TEMP      & TEMP1: BYTES
C
C  IT PACKS TWO CHARACTERS AT 'BUFFER(INDEX)' AND 'BUFFER(INDEX+1)' INTO ONE.
C
C    'INDEX' IS INCREMENTED BY 2.
C
C    RETN  - PACKED CHARACTER
C******************************************************
      INTEGER FUNCTION PACK2(DUM)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
CLOCAL VARIABLES
      INTEGER SHIFTL
      INDEX = INDEX +1
      CALL ASC2H(BUFFER(INDEX),TEMP)
      INDEX = INDEX +1
      CALL ASC2H(BUFFER(INDEX),TEMP1)
      IITEMP = SHIFTL(TEMP,4) + TEMP1
      PACK2 = (IITEMP)
      RETURN
      END
C******************************************************
C      ASC2H
C CONVERTS THE FIRST ARGUEMENT WHICH IS IN ASCII
C AND PLACE  THE HEX RESULT IN THE SECOND ARGUEMENT
C******************************************************
      SUBROUTINE ASC2H(ASCII,HEX)
CLOCAL VARIABLES
      BYTE ASCII
      INTEGER IASCII,HEX
      INTEGER H0,H7,H9
      DATA H0/48/,H7/55/,H9/57/
      IASCII = ASCII
      IF(.NOT.(IASCII .GT. H9))GOTO 23069
         HEX = IASCII - H7
         GOTO 23070
C     ELSE
23069    CONTINUE
         HEX = IASCII - H0
23070 CONTINUE
      RETURN
      END
C******************************************************
C    R E C E I V E
C
C       GLOBAL - BUFFER()      & LENGTH: MESSAGE BUFFER AND LENGTH,
C                CHKSUM      & CK12: CKSUM,
C                ETX: CETX
C
C       LOCAL  - BN: BLOCK NUMBER OR TRANSX TYPE,
C                CK: RECEIVD CKSUM,
C                I: MISCELLANEOUS
C
C   IT ACCEPTS ONE MESSAGE FROM RTE16 AND COMPUTES CKSUM ON THOSE CHARACTERS
C    BEFORE THE CKSUM FIELD.
C
C    FIRST TWO CHARACTERS ARE PACKED INTO 'LENGTH'.  
C    NEXT TWO CHARACTERS ARE PACKED INTO
C    'BN' FOR EITHER TRANSX OR BLOCK NUMBER.
C
C    THE MESSAGE OF LENGTH 'LENGTH' IS SAVED IN THE 'BUFFER()'.
C
C    TWO CHARACTERS ARE THEN PACKED INTO 
C    'CHECKSUM' AND THE LAST CHARACTER IS SAVED IN
C    'CETX'.
C
C
C    CHECKSUM COMPUTATION IS INCLUDED IN 'GETRTE(DUM)' 
C    AND THE RESULT IS SAVED IN
C    'CK12'.
C    RETN  - BLOCK NUMBER OR TRANSX TYPE
C******************************************************
      INTEGER FUNCTION RECEIV(DUM)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
CLOCAL VARIABLES
      BYTE GETRTE
      INTEGER CK,I,BN
      CKSUM = 0
C     GET LENGTH AND BLOCK/TRANSX NUMBER 
      LENGTH = GET2B(DUM)
      BN = GET2B(DUM)
C     GET MESSAGE 
C     FOR
      I=1
23071 IF(.NOT.(I.LE.LENGTH))GOTO 23073
         BUFFER(I) = GETRTE(DUM)
          I=I+1
         GOTO 23071
C     ENDFOR
23073 CONTINUE
C     GET CKSUM 
      CK12 = MOD(CKSUM,256)
C    COMPUTED CKSUM 
      CK = GET2B(DUM)
C    RECEIVD CKSUM 
C     GET ETX 
      CETX = GETRTE(DUM)
      IETX = CETX
C     RESTORE DUE TO THAT 'GETRTE(DUM)' CHANGES 'CHECKSUM' 
      CKSUM = CK
      RECEIV = (BN)
      RETURN
      END
C******************************************************
C    D O W N L O A D
C
C    ENTRY - FD: PTR TO AN OPEN FILE
C
C       GLOBAL - BUFFER()      & INDEX: MESSAGE BUFFER AND INDEX,
C                CHKSUM: CKSUM
C
C       LOCAL  - BLOCKNO: BLOCK NUMBER,
C                LEAVE: LOOP CONTROL FLAG,
C                ITEMP, I      & CTEMP: MISCELLANEOUS
C
C    IT SENDS FILE (ALREADY OPEN) INCLUDING AN END RECORD TO RTE16.
C
C    AFTER THE MESSAGE IS CONSTRUCTED, IT WAITS FOR ENQ TO START TRANSMISSION.
C
C    IT RETRANSMITS UPON RECEIVING A NAK RESPONSE.
C
C    TRANSMISSION CONTINUES UNTIL EITHER END OF FILE IS REACHED, CAN OR SOH IS
C#    RECEIVD FROM RTE16.
C
C    RETN - ACK: FILE TRANSMISSION COMPLETED,
C          CAN: RTE16 REQUEST TO CANCEL OR START OF NEW HEADER RECEIVD
C******************************************************
      SUBROUTINE DWNLD(FD)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW
C LOCAL VARIABLES
      INTEGER DATALN,K,I,BLKNUM
      BYTE CTEMP,DWNBUF(80),GETRTE
      BLKNUM=0
      CKSUM = 0
C     REPEAT
23074    CONTINUE
         INDEX = 0
C           CLEAR BUFFER SO STRLN WILL WORK
C        FOR
         J=1
23077    IF(.NOT.(J.LE.80))GOTO 23079
            DWNBUF(J) = ' '
             J=J+1
            GOTO 23077
C        ENDFOR
23079    CONTINUE
         CALL FGETS(DWNBUF,64,EOF,DATALN)
	 DWNBUF(DATALN +1) = 0
         DATALN = STRLN(DWNBUF,1)
         IF(.NOT.(.NOT.EOF))GOTO 23080
            CALL PUTBF2(DATALN)
            CALL PUTBF2(BLKNUM)
C           FOR
            K =1
23082       IF(.NOT.(K.LE.DATALN))GOTO 23084
               CALL PUTBUF(DWNBUF(K))
                K=K+1
               GOTO 23082
C           ENDFOR
23084       CONTINUE
            CALL PUTBF2(CKSUM)
            GOTO 23081
C        ELSE
23080       CONTINUE
C          FOUND THE END OF RECORD
            DATALN = 0
C           FOR
            K=1
23085       IF(.NOT.(K.LE.6))GOTO 23087
               BUFFER(K) = ENDREC(K)
                K=K+1
               GOTO 23085
C           ENDFOR
23087       CONTINUE
23081    CONTINUE
C        REPEAT
23088       CONTINUE
            CALL PRTSI('WAITDWNLD ',ENQ)
            CTEMP = GETRTE(DUM)
            IF (DEBUG) TYPE 1210,CTEMP
1210        FORMAT(' IN DOWNLOAD CTEMP=',I4)
            CALL PRTSI('FOUND2    ',CTEMP)
23089       IF(.NOT.((CTEMP .EQ. CAN) .OR. (CTEMP .EQ. ENQ)
     D      .OR. (CTEMP .EQ. NAK))) GOTO 23088
C          TRANSMIT THE MESSAGE
C        REPEAT
23091       CONTINUE
            IF(.NOT.(CTEMP .EQ. CAN))GOTO 23094
               RETURN
23094       CONTINUE
            TYPE 1200,STX, (BUFFER(I), I =1,DATALN+6), ETX
1200        FORMAT(' ',A1,70A1,A1)
            CALL PRTSI('WAITDWNLD2',ACK)
2000        CONTINUE
                CTEMP = GETRTE(DUM)
                IF (CTEMP .EQ. CAN) RETURN
            IF (.NOT.((CTEMP .EQ. ACK).OR.(CTEMP .EQ. ENQ) .OR. (CTEMP 
     D          .EQ. NAK) .OR. (CTEMP .EQ. CAN))) GOTO 2000
23092       IF(.NOT.(CTEMP .NE. NAK))GOTO 23094
         CKSUM = 0
         BLKNUM= BLKNUM+1
          IF (BLKNUM .GE. 256) BLKNUM = 0
23075    IF(.NOT.(EOF))GOTO 23074
      RETURN
      END
C******************************************************
C    U P S A V E
C
C    ENTRY - FD: PTR TO AN OPEN FILE
C
C       GLOBAL - BUFFER()      & LENGTH: MESSAGE BUFFER AND LENGTH,
C                BLOCKCOUNT      & BLOCKINDEX: BLOCK BUFFER COUNT AND INDEX,
C                CHKSUM      & CK12: CKSUM,
C                ETX: CETX
C
C       LOCAL  - BLOCKNO      & BN12: BLOCK NUMBER,
C                I      & CTEMP: MISCELLANEOUS
C
C    IT RECEIVS A FILE FROM RTE16.
C
C    IT SENDS OUT ENQ TO RTE16 AND WAITS FOR THE MESSAGE.
C
C    REPLY WITH ACK TO ACCEPT THE MESSAGE OR NAK TO REJECT IT AND REQUEST
C    RETRANSMISSION.
C
C    RECEIVING PROCESS CONTINUES UNTIL END RECORD, CAN OR SOH IS RECEIVD.
C
C    RETN  - ACK: FILE RECEIVD SUCCESSFULLY,
C           CAN: RTE16 REQUEST TO CANCEL OR START OF NEW HEADER RECEIVD
C******************************************************
      INTEGER FUNCTION UPSAVE (FD)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW,ETX
CLOCAL VARIABLES
      INTEGER BN12,I,BLKNO
      BYTECTEMP,GETRTE
      BLKNO = 0
      CKSUM = 0
C     REPEAT
23096    CONTINUE
C        REQUEST MESSAGE 
         CALL PUTRTE(ENQW)
C        REPEAT
23099       CONTINUE
C        WAIT FOR STX OR CAN 
            CALL PRTSI('WAIT',STX)
            CTEMP = GETRTE(DUM)
            IF(.NOT.(CTEMP .EQ. CAN))GOTO 23102
               UPSAVE = (CAN)
               RETURN
23102       CONTINUE
23100       IF(.NOT.(CTEMP .EQ. STX))GOTO 23099
         CALL PRTSI('GOTUPSAVE ',CTEMP)
C        GET ONE MESSAGE 
         BN12 = RECEIV(DUM)
C        CHECK FOR OBVIOUS ERRORS 
         IF ((LENGTH .LE. DATLEN) .AND. (IETX .EQ. ETX) .AND.
     D     (CK12 .EQ. CKSUM)) GOTO 2000
C        MESSAGE ERROR
                CALL PUTRTE(NAKW)
                LENGTH = 1
                GOTO 2010
2000      CONTINUE
          IF (.NOT. ((BN12 .EQ. BLKNO) .OR. ((LENGTH .EQ.0) 
     D         .AND. (BN12 .EQ.0)))) GOTO 2020             
C            ACKNOWLEDGE 
            CALL PUTRTE(ACKW)
            CKSUM = 0
            BLKNO = BLKNO + 1
            IF (BLKNO .GE. 256) BLKNO = 0
C            WRITE BUFFER 
            WRITE(2,1000) (BUFFER(K), K=1,LENGTH)
1000        FORMAT(80A1)
            GOTO 2010
C        ELSE
2020        CONTINUE
C       IF THE BLOCK IS THE SAME AS THE PREVIOUS BLOCK THEN PUT AN ACK
            IF (BN12 .EQ. (BLKNO -1))  GOTO 2010
C       ELSE  MESSAGE ERROR 
            CALL PUTRTE(NAKW)
            LENGTH = 1
            GOTO 23097
2010     CONTINUE
         CALL PUTRTE(ACKW)
23097    IF(.NOT.(((LENGTH.EQ.0) .AND. ( BN12.EQ.0))))GOTO 23096
      UPSAVE = (ACK)
      RETURN
      END
C******************************************************
C    P R I N T S A V E
C
C       GLOBAL - INDEX      & LENGTH: MESSAGE BUFFER INDEX AND LENGTH,
C                BLOCKCOUNT      & BLOCKINDEX: BLOCK BUFFER COUNT AND INDEX,
C                CHKSUM      & CK12: CKSUM,
C                ETX: CETX,
C                PBLOCKNO: BLOCK NUMBER
C
C       LOCAL  - BN12: BLOCK NUMBER,
C                CTEMP: MISCELLANEOUS
C
C#    IT RECEIVS A PRINT FILE FROM RTE16.
C
C    IT SENDS OUT ENQ TO RTE16 AND WAITS FOR THE MESSAGE.
C
C    REPLY WITH ACK TO ACCEPT THE MESSAGE OR NAK TO REJECT IT AND REQUEST
C    RETRANSMISSION.
C
C    RECEIVING PROCESS CONTINUES UNTIL END RECORD, CAN OR SOH IS RECEIVD.
C#
C    RETN  - ACK: FILE RECEIVD SUCCESSFULLY,
C#          CAN: RTE16 REQUEST TO CANCEL OR START OF NEW HEADER RECEIVD
C                UNEXPECTEDLY,
C           SOH: START OF NEW HEADER RECEIVD AT PROPER TIME
C******************************************************
      INTEGER FUNCTION PRTSAV (FD)
      IMPLICIT INTEGER(A-Z)
C  GLOBAL VARIABLES
      BYTE FNAME(10),PRNAME(10)
      BYTEBUFFER(72),SINBUF(80)
      INTEGER CKSUM,CK12,BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO
      INTEGER*2 IETX
      INTEGER*2 CETX
      LOGICAL EOF,ERROR,VSOH,CANCEL
      COMMON /GLOB/ FNAME,PRNAME, BUFFER,BLOCK,SINBUF,CETX,DUM1,CKSUM,
     &  CK12, BLKIND,BLKCNT,LENGTH,INDEX,PBLKNO,VSOH,EOF,CANCEL,IETX
      COMMON /BUG/ DEBUG
      LOGICAL DEBUG
C CONSTANT VARIABLES
      COMMON /CONS/ENDREC,ENDSIZ,FILLEN,DATLEN,BLKSIZ,DOWNLD,UPSAV,
     &  PRSAV,REOPN,DELET,SOH,STX,ETX,ENQ,ACK,LF,NAK,CAN,CR,SOHW,STXW,
     &  ETXW,ENQW,ACKW,LFW,NAKW,CANW,CRW
      BYTE ENDREC(6)
      INTEGER ENDSIZ,FILLEN,DATLEN,BLKSIZ
      INTEGER DOWNLD,UPSAV,PRSAV,REOPN,DELET
      INTEGER*2 SOH,STX,ENQ,ACK,LF,NAK,CAN
      INTEGER*2 SOHW,STXW,ETXW,ACKW,LFW,NAKW,CANW,ETX
CLOCAL VARIABLES
      INTEGERBN12
      BYTE CTEMP,GETRTE
      INTEGER*2 OUTBUF(40),OUTIND,OUTLEN
      BLKCNT = 0
      BLKIND = 0
      CKSUM = 0
C     REPEAT
23106    CONTINUE
C        REQUEST MESSAGE 
         CALL PUTRTE(ENQW)
C        WAIT FOR SOH, STX OR CAN 
C        REPEAT
23109       CONTINUE
            CALL PRTSI('WAITPRTSAV',STX)
            CTEMP = GETRTE(DUM)
            CALL PRTSI('GOTPRTSAV ',CTEMP)
            IF(.NOT.((CTEMP .EQ. CAN) .OR. (CTEMP .EQ. SOH)))GOTO 23112
               PRTSAV = (CTEMP)
               RETURN
23112       CONTINUE
23110       IF(.NOT.(CTEMP .EQ. STX))GOTO 23109
C        GET ONE MESSAGE 
         BN12 = RECEIV(DUM)
C        CHECK FOR OBVIOUS ERRORS 
         IF ((LENGTH .LE. DATLEN) .AND. (
     &     CK12 .EQ. CKSUM) .AND.(IETX .EQ. ETX) )GOTO 2000
C           MESSAGE ERROR
            CALL PUTRTE(NAKW)
            LENGTH =1
            GOTO 2010
2000        CONTINUE
            IF ( .NOT. (PBLKNO .EQ. BN12)) GOTO 2020
C            ACKNOWLEDGE 
            CKSUM = 0
            PBLKNO = PBLKNO +1
            IF (PBLKNO .GE. 256) PBLKNO = 0
C            CONVERT AND WRITE BUFFER 
            INDEX = 0
            OUTIND = 1
C           WHILE
23116       IF(.NOT.(INDEX .LT. LENGTH))GOTO 23117
               OUTBUF(OUTIND) = PACK2(DUM)
               OUTIND = OUTIND +1
               GOTO 23116
C           ENDWHILE
23117       CONTINUE
            OUTLEN = LENGTH/2
            CALL PRIOUT(OUTBUF,OUTLEN)
            CALL PUTRTE(ACKW)
            GOTO 2010
2020     CONTINUE
         IF ((PBLKNO -1) .EQ. BN12) GOTO 2010
C        ELSE
23114       CONTINUE
C            MESSAGE ERROR 
            CALL PRTSI('PRTSAVELSE',NAK)
            CALL PUTRTE(NAKW)
            LENGTH = 1
         GOTO 23107
2010     CONTINUE
         CALL PUTRTE(ACKW)
23107    IF(.NOT.(LENGTH .EQ.0))GOTO 23106
      PRTSAV = (ACK)
      RETURN
      END
C******************************************************
C       PRIOUT PRINTS OUT OUTBUF TO THE PRINT FILE
C******************************************************
      SUBROUTINE PRIOUT(OUTBUF,OUTLEN)
      INTEGER*2 OUTBUF(40)
      INTEGER*2 OUTLEN,M
      WRITE(3,1000) (OUTBUF(M),M=1,OUTLEN)
1000  FORMAT(40A1)
      RETURN
      END
C************************
        INTEGER FUNCTION RSHFT(VAR,ICOUNT)
C       SHIFTS THE VARIABLE VAR ICOUNT PLACE TO THE RIGHT
        INTEGER VAR,ICOUNT,TEMP
        TEMP = VAR/(2**ICOUNT)
20      CONTINUE
        RSHFT = TEMP
        RETURN
        END
C ***********************
      INTEGER FUNCTION SHIFTL(VAR,SCOUNT)
C  SHIFTS  THE VARIABLE VAR SCOUNT PLACES TO THE LEFT
      SHIFTL = VAR *2**IFIX(SCOUNT)
      RETURN
      END
C******************************************************
      INTEGER FUNCTION STRLN(STRING,INDEX)
C     RETURN THE NUMBERS OF CONSECUTIVE NON BLANK CHARACTER
C     IN THE STRING AFTER INDEX (WHICH IS NORMALLY  THE LOCATION
C     OF THE ':'
      BYTE STRING(80) 
      INTEGER*2  CRI,LFI,BLANK
      INTEGER INDEX,TEMP,ITEMP
      INTEGER*2 TAB,NEWTAB,NEWDOT,DOT,NEWCR,NEWLF
      DATA CRI/13/,LFI/10/,BLANK/32/,TAB/09/,NEWTAB/31/
      DATA DOT/46/,NEWDOT/28/,NEWCR/29/,NEWLF/30/
      DO 10 I = INDEX,80 
          TEMP = I - INDEX  
          ITEMP = STRING(I)
          IF (ITEMP .EQ. TAB) STRING(I) = NEWTAB 
          IF (ITEMP .EQ. DOT) STRING(I) = NEWDOT
          IF (ITEMP .EQ. CRI) STRING(I) = NEWCR
          IF (ITEMP .EQ. LFI) STRING(I) = NEWLF
      IF (ITEMP .EQ. 0) GOTO 40 		            
10    CONTINUE
40    CONTINUE
       STRLN = TEMP
      RETURN
      END
C ***********************
      SUBROUTINE FGETS(BUFFER,BUFSIZ,ERROR,DATALN)
      BYTE BUFFER(80)
      INTEGER BUFSIZ,DATALN
      LOGICAL ERROR
CD
      LOGICAL FIRST ,DEBUG
      COMMON /BUG/ DEBUG
C     GETS A LINE OF INPUT WITH AT MOST BUFSIZE CHARACTERS IN IT
      ERROR = .FALSE.
      READ (1,20,END=100,ERR=999) DATALN,(BUFFER(I) , I=1,DATALN)
20    FORMAT(Q,80A1)
      IF (DEBUG) TYPE 10025, BUFFER
10025 FORMAT (' PAST READ ECHO=',80A1)
      RETURN
100   ERROR = .TRUE.
      TYPE 30 
30    FORMAT(' END OF FILE REACHED')
      RETURN
999   ERROR =.TRUE.
      TYPE 40
40    FORMAT(' WARNING I/0 ERROR HAS OCCURED')    
      STOP 
      END
C******************************************************
       SUBROUTINE GETS(BUFFER)
C      GETS A LINE OF INPUT FROM STANDARD INPUT I.E TERMINAL
C      THIS ROUTINE HAS TO BE MODIFIED FOR VAXEN
       BYTE BUFFER(80)

C**************************************************************
C 	CHANGE FOR VAX RUNNING VMS
C	REPLACE READ WITH THE FOLLOWING 
C      
C      
C      SYS$QIOW(,%VAL(CHAN),%VAL(IO$_RDDBK),,,,BUFFER,%VAL(80)
C     1         ,,TERM,)
C     %VAL(),
C     NOTE 1  TERM IS AN INTEGER*4 ARRAY
C	      TERM(1) =0
C	      TERM(2) = "2EDFE080" IN HEX
C     NOTE 2  IO$_RDDBK CAN BE REPLACED WITH IO$M_NOECHO
C     NOTE 3  MORE INFORMATION ON THE SYS$QIOW CAN BE FOUND
C             ON PAGE 171 OF THE SYSTEM SERVICE MANUAL
C     NOTE 4  CHAN HAS TO BE DECLARED IN COMMON OR PASSED AS A PARAMETER
C********************** END OF VAX CHANGE ************************

       READ (5,10 , END=999) BUFFER
10     FORMAT(80A1)
       RETURN
999    TYPE 20
20     FORMAT(' NO DATA WAS READ')
       RETURN
       END

