TYPE RAMDRIV.AQM

::::::::::
RAMDRIV.AQM
::::::::::
        TITLE   'RAMDRIV        12/27/82'
;
;**********************************************************
;
;       RAMDRIV -  A program that permits extended
;       memory to function as a fast disk drive.  This
;       program does not require modification of the
;       existing BIOS.
;
;       Copyright 1982, by
;       Herbert B. Shore
;       Department of Physics
;       San Diego State University
;       San Diego, CA 92182
;       (619) 265-6159
;
;       Released to the public domain for
;       non-commercial use.
;
;**********************************************************
;
;  The code and tables in this file will reside in high
;  memory, above the existing BIOS.  A separate loader
;  program, RAMLD.ASM is combined with this program to
;  produce the executable file, RAMDRIV.COM.  The
;  procedure for combining the two programs is described 
;  in the loader program.
;
FALSE   EQU     0
TRUE    EQU     NOT FALSE
;
;  The following equates are system dependent.
;
;  PANEL:  If you have an (IMSAI-type) front panel, set
;    PANEL=TRUE.  The lights will display the extended
;    address, simulating the LED on the door of the disk
;    drive.  Flipping switch D0 up will "write-protect"
;    the RAM drive.
;
;  RAMDRIV:  Set to memory location above BIOS.  A little
;    less than 1K of GLOBAL memory is required at this
;    location; i.e. the same block of memory must be
;    accessible independent of the setting of the extended
;    address bus.
;
;  PRAM:  The extended address of regular program RAM.
;    Usually this is 00H.
;
;  DRAM:  The extended address of the first extra segment
;    of RAM to be used as a simulated disk drive.  Each
;    segment can be up to 63K long (the upper 1K is not
;    accessible, since it is occupied by the global RAM).
;    The extended addresses of the extra segments should be
;    sequential;  the program will automatically determine
;    how many extra segments there are.
;
;  XPORT:  The output port that sets the extended address
;    bus.
;
;  DNAME:  The alphabetic designation of the RAM drive.
;
;  LIGHTS:  The output port for front panel lights.
;
;  SWITCH:  The input port for front panel switches.
;
;  AVL:  The number of available kilobytes in each extra
;    segment of RAM.  This memory must all be NON-global.
;    If, for example, the upper 16K of your memory is global,
;    set AVL to 48K.
;
;  DIRECT:  The number of directory entries permitted on the
;    RAM drive.  Must be a multiple of 32.  I used 32 to leave
;    the maximum space for program files.
;
PANEL   EQU     FALSE           ;IMSAI FRONT PANEL
RAMDRIV EQU     0FC00H          ;START OF PROGRAM.
PRAM    EQU     00H             ;EXTENDED ADDR. OF MAIN RAM
DRAM    EQU     01H             ;EXT. ADDR. OF RAMDRIV.
XPORT   EQU     0FDH            ;PORT TO SET EXT. ADDR.
DNAME   EQU     'C'             ;DRIVE NAME OF RAMDRIV.
        IF      PANEL
LIGHTS  EQU     0FFH            ;FRONT PANEL LIGHTS.
SWITCH  EQU     0FFH            ;FRONT PANEL SWITCHES.
        ENDIF
AVL     EQU     63              ;AVAILABLE KBYTES/BOARD.
DIRECT  EQU     32              ;NO. OF DIRECTORY ENTRIES.
;
;  THESE EQUATES WILL NORMALLY NOT BE CHANGED.
;
BDOS    EQU     5
DELCHR  EQU     0E5H            ;DELETED DIRECTORY ENTRY.
DNUMB   EQU     DNAME - 'A'     ;RAMDRIV DRIVE NUMBER
;
        MACLIB  Z80
$*MACRO
        ORG     RAMDRIV
;
;  ORIGINAL JUMP TABLE FROM BIOS
;
WBOOT1: DS      48
WCK:                            ;END OF BIOS TABLE.
;
CSV:    DS      DIRECT/4
ALV:    DS      72
DIRBUF: DS      128
RAMBUF: DS      128
ENDTBL:                         ;END OF DATA TABLES.
;
;  The following code is executed once to set up the
;  RAMDRIV system.  In order to conserve space it
;  will be overwritten by data buffers during actual
;  access to the RAM-drive.
;
        ORG     RAMDRIV         ;BACK TO BEGINNING.
;
SETUP:
;
;  DETERMINE NUMBER OF MEMORY BANKS
;
        MVI     B,0             ;B = # OF BANKS
BCHEK:  MOV     A,B
        CPI     10              ;# BANKS < 10
        JNC     BADRM           ;ERROR.
        ADI     DRAM            ;GET EXTENDED ADDRESS.
        OUT     XPORT
        INR     B               ;FOR NEXT LOOP.
        LXI     H,1234H         ;SAMPLE ADDRESS
        MOV     A,M             ;GET A SAMPLE
        MOV     C,A             ;SAVE IT
        CMA                     ;COMPLEMENT SAMPLE
        MOV     M,A             ;TRY TO PUT INTO MEM.
        MOV     A,M             ;SEE IF IT STUCK.
        MOV     M,C             ;RESTORE ORIGINAL.
        XRA     C               ;SHOULD GIVE 0FFH.
        INR     A               ;SHOULD GIVE 0
        JZ      BCHEK           ;LOOP TO NEXT BANK.
        MVI     A,PRAM
        OUT     XPORT           ;RESTORE CP/M BANK.
        DCR     B
        JNZ     RAMOK           ;AT LEAST ONE BANK?
BADRM:  LXI     D,NORAM         ;NO RAM AT ALL.
        MVI     C,9
        CALL    BDOS
        JMP     QUIT
;
NORAM:  DB      'Cannot activate RAMDRIV.  No available RAM.$'
BMSG:   DB      'There are '
NBANKS: DB      '0 ', AVL/10 + '0', AVL MOD 10 + '0'
        DB      'k banks available for RAMDRIV.'
        DB      0DH,0AH,'$'
;
RAMOK:  MOV     C,B             ;SAVE # OF BANKS.
        LXI     H,0
        LXI     D,AVL           ;KBYTES/BANK.
MULT:   DAD     D
        DCR     B
        JNZ     MULT            ;AVL*BANKS
        DCX     H               ;MAX BLOCK NO.
        SHLD    DSM
        MOV     A,C
        ADI     '0'             ;CONVERT TO ASCII.
        STA     NBANKS
        LXI     D,BMSG
        MVI     C,9
        CALL    BDOS            ;PRINT NO. OF BANKS.
;
;  MODIFY BIOS JUMP TABLES
;
        IF      $ < WCK         ;MAKE SURE THAT WBOOT1 TABLE
        JMP     BJUMP           ;WILL NOT OVERWRITE
        ENDIF                   ;BJUMP ROUTINE.
        IF      $ < WCK
        DS      WCK - $
        ENDIF
;
BJUMP:  LHLD    1               ;GET ADDRESS OF WARM BOOT
        LXI     D,WBOOT1        ;TRANSFER TABLE FROM BIOS UP HERE
        LXI     B,48            ;48 BYTES
        LDIR
        LXI     H,WBOOT2        ;TRANSFER OUR TABLE TO BIOS
        LDED    1
        LXI     B,48
        LDIR
;
;  PRINT MESSAGE AND ASK QUESTION
;
        LXI     D,QUEST
        MVI     C,9             ;PRINT STRING
        CALL    BDOS
        MVI     C,1             ;GET CHARACTER
        CALL    BDOS
        RES     5,A             ;CONVERT TO UPPER CASE.
        CPI     'Y'
        JNZ     QUIT
;
;  CLEAR DIRECTORY OF RAMDRIV
;
        MVI     A,DRAM          ;EXT. ADDRESS OF RAMDRIV
        OUT     XPORT
        IF      PANEL
        CMA
        OUT     LIGHTS          ;TO IMSAI FRONT PANEL
        ENDIF
        LXI     H,0             ;LOCATION 0000
        LXI     D,32            ;EVERY 32 BYTES
        MVI     B,DIRECT        ;NO. OF ENTRIES.
CLEAR:  MVI     M,DELCHR
        DAD     D
        DCR     B
        JNZ     CLEAR
        MVI     A,PRAM          ;RESET EXT. ADDR.
        OUT     XPORT
        IF      PANEL
        CMA
        OUT     LIGHTS
        ENDIF
QUIT:   LXI     D,CRLF
        MVI     C,9
        CALL    BDOS
        JMP     0               ;BACK TO CP/M.
;
QUEST:  DB      'RAMDRIV active on drive ', DNAME, ':'
        DB      0DH, 0AH
        DB      'Should directory of drive ', DNAME
        DB      ': be cleared (Y/N)? : $'
CRLF:   DB      0DH, 0AH, '$'
;
;  NEW TABLE COPIED INTO BIOS
;
WBOOT2: JMP     WBOOT
        JMP     WBOOT1+3
        JMP     WBOOT1+6
        JMP     WBOOT1+9
        JMP     WBOOT1+12
        JMP     WBOOT1+15
        JMP     WBOOT1+18
        JMP     HOME            ;21
        JMP     SELDSK          ;24
        JMP     SETTRK          ;27
        JMP     SETSEC          ;30
        JMP     SETDMA          ;33
        JMP     READ            ;36
        JMP     WRITE           ;39
        JMP     WBOOT1+42
        JMP     SECTRN          ;45
;
;  IMPLEMENT BIOS FUNCTIONS
;
        IF      $ < ENDTBL      ;MAKE SURE THAT BIOS
        DS      ENDTBL - $      ; FUNCTIONS BEGIN
        ENDIF                   ; AFTER TABLES.
;
WBOOT:  LXI     H,80H           ;SET INITIAL DMA ADDR.
        SHLD    DMAADR
        JMP     WBOOT1          ;BACK TO BIOS
;
;
HOME:   LDA     DISK            ;CHECK DISK NUMBER.
        CPI     DNUMB           ;IS IT THE RAMDRIV?
        JNZ     WBOOT1+21       ;IF NOT, LET BIOS HANDLE IT.
        MVI     A,DRAM          ;SET "TRACK" TO 0
        STA     XTRAK
        RET
;
;
SELDSK: MOV     A,C             ;CHECK REQUESTED DISK,
        STA     DISK
        CPI     DNUMB
        JNZ     WBOOT1+24
        LXI     H,DPH           ;RETURN DISK PAR. HEADER.
        RET
;
;  DISK PARAMETER HEADER FOR RAMDRIV
;
DPH:
        DW      0               ;NO SECTOR TRANSLATION
        DW      0,0,0           ;SCRATCH
        DW      DIRBUF          ;LOC. OF SCRATCHPAD AREA.
        DW      DPB             ;DISK PARAMETER BLOCK
        DW      CSV             ;DIR. CHECK AREA
        DW      ALV             ;ALLOC. VECTOR.
;
;  DISK PARAMETER BLOCK
;
DPB:
        DW      AVL*(1024/128)  ;SECTORS PER TRACK
        DB      3               ;BSH
        DB      7               ;BLM
        DB      0               ;EXM
DSM:    DW      62              ;MAX BLOCK NO.
        DW      DIRECT-1        ;HIGHEST DIRECT. NO.
;
AL0     EQU     LOW (0FFH SHL (8-DIRECT/32))
AL1     EQU     0
;
        DB      AL0,AL1         ;DIRECTORY BLOCKS.
;
CKS     EQU     0               ;CHECK DIRECT. ENTRIES.
;
        DW      CKS
        DW      0               ;NO SKIPPED TRACKS.
;
;
SETTRK: LDA     DISK
        CPI     DNUMB
        JNZ     WBOOT1+27
        MOV     A,C             ;TRACK NO.
        ADI     DRAM            ;CONVERT TO EXT. ADDR.
        STA     XTRAK
        RET
;
;
SETSEC: LDA     DISK
        CPI     DNUMB
        JNZ     WBOOT1+30
        MVI     L,0             ;SECT. NO. IN BC.
        MOV     H,C             ;MULTIPLY BY 128.
        RARR    B               ;RESULT IS IN HL.
        RARR    H
        RARR    L
        SHLD    SECTOR          ;SAVE IT.
        RET
;
;
SETDMA: SBCD    DMAADR          ;SAVE DMA ADDR. BOTH HERE
        JMP     WBOOT1+33       ;AND IN BIOS.
;
;
READ:   LDA     DISK
        CPI     DNUMB
        JNZ     WBOOT1+36
        LDA     XTRAK           ;SET EXTENDED ADDRESS.
        OUT     XPORT
        IF      PANEL
        CMA
        OUT     LIGHTS
        ENDIF
        LHLD    SECTOR          ;DO BLOCK MOVE TO
        LXI     D,RAMBUF        ;TEMPORARY BUFFER.
        LXI     B,128           ;SECTOR=128 BYTES.
        LDIR
        MVI     A,PRAM          ;RESET ADDR.
        OUT     XPORT
        IF      PANEL
        CMA
        OUT     LIGHTS
        ENDIF
        LXI     H,RAMBUF        ;MOVE FROM BUFFER
        LDED    DMAADR          ;BACK TO MAIN RAM.
        LXI     B,128
        LDIR
        XRA     A               ;NO ERRORS.
        RET
;
;
WRITE:  LDA     DISK
        CPI     DNUMB
        JNZ     WBOOT1+39
        IF      PANEL
        IN      SWITCH          ;CHECK D0 OF FRONT PANEL
        ANI     1
        RNZ                     ;RETURN IF WRITE PROTECT.
        ENDIF
        LHLD    DMAADR          ;DMA --> BUFFER
        LXI     D,RAMBUF
        LXI     B,128
        LDIR
        LDA     XTRAK
        OUT     XPORT
        IF      PANEL
        CMA
        OUT     LIGHTS
        ENDIF
        LXI     H,RAMBUF        ;BUFFER --> RAMDRIV.
        LDED    SECTOR
        LXI     B,128
        LDIR
        MVI     A,PRAM
        OUT     XPORT
        IF      PANEL
        CMA
        OUT     LIGHTS
        ENDIF
        XRA     A
        RET
;
;
SECTRN: LDA     DISK
        CPI     DNUMB
        JNZ     WBOOT1+45
        MOV     H,B
        MOV     L,C
        RET
;
;  DATA STORAGE AREA
;
DISK:   DB      0
XTRAK:  DB      DRAM
DMAADR: DW    	X0H
SECTOR: DW      0
;
        END

[OPSYS] 00:24>NTER PASSWORD OR <CR> FOR NO PASSWORD:  

ENTER PASSWORD:  

INVALID PASSWORD 

WELCOME