; FILE: MEMMAP.ASM
BDOS	EQU	5	; CP/M ENTRY POINT
;
;  DISPLAY THE CP/M MEMORY LOCATIONS
;
	ORG	0100H
	MVI	C,12	; CHECK FOR VERSION 2.2
	CALL	BDOS
	MOV	A,L
	ORA	A
	LXI	H,3328-6	
	JZ	MMP1	; IF VERSION 1.4
;
	LXI	H,3584-6
	MVI	A,'2'	; CHANGE MESSAGE
	STA	MMPK
	STA	MMPK+2
MMP1:	SHLD	MMPA
;
	LHLD	6	; GET BDOS ENTRY ADDRESS
	SHLD	BDOSE
	LXI	B,-806H ; CALCULATE CCP FWA
	DAD	B
	SHLD	CCPFWA
;
	DCX	H	; CALCULATE TPA LWA
	SHLD	TPALWA
	INX	H
;
	LXI	B,800H	; CALCULATE BDOS FWA
	DAD	B
	SHLD	BDFWA
	LXI	B,6	; CALCULATE BDOS ENTRY ADDRESS
	DAD	B
	SHLD	BDOSE
;
	LXI	B,0	; CALCULATE CBIOS FWA
MMPA	EQU	$-2
	DAD	B
	SHLD	CBFWA
;
	LXI	B,3	; CALCULATE BDOS 'WARMBOOT' ENTRY
	DAD	B
	SHLD	WRMBT
;
;  DISPLAY MEMORY LOCATIONS
;
	LXI	D,MMPB	; DISPLAY A LINE OF DASHES
	CALL	MSG	
	LXI	D,MMPJ	; DISPLAY SYSTEM VERSION NUMBER
	CALL	MSG
	LXI	D,MMPC	; 'WARMBOOT' ETC
	CALL	MSG
;
	LXI	H,0	; DISPLAY TPA LWA
TPALWA	EQU	$-2
	CALL	DHW
	LXI	D,MMPD
	CALL	MSG
;
	LXI	H,0	; DISPLAY CCP FWA
CCPFWA	EQU	$-2
	CALL	DHW
	LXI	D,MMPE
	CALL	MSG
	LXI	H,0	; DISPLAY BDOS FWA
BDFWA	EQU	$-2
	CALL	DHW
	LXI	D,MMPF
	CALL	MSG
;
	LXI	H,0	; DISPLAY BDOS ENTRY
BDOSE	EQU	$-2
	CALL	DHW
	LXI	D,MMPG
	CALL	MSG
;
	LXI	H,0	; DISPLAY CBIOS FWA
CBFWA	EQU	$-2
	CALL	DHW
	LXI	D,MMPH
	CALL	MSG
;
	LXI	H,0	; DISPLAY CBIOS WARMBOOT ENTRY
WRMBT	EQU	$-2
	CALL	DHW
	LXI	D,MMPI
	CALL	MSG
;
	LXI	D,MMPB	; DISPLAY A LINE OF DASHES
	CALL	MSG
	JMP	0000	; RETURN TO CP/M
;
CR	EQU	0DH
BDOS	EQU	5
LF	EQU	0AH
;
MMPB:	DB	CR,LF,'----------------------------------------'
	DB	CR,LF,'$'
MMPC:	DB	'0000 "WARMBOOT" VECTOR',CR,LF
	DB	'0005 BDOS VECTOR',CR,LF
	DB	'005C DEFAULT FILE CONTROL BLOCK (FCB)',CR,LF
	DB	'0080 CP/M RECORD BUFFER',CR,LF
	DB	'0100 FIRST WORD ADDRESS (FWA) OF USER AREA',CR,LF,'$'
MMPD:	DB	' LAST WORD ADDRESS (LWA) OF USER AREA',CR,LF,'$'
MMPE	DB	' CCP FWA',CR,LF,'$'
MMPF:	DB	' BDOS FWA',CR,LF,'$'
MMPG:	DB	' BDOS ENTRY POINT',CR,LF,'$'
MMPH:	DB	' CBIOS FWA',CR,LF,'$'
MMPI:	DB	' CBIOS WARMBOOT ENTRY POINT',CR,LF,'$'
MMPJ:	DB	' SYSTEM:  CP/M VERSION '
MMPK:	DB	'1.4',CR,LF,'$'
;
;
;  DHW - DISPLAY HEX WORD
;
DHW:	PUSH	H
	MOV	A,H
	CALL	DHB
	POP	H
	MOV	A,L	; DISPLAY LOW BYTE
;
;  DHB - DISPLAY HEX BYTE
;
DHB:	PUSH	PSW
	RRC ! RRC ! RRC ! RRC
	CALL	DHD	; DISPLAY HEX DIGIT
	POP	PSW
;
;  DHD DISPLAY HEX DIGIT.
;	ENTRY A,LOW 4 BITS = DIGIT
;
DHD:	ANI	0FH
	CPI	10
	JNC	DHD1	; IF NOT 0 THROUGH 9
;
	ADI	'0'
	JMP	DCH
;
DHD1:	ADI	'A'-10	; CREATE "A,B,C,D,E, OR F"
;
;  DCH - DISPLAY ONE CHARACTER
;  ENTRY	A=ASCII ENCODED CHAR
;
DCH:	MOV	E,A
	MVI	C,2
	CALL	BDOS
	RET
;
;  ALN : ADVANCE TO NEW LINE.
;  ISSUE CR,LF
;
ALN:	MVI	A,0DH	; CARRIAGE RETURN
	CALL	DCH
	MVI	A,0AH	; LINE FEED
	CALL	DCH
	RET
;
;  FCC - FILTER OUT CONTROL CODES
;
FCC:	CPI	20H
	JNC	FCC1	; IF NOT CONTROL CODES
	ADI	40H
	MOV	B,A
	MVI	A,5EH	; UP-ARROW
	RET
;
;  WE HAVE  A GRAPHIC CHARACTER.
;  RETURN BLANK IN A; GRAPHIC IN B.
FCC1:	MOV	B,A
	MVI	A,20H	; BLANK
	RET
;
;  MSG - ISSUE MESSAGE TO CONSOLE DEVICE
;
MSG:	MVI	C,9
	CALL	BDOS
	RET
;
;  RCC - READ A CONSOLE CHARACTER
;
RCC:	MVI	C,1
	CALL	BDOS
	RET
