.PAGE	85
.TITLE "TURBODOS OPERATING SYSTEM FORMATTER INITIALIZATION (8 INCH FLOPPY)"
.SBTTL "COPYRIGHT 1983, SOFTWARE 2000, INC."
;
; COPYRIGHT 1983, SOFTWARE 2000, INC.
;
; VERSION: 03/02/83
;
.IDENT	FMTI8F		;MODULE ID
;
.INSERT	EQUATE		;SYMBOLIC EQUIVALENCES
;
CRLF	= 0		;CR/LF REQUIRED FLAG (FLAGS)
;
	.LOC	.DATA.#	;LOCATE IN DATA AREA
;
DENSTY::.BYTE	0	;FORMAT DENSITY FLAG
NMBHDS::.BYTE	0	;FORMAT NUMBER OF HEADS
SECSIZ::.BYTE	0	;FORMAT SECTOR SIZE
SECTRK::.BYTE	0	;FORMAT SECTORS/TRACK
GAPLEN::.BYTE	0	;FORMAT GAP LENGTH
NMBTRK::.WORD	77	;FORMAT NUMBER OF TRACKS
;
FLAGS:	.BYTE	0	;FORMAT FLAGS
FMTDEN:	.BYTE	0	;FORMAT DENSITY
FMTHDS:	.BYTE	0	;FORMAT NUMBER OF HEADS
FMTTRK:	.BYTE	0	;FORMAT NUMBER OF TRACKS
FMTTYP:	.BYTE	0	;FORMAT TYPE
INBUF:	.BYTE	1,0,0	;INPUT BUFFER
;
	.LOC	.PROG.#	;LOCATE IN PROGRAM AREA
;
FMTNIT::XRA	A
	STA	FLAGS	;CLEAR ALL FLAGS
	STA	FMTDEN	;CLEAR FORMAT DENSITY
	STA	FMTHDS	;CLEAR FORMAT NUMBER OF HEADS
	STA	FMTTYP	;CLEAR FORMAT TYPE
	CALL	GETOPT	;GET COMMAND LINE OPTION
	LDA	FMTDEN	;GET FORMAT DENSITY
	ORA	A	;FORMAT DENSITY=0?
	JRNZ	..IDC	;IF NOT, CONTINUE
	LXI	H,FLAGS	;ELSE, GET FLAGS
	SET	CRLF,M	;SET CR/LF REQUIRED FLAG
..INPD:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Enter density (Single/Double): "
	CALL	INPLN	;INPUT LINE
	JRZ	..IDE	;IF NULL INPUT, CONTINUE
	CALL	UPRCAS	;FORCE UPPER CASE
	CPI	"S"	;RESPONSE=S?
	JRZ	..IDC	;IF SO, CONTINUE
	CPI	"D"	;RESPONSE=D?
	JRZ	..IDC	;IF SO, CONTINUE
..IDE:	CALL	DMS	;ELSE, SOUND BELL
	.ASCIS	[ABEL]
	JMPR	..INPD	;CONTINUE
..IDC:	CPI	"S"	;FORMAT DENSITY=S?
	JRZ	..SD1	;IF SO, CONTINUE
	LXI	H,DENSTY  ;ELSE, GET FORMAT DENSITY FLAG
	MVI	M,0FFH	;SET FORMAT DENSITY FLAG=0FFH
..SD1:	LDA	FMTHDS	;GET FORMAT NUMBER OF HEADS
	ORA	A	;FORMAT NUMBER OF HEADS=0?
	JRNZ	..ISC	;IF NOT, CONTINUE
	LXI	H,FLAGS	;ELSE, GET FLAGS
	SET	CRLF,M	;SET CR/LF REQUIRED FLAG
..INPS:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Enter number of sides (1/2): "
	CALL	INPLN	;INPUT LINE
	JRZ	..ISE	;IF NULL INPUT, CONTINUE
	CPI	"1"	;RESPONSE=1?
	JRZ	..ISC	;IF SO, CONTINUE
	CPI	"2"	;RESPONSE=2?
	JRZ	..ISC	;IF SO, CONTINUE
..ISE:	CALL	DMS	;ELSE, SOUND BELL
	.ASCIS	[ABEL]
	JMPR	..INPS	;CONTINUE
..ISC:	SUI	"0"	;STRIP ASCII BIAS
	STA	NMBHDS	;SET NUMBER OF HEADS
	LDA	FMTTYP	;GET FORMAT TYPE
	ORA	A	;FORMAT TYPE=0?
	JRNZ	..ITC	;IF NOT, CONTINUE
	LXI	H,FLAGS	;ELSE, GET FLAGS
	SET	CRLF,M	;SET CR/LF REQUIRED FLAG
..INPT:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Enter format type (TurboDOS/Cpm): "
	CALL	INPLN	;INPUT LINE
	JRZ	..ITE	;IF NULL INPUT, CONTINUE
	CALL	UPRCAS	;FORCE UPPER CASE
	CPI	"T"	;RESPONSE=T?
	JRZ	..ITC	;IF SO, CONTINUE
	CPI	"C"	;RESPONSE=C?
	JRZ	..ITC	;IF SO, CONTINUE
..ITE:	CALL	DMS	;ELSE, SOUND BELL
	.ASCIS	[ABEL]
	JMPR	..INPT	;CONTINUE
..ITC:	LXI	H,SECSIZ  ;GET SECTOR SIZE
	MVI	M,0	;SET SECTOR SIZE=0
	CPI	"C"	;FORMAT TYPE=C?
	JRZ	..CPM	;IF SO, CONTINUE
	INR	M	;ELSE, INCREMENT SECTOR SIZE BY 2
	INR	M
..CPM:	LDA	DENSTY	;GET FORMAT DENSITY FLAG
	ORA	A	;FORMAT DENSITY FLAG=0?
	JRZ	..SD2	;IF SO, CONTINUE
	INR	M	;ELSE, INCREMENT SECTOR SIZE
..SD2:	LXI	H,MSNTBL  ;GET MAX SECTOR NUMBER TABLE
	LDA	SECSIZ	;GET FORMAT SECTOR SIZE
	MOV	E,A	;FORMAT SECTOR SIZE TO DE-REG
	MVI	D,0	;DOUBLE LENGTH
	DAD	D	;INDEX INTO MAX SECTOR NUMBER TABLE
	LDA	DENSTY	;GET FORMAT DENSITY FLAG
	ORA	A	;FORMAT DENSITY FLAG=0?
	JRZ	..SD3	;IF SO, CONTINUE
	DCX	H	;ELSE, DECREMENT TABLE POINTER
..SD3:	MOV	A,M	;GET NUMBER OF SECTORS/TRACK
	STA	SECTRK	;SET FORMAT NUMBER OF SECTORS/TRACK
	LXI	H,GAPTBL  ;GET GAP LENGTH TABLE
	LDA	SECSIZ	;GET FORMAT SECTOR SIZE
	DAD	D	;INDEX INTO GAP LENGTH TABLE
	DAD	D
	JRZ	..SD4	;IF FORMAT DENSITY FLAG=0, CONTINUE
	DCX	H	;ELSE, DECREMENT TABLE POINTER
..SD4:	MOV	A,M	;GET GAP LENGTH
	STA	GAPLEN	;SET FORMAT GAP LENGTH
	LDA	FLAGS	;GET FLAGS
	BIT	CRLF,A	;CR/LF REQUIRED FLAG SET?
	RZ		;IF NOT, DONE
	CALL	DMS	;ELSE, DISPLAY MESSAGE
	.ASCIS	[ACR] [ALF]
	RET		;DONE
;
GETOPT:	LXI	D,TBUF	;GET DEFAULT BUFFER
	LDAX	D	;GET BUFFER COUNT
	ORA	A	;BUFFER COUNT=0?
	RZ		;IF SO, DONE
	MOV	B,A	;ELSE, BUFFER COUNT TO B-REG
..SSL:	INX	D	;INCREMENT BUFFER POINTER
	LDAX	D	;GET CHARACTER FROM BUFFER
	CPI	";"	;CHARACTER=SEMICOLON?
	JRZ	..OSL	;IF SO, CONTINUE
	DJNZ	..SSL	;ELSE, CONTINUE
	RET		;DONE
..OSL:	DCR	B	;DECREMENT COMMAND BUFFER COUNT
	RZ		;IF COMMAND BUFFER COUNT=0, DONE
	INX	D	;INCREMENT BUFFER POINTER
	LDAX	D	;GET CHARACTER FROM BUFFER
	CALL	UPRCAS	;FORCE UPPER CASE
	CPI	"S"	;CHARACTER=S?
	JRNZ	..NSD	;IF NOT, CONTINUE
	JMPR	..FDC	;ELSE, CONTINUE
..NSD:	CPI	"D"	;CHARACTER=D?
	JRNZ	..NDD	;IF NOT, CONTINUE
..FDC:	STA	FMTDEN	;ELSE, SET FORMAT DENSITY
	JMPR	..OSL	;CONTINUE
..NDD:	CPI	"1"	;CHARACTER=1?
	JRNZ	..N1S	;IF NOT, CONTINUE
	JMPR	..NHC	;ELSE, CONTINUE
..N1S:	CPI	"2"	;CHARACTER=2?
	JRNZ	..N2S	;IF NOT, CONTINUE
..NHC:	STA	FMTHDS	;ELSE, SET FORMAT NUMBER OF HEADS
	JMPR	..OSL	;CONTINUE
..N2S:	CPI	"T"	;CHARACTER=T?
	JRNZ	..NTBO	;IF NOT, CONTINUE
	JMPR	..FTC	;ELSE, CONTINUE
..NTBO:	CPI	"C"	;CHARACTER=C?
	JRNZ	..OSL	;IF NOT, CONTINUE
..FTC:	STA	FMTTYP	;ELSE, SET FORMAT TYPE
	JMPR	..OSL	;CONTINUE
;
MSNTBL:	.BYTE	26	;N=0,1, 26 SECTORS
	.BYTE	15	;N=1,2, 15 SECTORS
	.BYTE	8	;N=2,3,  8 SECTORS
;
GAPTBL:	.BYTE	1BH,36H	;N=0,1
	.BYTE	2AH,54H	;N=1,2
	.BYTE	3AH,74H	;N=2,3
;
INPLN:	LXI	D,INBUF	;GET INPUT BUFFER
	MVI	C,CIBFCN  ;C=CONSOLE IN BUFFERED FUNCTION
	CALL	OPSYS	;GET CONSOLE INPUT
	LDA	INBUF+1	;GET CONSOLE INPUT LENGTH
	ORA	A	;CONSOLE INPUT LENGTH=0?
	RZ		;IF SO, DONE
	LDA	INBUF+2	;ELSE, GET CONSOLE INPUT CHARACTER
	RET		;DONE
;
DMS:	XTHL		;GET MESSAGE ADDRESS
	CALL	MSGHL	;DISPLAY MESSAGE
	XTHL		;SET UP RETURN ADDRESS
	RET		;DONE
;
MSGHL:	PUSH	PSW	;SAVE AF
..L:	MOV	A,M	;GET MESSAGE BYTE
	INX	H	;INCREMENT POINTER
	CALL	CONOUT	;DISPLAY CHARACTER
	ORA	A	;LAST CHARACTER?
	JP	..L	;IF NOT, CONTINUE
	POP	PSW	;ELSE, RESTORE AF
	RET		;DONE
;
CONOUT:	PUSH	B	;SAVE REGISTERS
	PUSH	D
	PUSH	H
	PUSH	PSW
	ANI	7FH	;STRIP SIGN BIT FROM CHARACTER
	MOV	E,A	;OUTPUT CHARACTER TO E-REG
	MVI	C,RCOFCN  ;C=RAW CONSOLE OUTPUT FUNCTION
	CALL	OPSYS	;OUTPUT CHARACTER TO CONSOLE
	POP	PSW	;RESTORE REGISTERS
	POP	H
	POP	D
	POP	B
	RET		;DONE
;
UPRCAS:	CPI	"a"	;LOWER CASE ALPHA?
	RC		;IF NOT, DONE
	CPI	"z"+1	;LOWER CASE ALPHA?
	RNC		;IF NOT, DONE
	SUI	20H	;ELSE, FORCE UPPER CASE
	RET		;DONE
;
.XSYM
.END
