.PAGE	85
.TITLE	"TURBODOS OPERATING SYSTEM FORMAT A DISK UTILITY PROGRAM"
.SBTTL	"COPYRIGHT (C) 1982, SOFTWARE 2000, INC."
;
; COPYRIGHT (C) 1982, SOFTWARE 2000, INC.
;
; VERSION: 09/29/82
;
.IDENT	FORMAT		;MODULE ID
;
.INSERT	EQUATE		;SYMBOLIC EQUIVALENCES
;
REP	= 0		;REPEAT FLAG (OPTFLG)
VFY	= 1		;VERIFY ONLY FLAG (OPTFLG)
;
	.LOC	.PROG.#	;LOCATE IN PROGRAM AREA
;
	.ASCII	"COPYRIGHT (C) 1982, SOFTWARE 2000, INC."
	.ASCII	" (VERSION 09/29/82) "  ;VERSION DATE
;
START:	LXI	SP,STACK  ;SET UP STACK POINTER
	MVI	C,ROUFCN  ;C=RETURN ORIGIN/UNIT FUNCTION
	CALL	OPSYS	;GET ORIGIN/UNIT NUMBER
	BIT	7,B	;PRIVILEGED USER?
	JZ	..NPU	;IF NOT, CONTINUE
	LDA	TFCB	;ELSE, GET DEFAULT FCB DRIVE
	ORA	A	;FORMAT DRIVE SPECIFIED?
	JZ	..NFDS	;IF NOT, CONTINUE
	DCR	A	;ELSE, DECREMENT FORMAT DRIVE
	STA	PDRDRV	;SET PD REQUEST DRIVE
	CALL	GETOPT	;ELSE, GET OPTIONS
	LDA	OPTFLG	;GET OPTION FLAGS
	BIT	VFY,A	;VERIFY ONLY FLAG SET?
	JNZ	..VFYO	;IF SO, CONTINUE
	LDA	PDRDRV	;ELSE, GET FORMAT DRIVE
	CALL	LOKDRV	;LOCKOUT FORMAT DRIVE
	JNZ	..LFDE	;IF FORMAT DRIVE IN USE, CONTINUE
..FMT:	CALL	FMTNIT#	;ELSE, INITIALIZE FORMAT PARAMETERS
	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Insert disk to be formatted in drive "
	LDA	PDRDRV	;GET PD REQUEST DRIVE
	ADI	"A"	;ADD ASCII BIAS
	CALL	CONOUT	;DISPLAY PD REQUEST DRIVE LETTER
	CALL	FLSHCI	;FLUSH CONSOLE INPUT
	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Enter <CR> to begin formatting "
..CRL1:	CALL	CONIN	;GET CONSOLE INPUT
	CPI	ACR	;CHARACTER=CARRIAGE RETURN?
	JRZ	..CR1	;IF SO, CONTINUE
	CPI	AETX	;CHARACTER=CONTROL C?
	JZ	..ERRX	;IF SO, CONTINUE
	CALL	DMS	;ELSE, SOUND BELL
	.ASCIS	[ABEL]
	JMPR	..CRL1	;CONTINUE
..CR1:	MVI	A,3	;GET RETURN READY FUNCTION NUMBER
	STA	PDRFCN	;SET PD REQUEST PACKET FUNCTION
	CALL	XECPDA	;RETURN FORMAT DRIVE READY STATUS
	JZ	..FDNR	;IF DRIVE NOT READY, CONTINUE
	CALL	DMS	;ELSE, DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCII	"Starting format pass"
	.ASCIS	[ACR] [ALF]
	LHLD	NMBTRK#	;GET NUMBER OF TRACKS
	SHLD	TRKCNT	;SET TRACK COUNT
	LXI	H,0
	SHLD	PDRTRK	;SET PD REQUEST TRACK NUMBER=0
..FCL:	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	"."
	LDA	NMBHDS#	;GET NUMBER OF HEADS
	STA	HEADCT	;SET HEAD COUNT
	XRA	A
	STA	HEADNO	;SET HEAD NUMBER=0
..FHL:	CALL	TRKNIT#	;INITIALIZE TRACK BUFFER
	ORA	A	;TRACK BUFFER INITIALIZED OK?
	JNZ	..IFME	;IF NOT, CONTINUE
	MVI	A,4	;GET FORMAT TRACK FUNCTION NUMBER
	STA	PDRFCN	;SET PD REQUEST PACKET FUNCTION
..FTL:	CALL	XECPDA	;FORMAT TRACK
	JRZ	..FMTC	;IF NO ERRORS, CONTINUE
	CALL	DMS
	.ASCII	[ACR] [ALF]
	.ASCIS	"Format"
	CALL	ERRCOM	;PROCESS FORMAT ERROR
	JC	..X	;IF CONTROL C, CONTINUE
	JRZ	..FTL	;IF CARRIAGE RETURN, CONTINUE
..FMTC:	CALL	CONST	;ELSE, GET CONSOLE STATUS
	ORA	A	;CHARACTER AVAILABLE?
	JRZ	..NCA1	;IF NOT, CONTINUE
	CALL	CONIN	;ELSE, GET CONSOLE INPUT CHARACTER
	CPI	AETX	;CHARACTER=CONTROL C?
	JRNZ	..FMTC	;IF NOT, CONTINUE
	CALL	DMS	;ELSE, DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Format aborted"
	JMP	..X	;CONTINUE
..NCA1:	LXI	H,HEADNO  ;GET HEAD NUMBER
	INR	M	;INCREMENT HEAD NUMBER
	LXI	H,HEADCT  ;GET HEAD COUNT
	DCR	M	;DECREMENT HEAD COUNT
	JRNZ	..FHL	;CONTINUE FOR ALL HEADS
	LHLD	PDRTRK	;GET PD REQUEST TRACK NUMBER
	INX	H	;INCREMENT PD REQUEST TRACK NUMBER
	SHLD	PDRTRK	;UPDATE PD REQUEST TRACK NUMBER
	LHLD	TRKCNT	;GET TRACK COUNT
	DCX	H	;DECREMENT HEAD COUNT
	SHLD	TRKCNT	;UPDATE TRACK COUNT
	MOV	A,H
	ORA	L	;TRACK COUNT=0?
	JRNZ	..FCL	;IF NOT, CONTINUE
	CALL	DMS	;ELSE, DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCII	"Successful format"
	.ASCII	[ACR] [ALF]
	.ASCIS	"Starting verify pass"
	JMPR	..CR2	;CONTINUE
..VFYO:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Insert disk to be verified in drive "
	LDA	PDRDRV	;GET PD REQUEST DRIVE
	ADI	"A"	;ADD ASCII BIAS
	CALL	CONOUT	;DISPLAY PD REQUEST DRIVE LETTER
	CALL	FLSHCI	;FLUSH CONSOLE INPUT
	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Enter <CR> to begin verifying "
..CRL2:	CALL	CONIN	;GET CONSOLE INPUT
	CPI	ACR	;CHARACTER=CARRIAGE RETURN?
	JRZ	..CR2	;IF SO, CONTINUE
	CPI	AETX	;CHARACTER=CONTROL C?
	JZ	..ERRX	;IF SO, CONTINUE
	CALL	DMS	;ELSE, SOUND BELL
	.ASCIS	[ABEL]
	JMPR	..CRL2	;CONTINUE
..CR2:	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	[ACR] [ALF]
	LXI	H,VFYDST  ;GET VERIFY DST ADDRESS
	SHLD	PDRDMA	;SET PD REQUEST PACKET DMA ADDRESS
	MVI	A,2	;GET RETURN DST FUNCTION NUMBER
	STA	PDRFCN	;SET PD REQUEST PACKET FUNCTION
	CALL	XECPDA	;SELECT VERIFY DRIVE
	JZ	..VDNR	;IF DRIVE NOT READY, CONTINUE
	LHLD	SECTRK	;GET NUMBER OF SECTORS/TRACK
	SHLD	PDRSC	;SET PD REQUEST SECTOR COUNT
	DAD	H	;SHIFT HL-REG LEFT 7 (*128)
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LDA	SECSIZ	;GET SECTOR SIZE
..SL:	DCR	A	;DECREMENT SECTOR SIZE
	JM	..SLX	;IF UNDERFLOW, CONTINUE
	DAD	H	;ELSE, SHIFT BYTE COUNT LEFT
	JMPR	..SL	;CONTINUE
..SLX:	SHLD	PDRTC	;SET PD REQUEST TRANSFER COUNT
	LXI	D,.END.#  ;GET VERIFY BUFFER ADDRESS
	SDED	PDRDMA	;SET PD REQUEST PACKET DMA ADDRESS
	DAD	D	;CALC END OF DMA ADDRESS
	XCHG		;END OF DMA ADDRESS TO DE-REG
	LHLD	OPSYS+1	;GET TOP OF TRANSIENT PROGRAM AREA
	ORA	A	;CLEAR CARRY FLAG
	DSBC	D	;SUFFICIENT MEMORY FOR TRACK READ?
	JC	..IVME	;IF NOT, CONTINUE
	LHLD	TRKDSK	;ELSE, GET NUMBER OF TRACKS/DISK
	SHLD	TRKCNT	;SET TRACK COUNT
	XRA	A	;ELSE, GET READ FUNCTION
	STA	PDRFCN	;SET PD REQUEST PACKET FUNCTION
	LXI	H,0	;GET TRACK 0
	SHLD	PDRTRK	;SET PD REQUEST PACKET TRACK=0
	SHLD	PDRSEC	;SET PD REQUEST PACKET SECTOR=0
..VCL:	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	"."
..VTL:	CALL	XECPDA	;READ PD REQUEST TRACK
	JRZ	..VFYC	;IF NO ERRORS, CONTINUE
	CALL	DMS
	.ASCII	[ACR] [ALF]
	.ASCIS	"Verify"
	CALL	ERRCOM	;PROCESS VERIFY ERROR
	JC	..X	;IF CONTROL C, CONTINUE
	JRZ	..VTL	;IF CARRIAGE RETURN, CONTINUE
..VFYC:	CALL	CONST	;ELSE, GET CONSOLE STATUS
	ORA	A	;CHARACTER AVAILABLE?
	JRZ	..NCA2	;IF NOT, CONTINUE
	CALL	CONIN	;ELSE, GET CONSOLE INPUT CHARACTER
	CPI	AETX	;CHARACTER=CONTROL C?
	JRNZ	..VFYC	;IF NOT, CONTINUE
	CALL	DMS	;ELSE, DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Verify aborted"
	JMP	..X	;CONTINUE
..NCA2:	LHLD	PDRTRK	;GET PD REQUEST TRACK NUMBER
	INX	H	;INCREMENT PD REQUEST TRACK NUMBER
	SHLD	PDRTRK	;UPDATE PD REQUEST TRACK NUMBER
	LHLD	TRKCNT	;GET TRACK COUNT
	DCX	H	;DECREMENT HEAD COUNT
	SHLD	TRKCNT	;UPDATE TRACK COUNT
	MOV	A,H
	ORA	L	;TRACK COUNT=0?
	JRNZ	..VCL	;IF NOT, CONTINUE
	CALL	DMS	;ELSE, DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Successful verify"
	JMP	..X	;CONTINUE
..NPU:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Non-privileged user" [ABEL]
	JMP	..ERRX	;DONE
..NFDS:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"No format drive specified" [ABEL]
	JMP	..ERRX	;CONTINUE
..LFDE:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Unable to lockout format drive" [ABEL]
	JMP	..ERRX	;CONTINUE
..FDNR:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCII	"Format drive not ready" [ABEL]
	.ASCIS	[ACR] [ALF]
	JMP	..FMT	;CONTINUE
..IFME:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Insufficient memory to format" [ABEL]
	JMPR	..ERRX	;CONTINUE
..IVME:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCIS	"Insufficient memory to verify" [ABEL]
	LDA	OPTFLG	;GET OPTION FLAGS
	BIT	VFY,A	;VERIFY ONLY FLAG SET?
	JRNZ	..ERRX	;IF SO, CONTINUE
	JMPR	..X	;ELSE, CONTINUE
..VDNR:	CALL	DMS	;DISPLAY MESSAGE
	.ASCII	[ACR] [ALF]
	.ASCII	"Verify drive not ready" [ABEL]
	.ASCIS	[ACR] [ALF]
	LDA	OPTFLG	;GET OPTION FLAGS
	BIT	VFY,A	;VERIFY ONLY FLAG SET?
	JZ	..FMT	;IF NOT, CONTINUE
	JMP	..VFYO	;ELSE, CONTINUE
..ERRX:	LXI	H,OPTFLG  ;GET OPTION FLAGS
	RES	REP,M	;RESET REPEAT FLAG
..X:	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	[ACR] [ALF]
	LDA	OPTFLG	;GET OPTION FLAGS
	BIT	REP,A	;REPEAT FLAG SET?
	JZ	WBOOT	;IF NOT, DONE
	BIT	VFY,A	;VERIFY ONLY BIT SET?
	JZ	..FMT	;IF NOT, CONTINUE
	JMP	..VFYO	;ELSE, CONTINUE
;
GETOPT:	LXI	D,TBUF	;GET DEFAULT BUFFER
	LDAX	D	;GET BUFFER COUNT
	ORA	A	;BUFFER COUNT=0?
	RZ		;IF SO, DONE
	MOV	B,A	;ELSE, BUFFER COUNT TO B-REG
..SSL:	INX	D	;INCREMENT BUFFER POINTER
	LDAX	D	;GET CHARACTER FROM BUFFER
	CPI	";"	;CHARACTER=SEMICOLON?
	JRZ	..OS	;IF SO, CONTINUE
	DJNZ	..SSL	;ELSE, CONTINUE
	RET		;DONE
..OS:	LXI	H,OPTFLG  ;GET OPTION FLAGS
..OSL:	DCR	B	;DECREMENT COMMAND BUFFER COUNT
	RZ		;IF COMMAND BUFFER COUNT=0, DONE
	INX	D	;INCREMENT BUFFER POINTER
	LDAX	D	;GET CHARACTER FROM BUFFER
	CALL	UPRCAS	;FORCE UPPER CASE
	CPI	"R"	;CHARACTER=R?
	JRNZ	..NREP	;IF NOT, CONTINUE
	SET	REP,M	;ELSE, SET REPEAT FLAG
	JMPR	..OSL	;CONTINUE
..NREP:	CPI	"V"	;CHARACTER=V?
	JRNZ	..OSL	;IF NOT, CONTINUE
	SET	VFY,M	;ELSE, SET VERIFY ONLY FLAG
	JMPR	..OSL	;CONTINUE
;
LOKDRV:	MOV	E,A	;FORMAT DRIVE TO E-REG
	PUSH	D	;SAVE DRIVE
	MVI	D,0FFH	;D=LOCK DRIVE FLAG
	MVI	C,LFDFCN  ;C=LOCKOUT/FREE DRIVE FUNCTION
	CALL	OPSYS	;LOCKOUT DRIVE
	POP	D	;RESTORE DRIVE
	ORA	A	;LOCKOUT SUCCESSFUL?
	RNZ		;IF NOT, DONE
	MVI	D,80H	;D=FREE BUFFER FLAG
	MVI	C,FFBFCN  ;C=FLUSH/FREE BUFFERS FUNCTION
	CALL	OPSYS	;FLUSH FREE DRIVE BUFFERS
	XRA	A	;SET ZERO FLAG
	RET		;DONE
;
XECPDA:	LXI	D,PDRDP	;GET PD REQUEST PACKET ADDRESS
	MVI	C,PDAFCN  ;C=PHYSICAL DISK ACCESS FUNCTION
	CALL	OPSYS	;PERFORM PHYSICAL DISK ACCESS
	ORA	A	;RETURN CODE=0?
	RET		;DONE
;
ERRCOM:	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	" error, Drive: "
	LDA	PDRDRV	;GET PD REQUEST DRIVE
	ADI	"A"	;ADD ASCII BIAS
	CALL	CONOUT	;DISPLAY DRIVE LETTER
	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	", Track: "
	LHLD	PDRTRK	;GET PD REQUEST TRACK NUMBER
	CALL	DECOUT	;DISPLAY SORCE TRACK NUMBER
	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	" (Retry, Ignore, Abort) "
..CIL:	CALL	DMS	;SOUND BELL
	.ASCIS	[ABEL]
	CALL	FLSHCI	;FLUSH CONSOLE INPUT
..CSL:	CALL	CONST	;GET CONSOLE STATUS
	ORA	A	;CHARACTER AVAILABLE?
	JRZ	..CSL	;IF NOT, CONTINUE
	CALL	CONIN	;ELSE, GET CONSOLE INPUT
	CALL	UPRCAS	;FORCE UPPER CASE
	CPI	"A"	;CHARACTER=ABORT?
	STC		;SET CARRY FLAG
	JRZ	..X	;IF CHARACTER=CONTROL C, CONTINUE
	CPI	"R"	;CHARACTER=RETRY?
	JRZ	..X	;IF SO, CONTINUE
	CPI	"I"	;CHARACTER=IGNORE?
	JRNZ	..CIL	;IF NOT, CONTINUE
	ORA	A	;ELSE, CLEAR ZERO FLAG
..X:	CALL	DMS	;DISPLAY MESSAGE
	.ASCIS	[ACR] [ALF]
	RET		;DONE
;
FLSHCI:	CALL	CONST	;GET CONSOLE STATUS
	ORA	A	;CHARACTER AVAILABLE?
	RZ		;IF NOT, DONE
	CALL	CONIN	;ELSE ,GET CONSOLE INPUT CHARACTER
	JMPR	FLSHCI	;CONTINUE
;
DECOUT:	MVI	C,0	;CLEAR LEADING ZERO FLAG
	LXI	D,10000	;DISPLAY TEN THOUSANDS DIGIT
	CALL	..DO
	LXI	D,1000	;DISPLAY THOUSANDS DIGIT
	CALL	..DO
	LXI	D,100	;DISPLAY HUNDREDS DIGIT
	CALL	..DO
	LXI	D,10	;DISPLAY TENS DIGIT
	CALL	..DO
	INR	C	;INCREMENT LEADING ZERO FLAG
	LXI	D,1	;DISPLAY UNITS DIGIT
..DO:	MVI	B,-1	;PRESET QUOTENT
	ORA	A	;CLEAR CARRY FLAG
..DL:	INR	B	;INCREMENT QUOTENT
	DSBC	D	;SUBTRACT DIVISOR
	JRNC	..DL	;UNTIL UNDERFLOW
	DAD	D	;RESTORE UNDERFLOW
	MOV	A,B	;GET QUOTENT
	ORA	A	;QUOTENT=0?
	JRNZ	..DD	;IF NOT, DISPLAY DIGIT
	INR	C
	DCR	C	;LEADING ZERO FLAG SET?
	RZ		;IF NOT, DONE
..DD:	ADI	"0"	;ADD ASCII BIAS
	CALL	CONOUT	;DISPLAT CHARACTER
	INR	C	;INCREMENT LEADING ZERO FLAG
	RET		;DONE
;
DMS:	XTHL		;GET MESSAGE ADDRESS
	CALL	MSGHL	;DISPLAY MESSAGE
	XTHL		;SET UP RETURN ADDRESS
	RET		;DONE
;
MSGHL:	PUSH	PSW	;SAVE AF
..L:	MOV	A,M	;GET MESSAGE BYTE
	INX	H	;INCREMENT POINTER
	CALL	CONOUT	;DISPLAY CHARACTER
	ORA	A	;LAST CHARACTER?
	JP	..L	;IF NOT, CONTINUE
	POP	PSW	;ELSE, RESTORE AF
	RET		;DONE
;
CONST:	PUSH	B	;SAVE REGISTERS
	PUSH	D
	PUSH	H
	MVI	C,CSFCN	;C=CONSOLE STATUS FUNCTION
	CALL	OPSYS	;GET CONSOLE STATUS
	POP	H	;RESTORE REGISTERS
	POP	D
	POP	B
	RET		;DONE
;
CONIN:	PUSH	B	;SAVE REGISTERS
	PUSH	D
	PUSH	H
	MVI	C,RCIFCN  ;C=RAW CONSOLE INPUT FUNCTION
	CALL	OPSYS	;GET CONSOLE INPUT
	POP	H	;RESTORE REGISTERS
	POP	D
	POP	B
	RET		;DONE
;
CONOUT:	PUSH	B	;SAVE REGISTERS
	PUSH	D
	PUSH	H
	PUSH	PSW
	ANI	7FH	;STRIP SIGN BIT FROM CHARACTER
	MOV	E,A	;OUTPUT CHARACTER TO E-REG
	MVI	C,RCOFCN  ;C=RAW CONSOLE OUTPUT FUNCTION
	CALL	OPSYS	;OUTPUT CHARACTER TO CONSOLE
	POP	PSW	;RESTORE REGISTERS
	POP	H
	POP	D
	POP	B
	RET		;DONE
;
UPRCAS:	CPI	"a"	;LOWER CASE ALPHA?
	RC		;IF NOT, DONE
	CPI	"z"+1	;LOWER CASE ALPHA?
	RNC		;IF NOT, DONE
	SUI	20H	;ELSE, FORCE UPPER CASE
	RET		;DONE
;
	.LOC	.DATA.#	;LOCATE IN DATA AREA
;
HEADNO::.BYTE	0	;HEAD NUMBER
;
PDRDP::			;PD REQUEST PACKET
PDRFCN::.BYTE	0	;PD REQUEST FUNCTION
PDRDRV::.BYTE	0	;PD REQUEST DRIVE NUMBER
PDRTRK::.WORD	0	;PD REQUEST TRACK NUMBER
PDRSEC::.WORD	0	;PD REQUEST SECTOR NUMBER
PDRSC::	.WORD	0	;PD REQUEST SECTOR COUNT
PDRTC::	.WORD	0	;PD REQUEST TRANSFER COUNT
PDRDMA::.WORD	0	;PD REQUEST DMA ADDRESS
PDRDST::.WORD	0	;PD REQUEST DST ADDRESS
;
VFYDST:			;VERIFY DST AREA
BLKSIZ:	.BYTE	0	;BLOCK SIZE
NMBLKS:	.WORD	0	;NUMBER OF ALLOCATION BLOCKS
NMBDIR:	.BYTE	0	;NUMBER OF DIRECTORY BLOCKS
SECSIZ:	.BYTE	0	;SECTOR SIZE
SECTRK:	.WORD	0	;SECTORS/TRACK
TRKDSK:	.WORD	0	;TRACKS/DISK
RESTRK:	.WORD	0	;RESERVED TRACKS
;
OPTFLG:	.BYTE	0	;OPTION FLAGS
TRKCNT:	.WORD	0	;TRACK COUNT
HEADCT:	.BYTE	0	;HEAD COUNT
;
	.BLKW	64	;STACK AREA
STACK	= .		;TOP OF STACK AREA
;
.XSYM
.END	START
                         