* CAP.CMD - Close Accounting Period or Month
*
STORE TRIM(TITLE) TO MTITLE
ERASE
@ 1,10 SAY TMARK + "  " + CNAME
SET INTE OFF
@ 3,10 SAY MTITLE
SET INTE ON
STORE 5 TO ROW
@ 5,10   SAY "You may use this program to close either a single month or all"
@ 6,10   SAY "months currently open. This process involves rolling up dollar"
@ 7,10   SAY "amounts stored in transactions and adding them to totals stored"
@ 8,10   SAY "in the chart of accounts file, then deleting the transactions."   
@ 9,10   SAY "Closing a period or month will only affect current period totals"
@ 10,10  SAY "on the income statement and the amount of detail printed on the"
@ 11,10  SAY "general ledger and detailed transaction reports. Further, closing"
@ 12,10  SAY "an accounting period does not affect the amount of detail printed"
@ 13,10  SAY "on your AR and AP reports or your journal registers. It is "
@ 14,10  SAY "normally a good practice to backup all your files at this point as"
@ 15,10  SAY "a set and label as such. Make sure you have printed the following"
@ 16,10  SAY "reports before closing:"
@ 18,10  SAY "        General ledger report"
@ 19,10  SAY "        Detailed accounting transactions"
@ 20,10  SAY "        Income statement"
@ 21,10  SAY "        Balance sheet"
STORE " " TO ANSWER
@ 23,10 SAY "Enter just a RETURN to proceed or (Q)uit " GET ANSWER PICTURE "!"
READ
IF ANSWER = "Q"
   RETURN
ENDIF
ERASE
@ 1,10 SAY TMARK + "  " + CNAME
SET INTE OFF
@ 3,10 SAY MTITLE
SET INTE ON
SELECT PRIMARY
USE DAACCT INDEX DAACCT1
SELECT SECONDARY
USE DATRAN
STORE "   " TO MONTH
DO WHILE (MONTH < "01" .OR. MONTH > "12") .AND. !(MONTH) <> "ALL"
   STORE "   " TO MONTH
   @ ROW,10 SAY "Enter the month  you wish to close (01-12) or 'ALL' " GET MONTH
   READ
ENDDO
IF !(MONTH) = "ALL"
   STORE " " TO CRITERIA
   ELSE 
   STORE "FOR PDATE = TRIM(MONTH)" TO CRITERIA
ENDIF
COUNT TO ALLT
COUNT &CRITERIA TO DELT
STORE 7 TO ROW
@ 7,10 SAY STR(DELT,5)+" OF "+STR(ALLT,5)+" transaction records will be removed from"
@ 8,10 SAY "your accounting transaction file by this closing. Do you wish to"
@ 9,10 SAY "copy these records to a backup file before they are deleted? If"
@ 10,10 SAY "yes, you will be asked for the name of the file to copy to so be"
@ 11,10 SAY "prepared. Enter just RETURN to copy or anything else to not copy."
STORE "COPY" TO ANSWER
@ 12,10 GET ANSWER PICTURE "!!!!"
READ
IF ANSWER = "COPY"
   @ 14,10 SAY "Enter a filename (.DBF extension not necessary) to which you wish"
   @ 15,10 SAY "these transactions copied. Do not enter the name of an exsisting "
   @ 16,10 SAY "file unless you want that file replaced. You may preface the name"
   @ 17,10 SAY "with a drive if you wish or use the default drive of " + ACC + "."
   STORE "          " TO FILE
   @ 18,10 SAY "File name is " GET FILE
   READ
   @ 19,10 SAY "Now copying to " + FILE
   COPY ALL &CRITERIA TO &FILE
   STORE ROW + 12 TO ROW
   ELSE
   @ 14,10 SAY "A backup copy of the transactions was not made."
   STORE ROW + 8 TO ROW
ENDIF
STORE ROW + 1 TO ROW
STORE " " TO ANSWER
@ ROW,10 SAY "Enter just a RETURN to close or (Q)uit " GET ANSWER PICTURE "!"
READ
IF ANSWER = "Q"
   RETURN
ENDIF
STORE ROW + 1 TO ROW
@ ROW,10 SAY "Standby while we close some transactions."
COPY ALL &CRITERIA TO DATEMP
SELECT SECONDARY
USE DATEMP
SORT ON ACCT:NUMB TO DATEMP1
USE
SELECT PRIMARY
UPDATE FROM DATEMP1 ON ACCT:NUMB ADD AMOUNT
SELECT SECONDARY
USE DATRAN 
DELETE ALL &CRITERIA
PACK
INDEX ON ACCT:NUMB+PDATE TO DATRAN1
INDEX ON PDATE TO DATRAN2
RETURN
