ter
	ei				;enable interrupts
	ret				;done
;
sioint:	ld	(spsave),sp		;save stack pointer
	ld	sp,auxstk		;set up auxilliary stack
	push	af			;save af-reg
	xor	a			;get bank 0
	call	selmem			;select bank 0
	call	sioisr##		;process serial i/o interrupt
	di				;disable interrupts
	ld	a,1			;get bank 1
	call	selmem			;select bank 1
	pop	af			;restore af-reg
	ld	sp,(spsave)		;restore stack pointer
	ei				;enable interrupts
	ret				;done
;
selbnk::
	di				;disable interrupts
	call	selmem			;select memory bank
	ei				;enable interrupts
	ret				;done
;
selmem:	or	a			;bank 0 requested?
	jr	nz,..bnk1		;if not, continue
	xor	a			;else, get bank 1 command
	out	(memcr2),a		;de-select lower 48k of memory
	ld	a,0efh			;get bank 0 command
	out	(memcr1),a		;enable lower 48k of memory
	jp	frebnk			;free bank 1 mutual exclusion
..bnk1:	call	lokbnk			;gain bank 1 mutual exclusion
	ld	a,0e8h			;get bank 0 command
	out	(memcr1),a		;de-select lower 48k of memory
	ld	a,07h			;get bank 1 command
	out	(memcr2),a		;enable lower 48k of memory
	ret				;done
;
spsave:	dw	0			;stack pointer save area
	ds	16*2			;auxilliary stack area
auxstk	equ	$			;top of auxilliary stack area
;
	dseg				;locate in data area
;
bk1sph:	dw	1			;memory bank 1 exclusion semaphore
..mxhd:	dw	..mxhd
	dw	..mxhd
;
	cseg				;locate in program area
;
lokbnk::
	push	bc			;save registers
	push	de
	push	hl
	ld	a,r			;get interrupt status
	push	af			;save interrupt status
	ld	hl,bk1sph		;get mutual exclusion semaphore
	call	wait##			;wait on mutual exclusion
	di				;disable interrupts
	pop	af			;restore interrupt status
	jp	po,..x			;if interrupts disabled, continue
	ei				;else, enable interrupts
..x:	pop	hl			;restore registers
	pop	de
	pop	bc
	ret				;done
;
frebnk::
	push	bc			;save registers
	push	de
	push	hl
	ld	hl,bk1sph		;get mutual exclusion semaphore
	call	signal##		;release mutual exclusion
	pop	hl			;restore registers
	pop	de
	pop	bc
	ret				;done
;
	end
	TITLE	TURBODOS OPERATING SYSTEM - SUPER SIX DISK DRIVER
	subttl	copyright 1983, software 2000, inc.
	.Z80
;
; copyright 1983, software 2000, inc.
;	converted to MICROSOFT M80 format by
;	  Advanced Digital Corp.
;
; version: 02/16/84 doc
;
	NAME	('S6DSK')		;module id
;
	INCLUDE DREQUATE.LIB		;driver symbolic equivalences
;
false	equ	0			;logical equates
true	equ	not false
;
banked	equ	true 			;true for banked 1.3 system
;
;
ctcch3	equ	0bh			;ctc channel 3 register
;
fdccsr	equ	0ch			;fdc command/status register
fdctrk	equ	0dh			;fdc track register
fdcsec	equ	0eh			;fdc sector register
fdcdat	equ	0fh			;fdc data register
;
dmactl	equ	10h			;dma control register
;
fdcdsr	equ	14h			;fdc drive select register
;
fdccal	equ	08h			;fdc re-calibrate command
fdcskn	equ	10h			;fdc seek command without head load
fdcskh	equ	18h			;fdc seek command with head load
fdcrdc	equ	82h			;fdc read sector command
fdcwrc	equ	0a2h			;fdc write sector command
fdcrid	equ	0c0h			;fdc read id command
fdcint	equ	0d0h			;fdc interrupt command
fdcfmt	equ	0f0h			;fdc format track command
;
hsdbit	equ	2			;head settle delay bit
;
dmardc	equ	01h			;dma read command
dmawrc	equ	05h			;dma write command
;
tsd	equ	2			;two sided disk bit
ddd	equ	3			;double density disk bit
mini	equ	4			;mini-floppy disk bit
tpi96	equ	5			;96-tpi disk bit
;
maxtry	equ	10			;max disk try count
;
	PUBLIC	maxfpy
;
	DSEG				;locate in data area
;
drvtbl::
	db	0,0,1 shl mini,1 shl mini or 1 shl tpi96  ;drive table
;
drive:	db	0ffh			;drive number
sector:	db	0			;sector number
seccnt:	db	0			;sector count
trycnt:	db	0			;try counter
dlybit:	db	0			;head settle delay bit
intcst:	db	0			;interrupt completion status
rwerrs:	db	0			;read/write error status
dsrsav:	db	0			;drive select register save
ndxcnt:	db	0			;index pulse sequence count
ndxtic:	db	0			;index pulse tick count
retsp:	dw	0			;error return stack pointer
trktbl:	db	0ffh,0ffh,0ffh,0ffh	;track save table
ridbuf:	ds	6			;read id buffer
;
dmxsph:					;mutual exclusion semaphore
	dw	1			;semaphore count
..dmxh:	dw	..dmxh			;semaphore p/d head
	dw	..dmxh
;
dwtsph:					;disk wait semaphore
	dw	0			;semaphore count
..dwth:	dw	..dwth			;semaphore p/d head
	dw	..dwth
;
dmapgm:					;dma controller program list
	db	0c3h			;write register 6
	db	08bh			;write register 6
	db	79h			;write register 0
dmaadr:	dw	0			;dma address
dmalen:	dw	0			;dma length
	db	14h			;write register 1
	db	28h			;write register 2
	db	85h			;write register 4
	db	fdcdat			;fdc data port address
	db	8ah			;write register 5
	db	0cfh			;write register 6
dmarwc:	db	05h			;dma read/write command
	db	0cfh			;write register 6
	db	87h			;write register 6
;
dmapll	equ	$-dmapgm		;dma controller program list length
;
	common	/?init?/		;locate in initialization area
;
dskin@::
	call	clrfdc			;clear fdc
	ld	hl,dskisr		;get interrupt service routine
	ld	(ctcvec##+6),hl		;set interrupt vector address
	ret				;done
;
	cseg				;locate in program area
;
dskdr@::
	ld	hl,dmxsph  		;get mutual exclusion semaphore
	call	wait##			;dispatch if necessary
	call	..dd			;call disk driver
	push	af			;save return code
	ld	hl,dmxsph		;get mutual exclusion semaphore
	call	signal##		;signal process as ready
	pop	af			;restore return code
	ret				;done
;
..dd:	ld	(retsp),sp		;save error return stack pointer
	ld	a,(ix+pdrfcn)		;get function number
	or	a			;function number=0?
	jr	z,rddsk			;if so, continue
	dec	a			;function number=1?
	jr	z,wrdsk			;if so, continue
	dec	a			;function number=2?
	jp	z,retdst		;if so, continue
	dec	a			;function number=3?
	jp	z,retrdy		;if so, continue
	dec	a			;function number=4?
	jr	z,fmtdsk		;if so, continue
	ret				;else, done
;
rddsk:	ld	a,maxtry		;get max try count
	ld	(trycnt),a		;set try counter
..rd:	call	setup			;do common setup
	jr	nz,..err		;if seek error, continue
..rdl:	call	rwcom1			;else, do read/write common #1
	ld	de,fdcrdc shl 8 or 9dh	;get fdc read command/mask
	call	rwcom2			;do read/write common #2
	ld	a,dmardc		;get dma read command
	call	dmacom			;do dma common
	call	rwcom3			;do read/write common #3
	jr	nz,..rdl		;if not last sector, continue
	ld	a,(rwerrs)		;else, get read/write error status
	or	a			;read/write error status=0?
	ret	z			;if so, done
..err:	call	retry			;else, re-calibrate drive
	jr	..rd			;try again
;
wrdsk:	ld	a,maxtry		;get max try count
	ld	(trycnt),a		;set try counter
..wr:	call	setup			;do common setup
	jr	nz,..err1		;if seek error, continue
..wrl:	call	rwcom1			;else, do read/write common #1
	ld	de,fdcwrc shl 8 or 0fdh	;get fdc read command/mask
	call	rwcom2			;do read/write common #2
	ld	a,dmawrc		;get dma write command
	call	dmacom			;do dma common
	call	rwcom3			;do read/write common #3
	jr	nz,..wrl		;if not last sector, continue
	ld	a,(rwerrs)		;else, get read/write error status
	or	a			;read/write error status=0?
	jr	nz,..err1		;if not, continue
	call	setup			;else, do common setup
	jr	nz,..err1		;if seek error, continue
..vfl:	call	rwcom1			;else, do read/write common #1
	ld	d,fdcrdc		;get fdc read command
	call	rwcom2			;do read/write common #2
	ld	a,d			;get fdc read command
	call	fdccmd			;output fdc read command
	and	99h			;extract relevant status bits
	call	rwcom3			;do read/write common #3
	jr	nz,..vfl		;if not last sector, continue
	ld	a,(rwerrs)		;else, get read/write error status
	or	a			;read/write error status=0?
	ret	z			;if so, done
..err1:	call	retry			;else, re-calibrate drive
	jr	..wr			;try again
;
fmtdsk:	ld	a,maxtry		;get max try count
	ld	(trycnt),a		;set try counter
..fmt:	call	seldsk			;select disk
	jp	nz,fatal		;if drive not ready, continue
	ld	a,(dsrsav)		;get saved drive select register
	bit	7,(ix+pdrsec)		;double density requested?
	jr	nz,..ddr		;if so, continue
	res	3,a			;else, reset double density bit
..ddr:	bit	7,(ix+pdrsec+1)		;side one requested?
	jr	z,..s1nr		;if not, continue
	set	2,a			;else, set side one select bit
..s1nr:	out	(fdcdsr),a		;select drive/side/density
	ld	(dsrsav),a		;save drivcall	delay##			;delay for one second
	ld	a,03h			;get ctc reset command
	out	(ctcch3),a		;reset ctc channel 3
	call	clrfdc			;clear fdc
	ld	hl,ndxcnt		;set index pulse sequence count
	ld	a,(hl)			;get index pulse sequence count
	ld	(hl),0			;set index pulse sequence count=0
	or	a			;index pulse sequence count=0?
	cpl				;preset return code=0ffh
	ret	z			;if sequence count=0, done
	xor	a			;else, set return code=0
	ret				;done
;
seldsk:	ld	a,(ix+pdrdrv)		;get requested drive
	set	3,a			;set double density bit
	call	getdta			;get drive table address
	bit	mini,(hl)		;mini-floppy disk?
	jr	z,..nmfd		;if not, continue
	set	4,a			;else, set mini-floppy disk bit
..nmfd:	out	(fdcdsr),a		;select requested drive
	ld	(dsrsav),a		;save drive select register value
	call	clrfdc			;clear fdc
	and	80h			;drive ready?
	ret	nz			;if not, done
	ld	(dlybit),a		;else, set head settle delay bit=0
	ld	a,(drive)		;get drive number
	cp	(ix+pdrdrv)		;drive number=requested drive?
	ret	z			;if so, done
	cp	0ffh			;drive number invalid?
	jr	z,..dni			;if so, continue
	call	..gtta			;else, get track save table address
	in	a,(fdctrk)		;get fdc track register
	ld	(hl),a			;save fdc track register
..dni:	ld	a,(ix+pdrdrv)		;get requested drive
	ld	(drive),a		;set drive number
	call	..gtta			;get track save table address
	ld	a,(hl)			;get fdc track register
	out	(fdctrk),a		;set fdc track register
	out	(fdcdat),a		;set fdc data register
	ld	a,fdcskn		;get fdc seek command
	call	fdccmd			;output fdc seek command
	xor	a			;set return code=0
	ret				;done
..gtta:	ld	e,a			;drive number to de-reg
	ld	d,0			;double length
	ld	hl,trktbl		;get track save table
	add	hl,de			;index into track save table
	ret				;done
;
readid:	ld	hl,ridbuf		;get read id b