TYPE EPSON.AQM

::::::::::
EPSON.AQM
::::::::::
; TYPE FONT SELECTON ROUTINE FOR EPSON MX SERIES
; DOT MATRIX PRINTERS.
;
; ASSEMBLE WITH CP/M'S ASSEMBLER AND LOADER
;
; AUTHOR:       Thomas E. Enright
; DATE:         9/26/83
;
; Version:      1.4     (first release to public domain)
;
; INITIALIZATION AREA

        ; ASCII CHARACTERS
        CR      EQU     0DH             ; CARRIAGE RETURN
        LF      EQU     0AH             ; LINE FEED
        MIN     EQU     31H             ; MIN ALLOWED INPUT CHOICE
        MAX     EQU     37H             ; MAX ALLOWED INPUT CHOICE

        ; VIDEO CONTROL CHARACTERS FOR KAYPRO 2, 4 AND 10
        CLS     EQU     1AH             ; CLEAR SCRN & HOME CURS
        CP1     EQU     1BH             ; 1ST CHAR OF CURSOR POSITION
        CP2     EQU     3DH             ; 2ND CHAR OF CURSOR POSITION
        OFFSET  EQU     20H             ; OFFSET FOR CURSOR POSITION
        EOL     EQU     18H             ; ERASE TO END OF LINE

        ; BDOS FUNCTIONS
        RCONF   EQU     1               ; READ CON: TO A
        WCONF   EQU     2               ; WRITE A TO CON:
        WLSTF   EQU     5               ; WRITE TO LST:

        ; CP/M ADDRESSES
        BDOS    EQU     05H             ; BDOS ENTRY
        TPA     EQU     100H            ; TPA LOCATION

        ; START OF PROGRAM
        ORG     TPA                     ; ASSEMBLE HERE
        LXI     H,00H                   ; CLEAR HL PAIR
        DAD     SP                      ; HL PAIR NOW HAS SYSTEM STACK ADDR.
        SHLD    OLDSP                   ; SAVE SYSTEM STACK ADDRESS
        LXI     SP,STAK                 ; START USER STACK
        JMP     START
        
        DB      '  COPYRIGHT  1983  THOMAS E. ENRIGHT '
        DB      ' PERMISSION TO COPY FOR  NON-COMMERCIAL USE IS GRANTED '
        DB      ' PROVIDED THIS MESSAGE REMAINS UNCHANGED '


; BEGIN MAINLINE OF PROGRAM

START:  MVI     A,CLS                   ; CLEAR SCREEN AND HOME CURSOR
        CALL    CO
        CALL    SPMSG                   ; PRINT INITIAL MSG
        DB      CP1,CP2,03H+OFFSET,0AH+OFFSET,'Copyright 1983 by T. Enright'
        DB      CP1,CP2,05H+OFFSET,0AH+OFFSET,'Bring printer on line,'
        DB      CP1,CP2,06H+OFFSET,0AH+OFFSET,'set top of form, then'
        DB      CP1,CP2,06H+OFFSET,0AH+OFFSET,'Press RETURN to continue',0
        CALL    CI                      ; GET GO AHEAD
        MVI     A,CLS                   ; CLEAR SCREEN
        CALL    CO
        LXI     H,STAN                  ; POINT TO PRN RESET SEQ
        CALL    PMSG                    ; SEND IT
        LXI     H,MENU                  ; POINT TO MENU
        CALL    COMSG                   ; WRITE TO CON:
START1: CALL    SPMSG                   ; POSITION CURSOR
        DB      CP1,CP2,11H+OFFSET,1BH+OFFSET,'Enter number of choice : ',0
        CALL    CI                      ; GET CHOICE
        CPI     MIN                     ; LESS THAN MINIMUM
        JM      ERR1                    ; YES - ERROR MSG
        ORA     A
        MOV     C,A                     ; PRESERVE CHOICE
        SUI     MAX                     ; GREATER THAN MAXIMUM
        JM      START2                  ; NO
ERR1:   CALL    SPMSG                   ; YES - ERROR MSG
        DB      CP1,CP2,11H+OFFSET,1BH+OFFSET,EOL,'*** Input out of range ***'
        DB      CP1,CP2,12H+OFFSET,1BH+OFFSET,'Press RETURN to continue',0
        CALL    CI
        CALL    SPMSG
        DB      CP1,CP2,11H+OFFSET,1AH+OFFSET,EOL,LF,EOL,0
        JMP     START1                  ; RE-INPUT CHOICE
START2: MOV     A,C                     ; RESTORE CHOICE
        ORA     A

CMP1:   CPI     '1'                     ; CHOICE 10 CPI?
        JNZ     CMP2                    ; NO
CMP1A:  MVI     A,02H                   ; UPDATE STATUS FLAGS
        STA     STAT1                   ; 10 CPI FLAG
        MVI     A,01H
        STA     STAT2                   ; 17 CPI FLAG
        LXI     H,CMPOFF                ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0AH+OFFSET,2DH+OFFSET,'ON'
        DB      CP1,CP2,0BH+OFFSET,2DH+OFFSET,EOL,0
        JMP     START1                  ; GET NEXT INPUT

CMP2:   CPI     '2'                     ; 17CPI ?
        JNZ     CMP3                    ; NO
        LDA     STAT4                   ; GET ENHANCED STATUS
        CPI     01H                     ; ENHANCED ON ?
        JZ      CMP2A                   ; NO
        CALL    CERROR                  ; YES - ERROR MSG
        JMP     START1                  ; START OVER
CMP2A:  LDA     STAT2                   ; GET 17 CPI STATUS
        CPI     01H                     ; ALREADY 17 CPI ?
        JNZ     CMP1A                   ; YES - TOGGLE TO 10 CPI
        MVI     A,02H                   ; UPDATE STATUS FLAG
        STA     STAT2
        LXI     H,CMPON                 ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0AH+OFFSET,2DH+OFFSET,EOL
        DB      CP1,CP2,0BH+OFFSET,2DH+OFFSET,'ON',0
        JMP     START1                  ; GET NEXT INPUT

CMP3:   CPI     '3'                     ; DBL STRIKE ?
        JNZ     CMP4                    ; NO
        LDA     STAT3                   ; CHECK STATUS FLAG
        CPI     01H                     ; DBL STRIKE ALREADY ON ?
        JNZ     CMP3A                   ; YES - TURN IT OFF
        MVI     A,02H
        STA     STAT3                   ; UPDATE STATUS FLAG
        LXI     H,DBLON                 ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0CH+OFFSET,2DH+OFFSET,'ON',0
        JMP     START1                  ; AGAIN
CMP3A:  MVI     A,01H                   ; UPDATE STATUS FLAG
        STA     STAT3
        LXI     H,DBLOFF                ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN MSG
        DB      CP1,CP2,0CH+OFFSET,2DH+OFFSET,EOL,0
        JMP     START1                  ; AGAIN

CMP4:   CPI     '4'                     ; ENHANCED ?
        JNZ     CMP5                    ; NO
        LDA     STAT2                   ; CHECK STATUS OF 17 CPI
        CPI     01H                     ; 17 CPI ON ?
        JZ      CMP4A                   ; NO
        CALL    CERROR                  ; YES - ERROR MSG
        JMP     START1                  ; BACK TO START
CMP4A:  LDA     STAT4                   ; CHECK ENHANCED STATUS
        CPI     01H                     ; ENHANCED ALREADY ON ?
        JNZ     CMP4B                   ; YES - TURN IT OFF
        MVI     A,02H                   ; UPDATE STAT FLAG
        STA     STAT4
        LXI     H,ENHON                 ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0DH+OFFSET,2DH+OFFSET,'ON',0
        JMP     START1                  ; AGAIN
CMP4B:  MVI     A,01H                   ; UPDATE STAT FLAG
        STA     STAT4
        LXI     H,ENHOFF                ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0DH+OFFSET,2DH+OFFSET,EOL,0
        JMP     START1                  ; PLAY IT AGAIN SAM

CMP5:   CPI     '5'                     ; ITALICS ?
        JNZ     CMP6                    ; NO
        LDA     STAT5                   ; CHECK STATUS FLAG
        CPI     01H                     ; ITALICS ALREADY ON ?
        JNZ     CMP5A                   ; YES - TURN IT OFF
        MVI     A,02H                   ; UPDATE STATUS FLAG
        STA     STAT5
        LXI     H,ITON                  ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0EH+OFFSET,2DH+OFFSET,'ON',0
        JMP     START1                  ; AGAIN
CMP5A:  MVI     A,01H                   ; UPDATE STATUS FLAG
        STA     STAT5
        LXI     H,ITOFF                 ; SEND PRINTER CODE
        CALL    PMSG
        CALL    SPMSG                   ; UPDATE SCREEN STATUS
        DB      CP1,CP2,0EH+OFFSET,2DH+OFFSET,EOL,0
        JMP     START1                  ; AGAIN

CMP6:   CPI     '6'                     ; EXIT ?
        JNZ     START1                  ; NO
        LHLD    OLDSP                   ; RESTORE SYSTEM STACK
        SPHL
        RET                             ; RETURN DIRECT TO SYSTEM

;*****************************************************************
;*
;*              SUBROUTINES BEGIN HERE
;*
;*****************************************************************


; CONSOLE INPUT WITH CHAR MASKED TO 7 BITS

CI:     PUSH    B                       ; SAVE ENVIRONMENT
        PUSH    D
        PUSH    H
        MVI     C,RCONF                 ; READ CON:
        CALL    BDOS
        ANI     7FH                     ; MASK
        POP     H                       ; RESTORE ENVIRONMENT
        POP     D
        POP     B
        RET

; CHAR IN A OUT TO CONSOLE

CO:     PUSH    B                       ; WE MUST PRESERVE THE
        PUSH    D                       ; THE ENVIRONMENT
        PUSH    H
        MVI     C,WCONF                 ; SELECT FUNCTION
        MOV     E,A
        CALL    BDOS                    ; WRITE
        POP     H                       ; RESTORE
        POP     D
        POP     B
        RET

; MESSAGE POINTED TO BY HL OUT TO CON:

COMSG:  MOV     A,M                     ; GET CHAR
        ORA     A                       ; 0 IS TERMINATOR
        RZ                              ; RETURN FROM HERE
        CALL    CO                      ; OUT SHE GOES
        INX     H                       ; NEXT
        JMP     COMSG                   ; AGAIN

; MESSAGE POINTED TO BY STACK OUT TO CONSOLE

SPMSG:  XTHL                            ; GET RET ADDR TO HL
        XRA     A                       ; CLEAR FLAGS AND ACCUM
        ADD     M                       ; GET ONE CHAR
        INX     H                       ; POINT TO NEXT
        XTHL                            ; RESTORE STACK FOR
        RZ                              ; RETURN IF DONE
        CALL    CO                      ; ELSE DISPLAY CHAR
        JMP     SPMSG                   ; AGAIN

; COMPRESSED/ENHANCED CONFLICT ERROR ROUTINE

CERROR: LXI     H,ERR2                  ; POINT TO MSG
        CALL    COMSG                   ; OUT TO CON:
        CALL    CI                      ; GET GO AHEAD
        CALL    SPMSG                   ; ERASE ERROR MSG
        DB      CP1,CP2,11H+OFFSET,1AH+OFFSET,EOL,LF,EOL,LF,EOL,0
        RET

; CHAR IN A OUT TO LIST DEVICE

PO:     PUSH    B                       ; WE MUST PRESERVE THE
        PUSH    D                       ; THE ENVIRONMENT
        PUSH    H
        MVI     C,WLSTF                 ; SELECT FUNCTION
        MOV     E,A
        CALL    BDOS                    ; WRITE
        POP     H                       ; RESTORE
        POP     D
        POP     B
        RET

; MESSAGE POINTED TO BY HL OUT TO LIST DEVICE

PMSG:   MOV     A,M                     ; GET CHAR
        ORA     A                       ; 0 IS TERMINATOR
        RZ                              ; RETURN FROM HERE
        CALL    PO                      ; OUT SHE GOES
        INX     H                       ; NEXT
        JMP     PMSG                    ; AGAIN


        ; MAIN MENU FOR PROGRAM
        ; CP1 IS CURSOR POSITION LEAD IN CHARACTER
        ; CP2 IS 2ND CHARACTER IN CURSOR POSITIONING SEQUENCE
        ; 3RD AND 4TH CHARACTERS ARE ROW THEN COLUMN IN HEX.

MENU:   DB      CP1,CP2,04H+OFFSET,19H+OFFSET,'Epson MX-Series'
        DB      CP1,CP2,06H+OFFSET,16H+OFFSET,'Type Font Selections'
        DB      CP1,CP2,08H+OFFSET,11H+OFFSET,'Your choices are :'
        DB      CP1,CP2,0AH+OFFSET,16H+OFFSET,'1. 10 cpi (default)    ON '
        DB      CP1,CP2,0BH+OFFSET,16H+OFFSET,'2. 17 cpi (compressed)    '
        DB      CP1,CP2,0CH+OFFSET,16H+OFFSET,'3. Double Strike          '
        DB      CP1,CP2,0DH+OFFSET,16H+OFFSET,'4. Enhanced               '
        DB      CP1,CP2,0EH+OFFSET,16H+OFFSET,'5. Italics                '
        DB      CP1,CP2,0FH+OFFSET,16H+OFFSET,'6. Exit to CP/M',0

        ; PRINTER CONTROL SEQUENCES FOR EPSON MX-SERIES

        ; STANDARD 10 CPI
STAN:   DB      20H,1BH,40H,CR,0

        ; COMPRESSED 17 CPI
CMPON:  DB      20H,0FH,CR,0
CMPOFF: DB      20H,12H,CR,0

        ; DOUBLE STRIKE BOLDFACE
DBLON:  DB      20H,1BH,47H,CR,0
DBLOFF: DB      20H,1BH,48H,CR,0

        ; ENHANCED PRINT (SINGLE PASS)
ENHON:  DB      20H,1BH,45H,CR,0
ENHOFF: DB      20H,1BH,46H,CR,0

        ; ITALICS FONT
ITON:   DB      20H,1BH,34H,CR,0
ITOFF:  DB      20H,1BH,35H,CR,0

        ; PRINTER STATUS FLAGS
        ; 02H = ON    01H = OFF
STAT1:  DB      02H                     ; 10 CPI
STAT2:  DB      01H                     ; 17 CPI
STAT3:  DB      01H                     ; DBL STRIKE
STAT4:  DB      01H                     ; ENHANCED
STAT5:  DB      01H                     ; ITALICS

        ; ERROR MSG FOR ENHANCED/COMPRESSED CONFLICT
ERR2:   DB      CP1,CP2,11H+OFFSET,1BH+OFFSET,EOL,'Enhanced not compatable'
        DB      CP1,CP2,12H+OFFSET,1BH+OFFSET,'with compressed print'
        DB      CP1,CP2,13H+OFFSET,1BH+OFFSET,'Press RETURN to continue',0


;*******************************************************************
;*
;*              SCRATCH AREA
;*
;*******************************************************************

; STACK AREA

        DS      40H                     ; RESERVE USER STACK
STAK:   DB      0

OLDSP:  DB      00H,00H                 ; SAVE AREA FOR SYSTEM STACK


        END
[UTILITY] 00:53>he file LU.COM is searched for in SPECIAL.LBR on the C
   drive.  If  found,  LU.COM  is  loaded,  and the strings -O,