::::::::::
LASER.ASM
::::::::::
; SELECTON ROUTINE FOR HP LASERJET PRINTER
;
;
; ASSEMBLE WITH CP/M'S ASSEMBLER AND LOADER
;
; AUTHOR:	Thomas E. Enright
; DATE:		9/26/83
;
; Version:	1.4	(first release to public domain)
;
; INITIALIZATION AREA

	; ASCII CHARACTERS
	CR	EQU	0DH		; CARRIAGE RETURN
	LF	EQU	0AH		; LINE FEED
	MIN	EQU	31H		; MIN ALLOWED INPUT CHOICE
	MAX	EQU	55H		; MAX ALLOWED INPUT CHOICE

	; VIDEO CONTROL CHARACTERS FOR FREEDOM 100 TERMINAL
	CLS	EQU	1AH		; CLEAR SCRN & HOME CURS
	CP1	EQU	1BH		; 1ST CHAR OF CURSOR POSITION
	CP2	EQU	3DH		; 2ND CHAR OF CURSOR POSITION
	OFFSET	EQU	20H		; OFFSET FOR CURSOR POSITION

	; BDOS FUNCTIONS
	RCONF	EQU	1		; READ CON: TO A
	WCONF	EQU	2		; WRITE A TO CON:
	WLSTF	EQU	5		; WRITE TO LST:

	; CP/M ADDRESSES
	BDOS	EQU	05H		; BDOS ENTRY
	TPA	EQU	100H		; TPA LOCATION

	; START OF PROGRAM
	ORG	TPA			; ASSEMBLE HERE
	LXI	H,00H			; CLEAR HL PAIR
	DAD	SP			; HL PAIR NOW HAS SYSTEM STACK ADDR.
	SHLD	OLDSP			; SAVE SYSTEM STACK ADDRESS
	LXI	SP,STAK			; START USER STACK
	JMP	START
	
;	DB	'  COPYRIGHT  1983  THOMAS E. ENRIGHT '
;	DB	' PERMISSION TO COPY FOR  NON-COMMERCIAL USE IS GRANTED '
;	DB	' PROVIDED THIS MESSAGE REMAINS UNCHANGED '


; BEGIN MAINLINE OF PROGRAM

START:	MVI	A,CLS			; CLEAR SCREEN AND HOME CURSOR
	CALL	CO
	CALL	SPMSG			; PRINT INITIAL MSG
	DB	CP1,CP2,03H+OFFSET,16H+OFFSET,'Copyright 1983 by T. Enright'
	DB	CP1,CP2,05H+OFFSET,16H+OFFSET,'Bring LaserJet on line,'
	DB	CP1,CP2,06H+OFFSET,16H+OFFSET,'Press RETURN to continue',0
	CALL	CI			; GET GO AHEAD
	MVI	A,CLS			; CLEAR SCREEN
	CALL	CO
	LXI	H,RESET			; POINT TO PRN RESET SEQ
	CALL	PMSG			; SEND IT
	LXI	H,MENU			; POINT TO MENU
	CALL	COMSG			; WRITE TO CON:
START1: CALL	SPMSG			; POSITION CURSOR
	DB	CP1,CP2,15H+OFFSET,14H+OFFSET,'Enter number of choice : ',0
	CALL	CI			; GET CHOICE
	CPI	MIN			; LESS THAN MINIMUM
	JM	ERR1			; YES - ERROR MSG
	ORA	A
	MOV	C,A			; PRESERVE CHOICE
	SUI	MAX			; GREATER THAN MAXIMUM
	JM	START2			; NO
ERR1:	CALL	SPMSG			; YES - ERROR MSG
	DB	CP1,CP2,15H+OFFSET,12H+OFFSET,'*** Input out of range ***'
	DB	CP1,CP2,16H+OFFSET,12H+OFFSET,'Press RETURN to continue',0
	CALL	CI
	CALL	SPMSG
	DB	CP1,CP2,15H+OFFSET,08H+OFFSET,1BH,54H,CR,LF,1BH,54H
        DB      CP1,CP2,16H+OFFSET,08H+OFFSET,1BH,54H,CR,0
	JMP	START1			; RE-INPUT CHOICE
START2: MOV	A,C			; RESTORE CHOICE
	ORA	A

CMP1:	CPI	'1'			; PORTRAIT MODE?
	JNZ	CMP2			; NO
	MVI	A,02H			; UPDATE STATUS FLAGS
	STA	STAT1			; PORTRAIT FLAG
	LXI	H,PRTRT			; SEND PRINTER CODE
	CALL	PMSG
	CALL	SPMSG			; UPDATE SCREEN STATUS
	DB	CP1,CP2,0AH+OFFSET,2FH+OFFSET,'ON '
        DB      CP1,CP2,0BH+OFFSET,2FH+OFFSET,'OFF',0
	JMP	START1			; GET NEXT INPUT

CMP2:	CPI	'2'			; LANDSCAPE ?
	JNZ	CMP3			; NO
	MVI	A,02H			; UPDATE STATUS FLAG
	STA	STAT2
	LXI	H,LNSCPE		; SEND PRINTER CODE
	CALL	PMSG
	CALL	SPMSG			; UPDATE SCREEN STATUS
	DB	CP1,CP2,0BH+OFFSET,2FH+OFFSET,'ON '
        DB      CP1,CP2,0AH+OFFSET,2FH+OFFSET,'OFF',0
	JMP	START1			; GET NEXT INPUT

CMP3:	CPI	'3'			; TOP MARGIN ?
	JNZ	CMP4			; NO
	MVI	A,02H
	STA	STAT3			; UPDATE STATUS FLAG
	LXI	H,TMAR			; SEND PRINTER CODE
	CALL	PMSG
	CALL	SPMSG			; UPDATE SCREEN STATUS
	DB	CP1,CP2,0CH+OFFSET,2FH+OFFSET,'ON',0
	JMP	START1			; AGAIN

CMP4:	CPI	'4'			; LEFT MARGIN ?
	JNZ	CMP5			; NO
	MVI	A,02H			; UPDATE STAT FLAG
	STA	STAT4
	LXI	H,LMAR			; SEND PRINTER CODE
	CALL	PMSG
	CALL	SPMSG			; UPDATE SCREEN STATUS
	DB	CP1,CP2,0DH+OFFSET,2FH+OFFSET,'ON',0
	JMP	START1			; AGAIN

CMP5:	CPI	'5'			; RIGHT MARGIN ?
	JNZ	CMP6			; NO
	MVI	A,02H			; UPDATE STATUS FLAG
	STA	STAT5
	LXI	H,RMAR			; SEND PRINTER CODE
	CALL	PMSG
	CALL	SPMSG			; UPDATE SCREEN STATUS
	DB	CP1,CP2,0EH+OFFSET,2FH+OFFSET,'ON',0
	JMP	START1			; AGAIN

CMP6:	CPI	'6'			; CLEAR MARGINS ?
	JNZ	CMPC			; NO
	LXI	H,CLMAR			; SEND PRINTER CODE
	CALL	PMSG
	CALL	SPMSG			; UPDATE SCREEN STATUS
	DB	CP1,CP2,0FH+OFFSET,2DH+OFFSET,'MARGINS CLEAR',0
	JMP	START1

CMPC:	CPI	'C'			; EXIT ?
	JNZ	CMPT			; NO
	LXI	H,PRPAG			; PRINT PAGE TO CLR OLD SETTINGS
	CALL	PMSG
	LHLD	OLDSP			; RESTORE SYSTEM STACK
	SPHL
	RET				; RETURN DIRECT TO SYSTEM

CMPT:	CPI	'T'			; PRINT TEST PAGE ?
	JNZ	START1			; NO
	LXI	H,PTEST			; POINT TO TEXT
	CALL	PMSG
	JMP	START1

;*****************************************************************
;*
;*		SUBROUTINES BEGIN HERE
;*
;*****************************************************************


; CONSOLE INPUT WITH CHAR MASKED TO 7 BITS

CI:	PUSH	B			; SAVE ENVIRONMENT
	PUSH	D
	PUSH	H
	MVI	C,RCONF			; READ CON:
	CALL	BDOS
	ANI	7FH			; MASK
	POP	H			; RESTORE ENVIRONMENT
	POP	D
	POP	B
	RET

; CHAR IN A OUT TO CONSOLE

CO:	PUSH	B			; WE MUST PRESERVE THE
	PUSH	D			; THE ENVIRONMENT
	PUSH	H
	MVI	C,WCONF			; SELECT FUNCTION
	MOV	E,A
	CALL	BDOS			; WRITE
	POP	H			; RESTORE
	POP	D
	POP	B
	RET

; MESSAGE POINTED TO BY HL OUT TO CON:

COMSG:	MOV	A,M			; GET CHAR
	ORA	A			; 0 IS TERMINATOR
	RZ				; RETURN FROM HERE
	CALL	CO			; OUT SHE GOES
	INX	H			; NEXT
	JMP	COMSG			; AGAIN

; MESSAGE POINTED TO BY STACK OUT TO CONSOLE

SPMSG:	XTHL				; GET RET ADDR TO HL
	XRA	A			; CLEAR FLAGS AND ACCUM
	ADD	M			; GET ONE CHAR
	INX	H			; POINT TO NEXT
	XTHL				; RESTORE STACK FOR
	RZ				; RETURN IF DONE
	CALL	CO			; ELSE DISPLAY CHAR
	JMP	SPMSG			; AGAIN


; CHAR IN A OUT TO LIST DEVICE

PO:	PUSH	B			; WE MUST PRESERVE THE
	PUSH	D			; THE ENVIRONMENT
	PUSH	H
	MVI	C,WLSTF			; SELECT FUNCTION
	MOV	E,A
	CALL	BDOS			; WRITE
	POP	H			; RESTORE
	POP	D
	POP	B
	RET

; MESSAGE POINTED TO BY HL OUT TO LIST DEVICE

PMSG:	MOV	A,M			; GET CHAR
	ORA	A			; 0 IS TERMINATOR
	RZ				; RETURN FROM HERE
	CALL	PO			; OUT SHE GOES
	INX	H			; NEXT
	JMP	PMSG			; AGAIN


	; MAIN MENU FOR PROGRAM
	; CP1 IS CURSOR POSITION LEAD IN CHARACTER
	; CP2 IS 2ND CHARACTER IN CURSOR POSITIONING SEQUENCE
	; 3RD AND 4TH CHARACTERS ARE ROW THEN COLUMN IN HEX.

MENU:	DB	CP1,CP2,04H+OFFSET,19H+OFFSET,'HP LaserJet Printer'
	DB	CP1,CP2,06H+OFFSET,16H+OFFSET,'Feature Selections'
	DB	CP1,CP2,08H+OF                        {;	x                        f;	                Y;                                                 	  GOgj-9;  Z~ + (~;  #++O@͍z;*3 $! O!w	6 #;? 6 #6 #!x 	6 ;T@͔?(
̀??. (7;i:(
!	@͔?ȷ@:w	7f;~x7:x 	A? <2w	8; ( :.*( w#;x:w	7 6?#;%	7[u	 ;7=6; Oy%	=;![u	Su	!  ͸ 0; 
O ))	)	 [;@#| #"	 !  
;&B͸8j 8))))o@0b;;~#	?@=|];P@T} ] 0:8;e	0 
??̀;{#M |}!	5ʐM ;	 (M T;HO~͑TT;  !%	~7(
5@*u	~#L;H"u	$!&	"u	$	
H; =
@={ a B;     ;	  _  J;	$ O                      k;	9                        ;	N                        ;	c          '
;	DB	CP1,CP2,1AH+OFFSET,16H+OFFSET,'16.                         '
	DB	CP1,CP2,12H+OFFSET,16H+OFFSET,'C. Return to CP/M       '
	DB	CP1,CP2,13H+OFFSET,16H+OFFSET,'T. Print Test Page      ',0

	; PRINT TEST PAGE
PTEST:	 DB	'THIS PAGE PRINT WILL CLEAR OLD SETTINGS AND INSTALL NEW',CR
	 DB	LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF,LF
	 DB	'                       END OF TEST',CR,LF,0CH,0

	; PRINTER ESCAPE SEQUENCES FOR HP LaserJet Printer

	; RESET PRINTER
RESET:	 DB	1BH,45H,CR,0
 
	; PORTRAIT MODE
PRTRT:	 DB	1BH,26H,6CH,30H,4FH,CR,0

	; LANDSCAPE MODE
LNSCPE:	 DB	1BH,26H,6CH,31H,4FH,CR,0

	; TOP MARGIN = 1 INCH
TMAR:	 DB	1BH,26H,6CH,36H,45H,CR,0

	; LEFT MARGIN = 1 INCH
LMAR:	 DB	1BH,26H,61H,39H,4CH,CR,0

	; RIGHT MARGIN = 1 INCH
RMAR:	 DB	1BH,26H,61H,37H,34H,4DH,CR,0

	; CLEAR MARGINS
CLMAR:	 DB	1BH,39H,CR,0

	; PRINT PAGE TO CLEAR OLD SETTINGS
PRPAG:   DB     '>                             NEW SETTINGS MADE',0CH,0

	; PRINTER STATUS FLAGS
	; 02H = ON    01H = OFF
STAT1:	DB	02H			; PORTRAIT
STAT2:	DB	01H			; LANDSCAPE
STAT3:	DB	01H			; TOP MARGIN
STAT4:	DB	01H			; LEFT MARGIN
STAT5:	DB	01H			; RIGHT MARGIN



;*******************************************************************
;*
;*		SCRATCH AREA
;*
;*******************************************************************

; STACK AREA

	DS	40H			; RESERVE USER STACK
STAK:	DB	0

OLDSP:	DB	00H,00H			; SAVE AREA FOR SYSTEM STACK


	END
