title hdfmt	Hard Disk Formatter for RMS

.z80

cseg

wboot	EQU	00001H
bdos	EQU	00005H

cr	equ	0dh
lf	equ	0ah
bell	equ	07h

hdfmt:	JP	start


drvno:	db	000H		;physical drive #
icylno:	db	003H		;initial cylinder #
fcylno:	db	098H		;final cylinder #
nheads:	db	007H		;# heads
intlv:	db	008H		;interleave factor


start:	LD	A,070H
	ADD	A,A		;is this a z80?
	JP	PE,godoit	;yes, jump

	LD	DE,notz80
	LD	C,009H
	JP	bdos

notz80:	db	'Z-80 only$'

godoit:	LD	SP,T0D34

	CALL	print
	db	'Blake Hard Disk Format Utility V1.01 '
	db	'(Created 28-Nov-83)',0

	CALL	noboot

exec:	LD	SP,T0D34
	CALL	getcmd
	CALL	getjmp
	CALL	A0C2B
	JR	exec

noboot:	LD	HL,(wboot)
	LD	(wboot_save),HL
	LD	HL,exec
	LD	(wboot),HL
	RET

getcmd:	CALL	print
	db	cr,lf,lf,'Options:',0

	CALL	print
	db	cr,lf,'  D: Select DISK to format',0

	CALL	print
	db	cr,lf,'  I: Set Disk INTERLEAVE Factor',0

	CALL	print
	db	cr,lf,'  F: Format disk to 128 bytes/sector',0

	CALL	print
	db	cr,lf,'  R: Build bad block REPLACEMENT TABLE',0

	CALL	print
	db	cr,lf,'  V: Verify disk',0

	CALL	print
	db	cr,lf,'  E: EXIT to CP/M (Insert system disk first)',0

	CALL	print
	db	cr,lf,'Drive is ',0

	LD	A,(drvno)
	ADD	A,'0'
	CALL	prntdig

	CALL	print
	db	', interleave factor is ',0

	LD	HL,(intlv)
	LD	H,0
	LD	A,1
	CALL	A0C44
	CALL	print
	db	cr,lf,'Selection: ',0

	RET

getjmp:	CALL	getchr

	LD	HL,cmdtbl
	LD	BC,00007H
	CPDR

	LD	HL,cmdjmp
	ADD	HL,BC
	ADD	HL,BC

	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A

	RET

cmdjmp:	DW	badcmd
	DW	seldsk
	DW	setint
	DW	format
	DW	badblk
	DW	verify
	DW	exit

	db	0FFH
	db	'D'
	db	'I'
	db	'F'
	db	'R'
	db	'V'
cmdtbl:	db	'E'

badcmd:	CALL	print
	db	bell,'?Illegal command',cr,lf,0

	RET

seldsk:	CALL	print
	db	'Select which drive: ',0

	CALL	getchr
	SUB	'0'
	CP	1		;drive # of 0 or 1?
	JR	Z,gooddr	;yes, jump
	JR	NC,baddr	;no, jump

gooddr:	LD	(drvno),A
	RET

baddr:	CALL	print
	db	bell,'?Bad drive ID - valid drives are 0 through 1',0

	RET

setint:	CALL	print
	db	'New interleave factor: ',0

	CALL	A0952
	JR	C,A0386

	OR	A
	JR	Z,A0386

	CP	035H
	JR	Z,A0382
	JR	NC,A0386

A0382:	LD	(intlv),A
	RET

A0386:	CALL	print
	db	bell,'?Bad range - must be 1 through ',0

	LD	HL,00035H
	LD	A,1
	CALL	A0C44
	RET

format:	CALL	A09B7
	CALL	A0794
	RET

verify:	CALL	print
	db	cr,lf,'?Not implemented',0

	RET

badblk:	CALL	A09B7
	CALL	A0794

	XOR	A
	LD	(D0B7D),A
	LD	HL,T0B7E
	LD	BC,0009DH
	LD	E,000H
	CALL	A0C76

	CALL	print
	db	cr,lf,lf,'Looking for bad sectors - this takes a while',0

	CALL	print
	db	cr,lf,'Checking pattern # 1',0

	LD	HL,08888H
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 2',0

	LD	HL,09249H
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 3',0

	LD	HL,0E656H
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 4',0

	LD	HL,0AAAAH
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 5',0

	LD	HL,05555H
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 6',0

	LD	HL,00F0FH
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 7',0

	LD	HL,02222H
	CALL	A0684

	CALL	print
	db	cr,lf,'Checking pattern # 8 (this is the last one)',0

	LD	HL,0E5E5H
	CALL	A0684

	CALL	print
	db	cr,lf,lf,'Marking sectors to be replaced',0

	CALL	A07E3

	CALL	print
	db	cr,lf,'Writing sector replacement table to disk',0

	CALL	A0848

	CAL	print
	db	cr,lf,lf,'Total of ',0

	LD	HL,(D0B7D)
	LD	H,0
	LD	A,1
	CALL	A0C44

	CALL	print
	db	' sector(s) replaced',0

	RET

exit:	LD	HL,(wboot_save)	;restore the warm boot adr
	LD	(wboot),HL
	RST	000H		;and exit (disabling ints??)

page
A05C2:	LD	A,(D0B7D)
	LD	B,A
	LD	HL,T0B7E

A05C9:	LD	A,B
	OR	A
	JR	Z,A05E9

	PUSH	HL
	LD	A,(D0B79)
	CP	(HL)
	JR	NZ,A05E0

	INC	HL
	LD	A,(D0B7A)
	CP	(HL)
	JR	NZ,A05E0

	INC	HL
	LD	A,(D0B7B)
	CP	(HL)

A05E0:	POP	HL
	RET	Z

	LD	DE,00003H
	ADD	HL,DE
	DEC	B
	JR	A05C9

A05E9:	LD	HL,D0B7D
	LD	A,(HL)
	CP	034H
	JR	C,A0614
	CALL	print
	db	cr,lf,bell,'?Replacement table overflow',0

	RET

A0614:	LD	A,(D0B79)
	OR	A
	JR	NZ,A0659

	LD	A,(D0B7A)
	CP	002H
	JR	Z,A0623
	JR	NC,A0659

A0623:	CALL	print
	db	bell,cr,lf,'?Bad sector on system track - cannot proceed',0

	JP	exec

A0659:	LD	E,(HL)
	LD	D,0
	INC	(HL)

	LD	HL,T0B7E
	ADD	HL,DE
	ADD	HL,DE
	ADD	HL,DE

	LD	A,(D0B79)
	LD	(HL),A
	INC	HL

	LD	A,(D0B7A)
	LD	(HL),A
	INC	HL

	LD	A,(D0B7B)
	LD	(HL),A

	CALL	print
	db	cr,lf,'Replacing',0

	CALL	A074C
	RET

A0684:	EX	DE,HL
	LD	HL,T0D34
	LD	BC,00D80H

A068B:	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL

	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,A068B

	CALL	A08AF
	CALL	A06F9
	RET

A069B:	XOR	A
	LD	(D0B74),A
	LD	(D0B75),A
	LD	(D0B76),A

	LD	HL,intlv
	LD	A,(HL)
	CP	036H
	JR	C,A06AF

	LD	A,035H

A06AF:	DEC	A
	LD	HL,T0AB6
	CALL	A09B2

	LD	A,(HL)
	LD	(D0B72),A

A06BA:	LD	A,(D0B72)
	LD	(D0B73),A

A06C0:	LD	HL,T0AEB
	LD	A,(D0B74)

	PUSH	AF
	ADD	A,A
	CALL	A09B2

	LD	(HL),000H
	INC	HL
	LD	A,(D0B76)

	LD	(HL),A
	POP	AF

	LD	HL,intlv
	ADD	A,(HL)
	CP	036H
	JR	C,A06DD

	SUB	036H

A06DD:	LD	(D0B74),A

	LD	HL,D0B76
	INC	(HL)

	LD	A,036H
	CP	(HL)
	RET	C
	RET	Z

	LD	HL,D0B73
	DEC	(HL)
	JR	NZ,A06C0

	LD	HL,D0B75
	INC	(HL)
	LD	A,(HL)

	LD	(D0B74),A
	JR	A06BA

A06F9:	LD	A,(icylno)
	LD	(D0B79),A

A06FF:	XOR	A
	LD	(D0B7A),A

A0703:	CALL	A0991
	CALL	A0A54
	CALL	A0A13
	CALL	A0724

	LD	HL,D0B7A
	INC	(HL)

	LD	A,(nheads)
	CP	(HL)
	JR	NC,A0703

	LD	HL,D0B79
	INC	(HL)

	LD	A,(fcylno)
	CP	(HL)
	JR	NC,A06FF

	RET

A0724:	XOR	A
	LD	(D0B7B),A
	LD	HL,T0D34

A072B:	LD	(D0B77),HL
	LD	HL,D0B7B
	LD	C,(HL)

	PUSH	HL
	CALL	A0A0A
	CALL	A0A33

	OR	A
	CALL	NZ,A05C2
	POP	HL

	INC	(HL)

	LD	A,035H
	CP	(HL)
	RET	C

	LD	HL,(D0B77)
	LD	DE,00080H
	ADD	HL,DE
	JR	A072B

A074C:	CALL	print
	db	' cylinder ',0

	LD	HL,(D0B79)
	LD	H,0
	LD	A,1
	CALL	A0C44

	CALL	print
	db	', head ',0

	LD	HL,(D0B7A)
	LD	H,0
	LD	A,1
	CALL	A0C44

	CALL	print
	db	', sector ',0

	LD	HL,(D0B7B)
	LD	H,0
	LD	A,1
	CALL	A0C44

	CALL	A0991
	RET

A0794:	CALL	print
	db	lf,'Formatting...',cr,lf,0

	CALL	A069B

	LD	A,(icylno)
	LD	(D0B79),A

A07B1:	XOR	A
	LD	(D0B7A),A

A07B5:	CALL	A0991
	CALL	A0923
	CALL	A0A54
	CALL	A0A13
	CALL	A09D1

	LD	HL,D0B7A
	INC	(HL)

	LD	A,(nheads)
	CP	(HL)
	JR	NC,A07B5

	LD	HL,D0B79
	INC	(HL)

	LD	A,(fcylno)
	CP	(HL)
	RET	C

	JR	A07B1

A07D9:	LD	HL,T0AEC
A07DC:	CP	(HL)
	DEC	HL
	RET	Z
	INC	HL
	INC	HL
	JR	A07DC

A07E3:	LD	A,(icylno)
	LD	(D0B79),A

A07E9:	XOR	A
	LD	(D0B7A),A

A07ED:	CALL	A0805

	LD	HL,D0B7A
	INC	(HL)

	LD	A,(nheads)
	CP	(HL)
	JR	NC,A07ED

	LD	HL,D0B79
	INC	(HL)

	LD	A,(fcylno)
	CP	(HL)
	JR	NC,A07E9

	RET

A0805:	CALL	A069B

	XOR	A
	LD	(D0B7C),A
	LD	HL,T0B7E
	LD	A,(D0B7D)
	LD	B,A

A0813:	LD	A,B
	OR	A
	JR	Z,A0839

	PUSH	HL
	LD	A,(D0B79)
	CP	(HL)
	JR	NZ,A0831

	INC	HL
	LD	A,(D0B7A)
	CP	(HL)
	JR	NZ,A0831

	INC	HL
	LD	A,(HL)
	CALL	A07D9

	LD	(HL),080H
	LD	A,0FFH
	LD	(D0B7C),A

A0831:	POP	HL

	LD	DE,3
	ADD	HL,DE
	DEC	B
	JR	A0813

A0839:	LD	A,(D0B7C)
	OR	A
	RET	Z

	CALL	A0A54
	CALL	A0A13
	CALL	A09D1
	RET

A0848:	XOR	A
	LD	(D0B79),A

	LD	A,002H
	LD	(D0B7A),A

	CALL	A0A54
	CALL	A0A13

	XOR	A
	LD	(D0B7B),A

	LD	B,002H
	LD	HL,D0B7D

A0860:	PUSH	BC
	LD	(D0B77),HL
	LD	BC,(D0B7B)
	CALL	A0A0A
	CALL	A0A1C
	POP	BC

	OR	A
	JR	NZ,A0880

	LD	HL,D0B7B
	INC	(HL)

	LD	HL,(D0B77)
	LD	DE,00080H
	ADD	HL,DE
	DJNZ	A0860
	RET

A0880:	CALL	print
	db	bell,cr,lf,"?Can't write Sector Replacement Table",0

	JP	exec

A08AF:	LD	A,(icylno)
	LD	(D0B79),A

A08B5:	XOR	A
	LD	(D0B7A),A

A08B9:	CALL	A0991
	CALL	A0A54
	CALL	A0A13
	CALL	A08DA

	LD	HL,D0B7A
	INC	(HL)
	LD	A,(nheads)
	CP	(HL)
	JR	NC,A08B9

	LD	HL,D0B79
	INC	(HL)
	LD	A,(fcylno)
	CP	(HL)
	JR	NC,A08B5

	RET

A08DA:	XOR	A
	LD	(D0B7B),A
	LD	HL,T0D34

A08E1:	LD	(D0B77),HL
	LD	HL,D0B7B
	LD	C,(HL)

	PUSH	HL
	CALL	A0A0A
	CALL	A0A1C
	OR	A
	CALL	NZ,A05C2

	POP	HL

	INC	(HL)
	LD	A,035H
	CP	(HL)
	RET	C

	LD	HL,(D0B77)
	LD	DE,00080H
	ADD	HL,DE
	JR	A08E1

; >> NO EXECUTION PATH TO HERE <<
	CALL	print
	db	bell,cr,lf,'?Hard read error at',0

	CALL	A074C
	CALL	crlf
	RET

A0923:	CALL	print
	db	cr,'cyl:',0

	LD	HL,(D0B79)
	LD	H,0
	LD	A,3
	CALL	A0C44

	CALL	print
	db	', Head:',0

	LD	HL,(D0B7A)
	LD	H,0
	LD	A,3
	CALL	A0C44

	CALL	print
	db	'  ',0

	RET

A0952:	CALL	A0976
	RET	C

	LD	DE,T0B5E
	CALL	A0C9B

	PUSH	DE
	CALL	A0C1A
	POP	DE

	RET	C
	CALL	A0C2C

	LD	A,L
	OR	A
	RET

getchr:	CALL	A0976

	LD	DE,T0B5E
	CALL	A0C9B

	LD	A,(DE)
	CALL	upcase
	RET

A0976:	LD	HL,T0B5C
	LD	BC,00016H
	LD	E,000H
	CALL	A0C76

	LD	DE,T0B5C
	LD	A,014H
	CALL	A0C7E

	PUSH	AF
	LD	A,0AH
	CALL	prntdig
	POP	AF
	RET

A0991:	CALL	A0CDC
	OR	A
	RET	Z

	CALL	A0CCB
	CP	3
	RET	NZ

	CALL	print
	db	'^C',cr,lf,0

	JP	exec

upcase:	CP	'a'
	RET	C

	CP	'z'
	JR	Z,islow
	RET	NC

islow:	SUB	020H
	RET

A09B2:	ADD	A,L
	LD	L,A
	RET	NC

	INC	H
	RET

A09B7:	XOR	A
	LD	(D0B7A),A

	CALL	A0A54

	LD	A,013H
	OUT	(081H),A

	LD	A,01FH
	OUT	(087H),A

	CALL	A0A4A

	LD	A,010H
	OUT	(087H),A

	CALL	A0A4A
	RET

A09D1:	CALL	A0A54

	LD	A,036H
	OUT	(082H),A

	LD	BC,08080H
	LD	HL,T0AEB
	LD	A,050H
	OUT	(087H),A

	CALL	A0A63

	OTIR

	CALL	A0A6A

	IN	A,(087H)
	AND	021H
	RET	Z

	CALL	print
	db	cr,lf,'?Write track error',0

	JP	exec

A0A0A:	LD	A,C
	OUT	(083H),A
	RET

; >> NO EXECUTION PATH TO HERE <<
	LD	(D0B77),BC
	RET

A0A13:	LD	A,(D0B79)
	OUT	(084H),A

	XOR	A
	OUT	(085H),A
	RET

A0A1C:	CALL	A0A54

	LD	BC,08080H
	LD	HL,(D0B77)
	LD	A,030H
	OUT	(087H),A

	CALL	A0A63

	OTIR

	CALL	A0A6A
	JR	A0A45

A0A33:	CALL	A0A54

	LD	A,020H
	OUT	(087H),A

	CALL	A0A6A

	LD	BC,08080H
	LD	HL,(D0B77)

	INIR

A0A45:	IN	A,(087H)
	AND	001H
	RET

A0A4A:	CALL	A0A6A

A0A4D:	IN	A,(087H)
	BIT	4,A
	JR	Z,A0A4D

	RET

A0A54:	LD	A,(drvno)
	ADD	A,A
	ADD	A,A
	ADD	A,A

	LD	HL,D0B7A
	OR	(HL)
	OR	060H
	OUT	(086H),A
	RET

A0A63:	IN	A,(087H)
	BIT	3,A
	JR	Z,A0A63

	RET

A0A6A:	EX	(SP),HL
	EX	(SP),HL
	PUSH	HL
	PUSH	DE

	LD	HL,00000H
	LD	E,006H

A0A73:	CALL	A0AAE
	JR	C,A0A80

	IN	A,(087H)

	ADD	A,A
	JR	C,A0A73

	POP	DE
	POP	HL
	RET

A0A80:	CALL	print
	db	bell,cr,lf,'?Controller timeout error, aborting.',0

	JP	exec

A0AAE:	DEC	HL
	LD	A,H
	OR	L
	RET	NZ

	DEC	E
	RET	NZ

	SCF
	RET


T0AB6:	db	036H
	db	01BH
	db	012H
	db	01BH
	db	036H
	db	009H
	db	036H
	db	01BH
	db	006H
	db	01BH
	db	036H
	db	009H
	db	036H
	db	01BH
	db	012H
	db	01BH
	db	036H
	db	003H
	db	036H
	db	01BH
	db	012H
	db	01BH
	db	036H
	db	009H
	db	036H
	db	01BH
	db	002H
	db	01BH
	db	036H
	db	009H
	db	036H
	db	01BH
	db	012H
	db	01BH
	db	036H
	db	003H
	db	036H
	db	01BH
	db	012H
	db	01BH
	db	036H
	db	009H
	db	036H
	db	01BH
	db	006H
	db	01BH
	db	036H
	db	009H
	db	036H
	db	01BH
	db	012H
	db	01BH
	db	036H

T0AEB:	db	0FEH

T0AEC:	db	026H
	db	0CBH
	db	07EH
	db	028H
	db	008H
	db	021H
	db	02CH
	db	030H
	db	0CDH
	db	016H
	db	02BH
	db	018H
	db	007H
	db	023H
	db	0CDH
	db	04FH
	db	030H
	db	0CDH
	db	003H
	db	02BH
	db	0CDH
	db	0FBH
	db	026H
	db	0CDH
	db	056H
	db	030H
	db	0DAH
	db	0B6H
	db	007H
	db	020H
	db	064H
	db	018H
	db	006H
	db	0CDH
	db	0EFH
	db	026H
	db	0CDH
	db	0FEH
	db	026H
	db	07EH
	db	023H
	db	0CBH
	db	047H
	db	020H
	db	00AH
	db	0CDH
	db	04FH
	db	030H
	db	0CDH
	db	0FEH
	db	026H
	db	097H
	db	008H
	db	018H
	db	03FH
	db	0F5H
	db	0CDH
	db	0F5H
	db	026H
	db	097H
	db	008H
	db	008H
	db	047H
	db	03CH
	db	008H
	db	078H
	db	087H
	db	087H
	db	080H
	db	0C6H
	db	01DH
	db	047H
	db	03AH
	db	04DH
	db	03FH
	db	090H
	db	030H
	db	016H
	db	0CDH
	db	0B6H
	db	007H
	db	00EH
	db	017H
	db	0DDH
	db	0CBH
	db	000H
	db	056H
	db	020H
	db	002H
	db	00EH
	db	00FH
	db	0CDH
	db	0FEH
	db	026H
	db	00DH
	db	020H
	db	0FAH
	db	03EH
	db	001H
	db	008H
	db	0F1H
	db	0CBH
	db	047H
	db	028H
	db	005H
	db	0CDH
	db	0FEH

wboot_save:
	ds	2,0

	db	005H
	db	006H
	db	023H

T0B5C:	db	0CDH
	db	02AH

T0B5E:	db	035H
	db	0CDH
	db	04FH
	db	030H
	db	0CDH
	db	056H
	db	030H
	db	0DAH
	db	0B6H
	db	007H
	db	020H
	db	005H
	db	07EH
	db	0F5H
	db	023H
	db	018H
	db	0BAH
	db	0CDH
	db	0B6H
	db	007H

D0B72:	db	0C3H
D0B73:	db	086H
D0B74:	db	02FH
D0B75:	db	04DH
D0B76:	db	061H
D0B77:	db	063H
	db	072H

D0B79:	db	0EFH
D0B7A:	db	07EH
D0B7B:	db	0E6H
D0B7C:	db	03FH
D0B7D:	db	032H

T0B7E:	db	06EH
	db	03FH
	db	006H
	db	055H
	db	0C8H
	db	07EH
	db	0E6H
	db	060H
	db	006H
	db	04DH
	db	0FEH
	db	060H
	db	0C8H
	db	006H
	db	045H
	db	0FEH
	db	040H
	db	0C8H
	db	006H
	db	058H
	db	0FEH
	db	020H
	db	0C8H
	db	006H
	db	020H
	db	0C9H
	db	056H
	db	023H
	db	05EH
	db	0EBH
	db	0C3H
	db	0DDH
	db	027H
	db	03AH
	db	020H
	db	02FH
	db	0A7H
	db	020H
	db	012H
	db	02AH
	db	060H
	db	048H
	db	07EH
	db	03CH
	db	037H
	db	0C8H
	db	0EBH
	db	021H
	db	00BH
	db	000H
	db	019H
	db	022H
	db	060H
	db	048H
	db	0EBH
	db	018H
	db	004H
	db	0CDH
	db	0D6H
	db	030H
	db	0D8H
	db	011H
	db	05CH
	db	03FH
	db	006H
	db	008H
	db	0CDH
	db	0ACH
	db	027H
	db	001H
	db	008H
	db	000H
	db	020H
	db	00AH
	db	009H
	db	03AH
	db	07EH
	db	03FH
	db	0AEH
	db	0CBH
	db	07FH
	db	0C8H
	db	0EDH
	db	042H
	db	0E5H
	db	0EDH
	db	0B0H
	db	07EH
	db	032H
	db	07EH
	db	03FH
	db	0E1H
	db	097H
	db	03CH
	db	0C9H
	db	078H
	db	001H
	db	000H
	db	000H
	db	021H
	db	057H
	db	04CH
	db	008H
	db	0D5H
	db	0C5H
	db	0E5H
	db	072H
	db	023H
	db	073H
	db	011H
	db	00DH
	db	000H
	db	019H
	db	0EBH
	db	021H
	db	023H
	db	000H
	db	019H
	db	07DH
	db	012H
	db	013H
	db	07CH
	db	012H
	db	013H
	db	021H
	db	08CH
	db	039H
	db	001H
	db	021H
	db	000H
	db	0EDH
	db	0B0H
	db	0E1H
	db	0D1H
	db	0D5H
	db	0E5H
	db	001H
	db	00DH
	db	000H
	db	009H
	db	0CDH
	db	09AH
	db	038H
	db	0D1H
	db	0D5H
	db	0CDH
	db	00FH
	db	031H
	db	0C1H
	db	0E1H
	db	0D1H
	db	019H
	db	0C5H
	db	0E3H
	db	0C1H
	db	024H

A0C1A:	LD	A,(DE)
	OR	A
	SCF
	RET	Z

A0C1E:	CP	030H
	RET	C

	CP	03AH
	CCF
	RET	C

	INC	DE
	LD	A,(DE)
	OR	A
	JR	NZ,A0C1E

	RET

A0C2B:	JP	(HL)

A0C2C:	CALL	A0C9B

	LD	HL,0

A0C32:	LD	A,(DE)
	SUB	030H
	RET	C

	CP	0AH
	RET	NC

	INC	DE
	LD	C,L
	LD	B,H

	ADD	HL,HL
	ADD	HL,HL

	ADD	HL,BC
	ADD	HL,HL

	ADD	A,L
	LD	L,A
	JR	A0C32

A0C44:	PUSH	HL
	PUSH	DE
	PUSH	BC

	LD	B,A
	LD	C,000H

A0C4A:	INC	C
	PUSH	BC
	LD	DE,0000AH
	CALL	A0CA6
	POP	BC

	LD	A,E
	ADD	A,030H
	PUSH	AF
	INC	SP
	LD	A,L
	OR	H
	JR	NZ,A0C4A

	LD	A,B
	SUB	C
	JR	C,A0C6A
	JR	Z,A0C6A

	LD	B,A

A0C63:	LD	A,020H
	CALL	prntdig
	DJNZ	A0C63

A0C6A:	DEC	SP
	POP	AF
	CALL	prntdig

	DEC	C
	JR	NZ,A0C6A

	POP	BC
	POP	DE
	POP	HL
	RET

A0C76:	LD	(HL),E
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,A0C76

	RET

A0C7E:	LD	(DE),A
	CALL	A0CE7

	LD	A,(BC)
	INC	DE
	LD	A,(DE)
	OR	A
	RET	NZ

	SCF
	RET

crlf:	CALL	print
	db	cr,lf,0

	RET

print:	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL

	OR	A
	RET	Z

	CALL	prntdig
	JR	print

A0C9B:	LD	A,(DE)
	CP	020H
	JR	Z,A0CA3

	CP	009H
	RET	NZ

A0CA3:	INC	DE
	JR	A0C9B

A0CA6:	LD	A,E
	OR	D
	SCF
	RET	Z

	XOR	A
	EX	DE,HL

A0CAC:	INC	A
	ADD	HL,HL
	JR	NC,A0CAC

	EX	DE,HL
	LD	C,E
	LD	B,D
	LD	DE,00000H

A0CB6:	RR	B
	RR	C
	SCF

	RL	E
	RL	D
	SBC	HL,BC
	JR	NC,A0CC6

	ADD	HL,BC
	DEC	E
	OR	A

A0CC6:	DEC	A
	JR	NZ,A0CB6

	EX	DE,HL
	RET

A0CCB:	PUSH	HL
	CALL	A0CE7
	LD	BC,0C9E1H

prntdig:
	PUSH	HL
	PUSH	DE
	LD	E,A
	CALL	A0CE7

	LD	(BC),A
	POP	DE
	POP	HL
	RET

A0CDC:	PUSH	HL
	CALL	A0CE7

	DEC	BC
	POP	HL
	OR	A
	RET	Z

	OR	0FFH
	RET

A0CE7:	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	PUSH	DE
	PUSH	BC

	LD	C,A
	CALL	bdos

	POP	BC
	POP	DE
	RET

; >> NO EXECUTION PATH TO HERE <<
	db	004H
	db	046H
	db	07AH
	db	0B3H
	db	006H
	db	000H
	db	03EH
	db	00AH
	db	0C4H
	db	0E7H
	db	032H
	db	0EDH
	db	05BH
	db	002H
	db	046H
	db	006H
	db	001H
	db	03EH
	db	00DH
	db	0C3H
	db	0E7H
	db	032H
	db	011H
	db	000H
	db	000H
	db	006H
	db	000H
	db	0DDH
	db	0CBH
	db	000H
	db	046H
	db	0C8H
	db	03AH
	db	06CH
	db	03FH
	db	0FEH
	db	002H
	db	0C0H
	db	0DDH
	db	0CBH
	db	002H
	db	046H
	db	020H
	db	020H
	db	0C5H
	db	0D5H
	db	0CDH
	db	008H
	db	032H
	db	0D1H
	db	0C1H
	db	03EH
	db	00EH
	db	0CDH
	db	070H
	db	032H
	db	0CDH
	db	0E7H
	db	032H
	db	0CDH
	db	08EH
	db	033H
	db	03EH
	db	00FH

T0D34:	db	000H
	db	000H
	db	0CBH
	db	018H
	db	0CBH
	db	019H
	db	037H
	db	0CBH
	db	013H
	db	0CBH
	db	012H
	db	0EDH
	db	042H
	db	030H
	db	003H
	db	009H
	db	01DH
	db	0B7H
	db	03DH
	db	020H
	db	0EDH
	db	0EBH
	db	0C9H
	db	0E5H
	db	0CDH
	db	0E7H
	db	00CH
	db	001H
	db	0E1H
	db	0C9H
	db	0E5H
	db	0D5H
	db	05FH
	db	0CDH
	db	0E7H
	db	00CH
	db	002H
	db	0D1H
	db	0E1H
	db	0C9H
	db	0E5H
	db	0CDH
	db	0E7H
	db	00CH
	db	00BH
	db	0E1H
	db	0B7H
	db	0C8H
	db	0F6H
	db	0FFH
	db	0C9H
	db	0E3H
	db	07EH
	db	023H
	db	0E3H
	db	0D5H
	db	0C5H
	db	04FH
	db	0CDH
	db	005H
	db	000H
	db	0C1H
	db	0D1H
	db	0C9H
	db	004H
	db	046H
	db	07AH
	db	0B3H
	db	006H
	db	000H
	db	03EH
	db	00AH
	db	0C4H
	db	0E7H
	db	032H
	db	0EDH


	END
