/*
 * AM620.H - Alpha Micro 620 Cartridge Tape Driver Definitions
 *
 * 	30 April 84			/PRN
 */

typedef	unsigned char	u_char;

#define NDRIVE	1		/* number of tape drives */

/*
 * AM620 device structure
 */

struct device {
	u_char	tape_out;		/* tape output port		 */
	u_char	i_cmd;			/* interface command port	 */
	u_char	i_stat;			/* interface status port	 */
};

#define	tape_in	i_cmd			/* defines tapein for above union */

#define STRADDR		((struct device *)0xFFFF0C)	/* device address */

/*
 * define AM620 interface commands (device.i_cmd)
 */

#define IC_RESET	0x0FE		/* reset the interface		*/
#define IC_REQ		0x0FD		/* request command		*/
#define IC_ONLINE	0x0FB		/* place device online		*/
#define	IC_WRITE	0x0F7		/* write in progress		*/
#define	IC_READ		0x0EF		/* read in progress		*/
#define IC_ENBEX	0x0DF		/* enable exception logic	*/

/*
 * define AM620 interface status (device.i_stat)
 */

#define	IS_ACK		0x01		/* acknowledge			*/
#define	IS_EXC		0x02		/* exception			*/
#define	IS_RDY		0x04		/* ready			*/
#define	IS_DRC		0x08		/* direction			*/
#define	IS_HSE		0x20		/* data handshake exception	*/

/*
 * define streamer tape drive commands
 */

#define	TC_REWIND	0x021		/* rewind tape			*/
#define	TC_ERASE	0x022		/* erase tape			*/
#define	TC_RETNS	0x024		/* retension tape		*/
#define	TC_WRITE	0x040		/* write tape			*/
#define	TC_WRFMRK	0x060		/* write file mark		*/
#define	TC_READ		0x080		/* read tape			*/
#define	TC_RDFMRK	0x0A0		/* read file mark		*/
#define	TC_RDSTAT	0x0C0		/* read status			*/

/*
 * Define streamer tape drive status bytes
 *
 * The streamer returns 6 bytes of status as defined below:
 *	bytes 0 & 1 = exception status
 *	bytes 2 & 3 = data error counter (byte 2 is MSB)
 *	bytes 4 & 5 = underrun counter (byte 4 is MSB)
 */

/* byte 0 - exception status bits */

#define TS_FMARK	0x0100		/* file mark detected		*/
#define TS_BIENL	0x0200		/* BIE not located		*/
#define TS_HERR		0x0400		/* unrecoverable data error	*/
#define TS_EOT		0x0800		/* end of tape 			*/
#define TS_WPROT	0x1000		/* write protected		*/
#define TS_OFFLIN	0x2000		/* device not on-line		*/
#define TS_NOCART	0x4000		/* cartridge not in place	*/
#define TS_BYTE0	0x8000		/* byte 0 has bits set		*/

/* byte 1  - exception status bits */

#define TS_RESET	0x01		/* reset occurred		*/
#define TS_BOT		0x08		/* beginning of tape		*/
#define TS_NODATA	0x20		/* no data detected		*/
#define TS_ILLCMD	0x40		/* illegal command		*/
#define TS_BYTE1	0x80		/* byte 1 has bits set		*/

