/*
 * AMOS.H - This file describes some amos  structures
 *
 *	This file is mainly used by the standalone utilities to
 *	access the bad block table from amos.
 *
 *	1 May 84		/PRN
 */

/* disk block size */

#define	AMOS_BS		512		/* 512 bytes per sector 	*/


/*
 * Master File Directory definitions (block 1 of the disk)
 */

/* single mfd entry format */

struct	mfd_entry	{
	unsigned short	mf_ppn;		/* project, programmer number	*/
	unsigned short	mf_ufd;		/* block number of ufd		*/
	unsigned long	mf_passwd;	/* rad50 pass word (6 chars)	*/
};

/* link to next MFD block format */

struct	mfd_link	{
	unsigned short	mf_zer;		/* filler - always zero		*/
	unsigned short	mf_next;	/* link to next block (if one)	*/
	unsigned short	mf_prev;	/* link to previous block	*/
	unsigned short	mf_flags;	/* some flags			*/
};

/* format of the MFD block */

struct	mfd_block	{
	struct mfd_entry mfd[63];	/* 63 ppn entries per mfd blk	*/
	struct mfd_link  mfdlnk;	/* link to the next mfd block	*/
};


/*
 * User File Directory format
 */

/* single UFD entry format */

struct	ufd_entry	{
	unsigned long	uf_fname;	/* rad50 file name		*/
	unsigned short	uf_fnext;	/* fad50 file name extension	*/
	unsigned short	uf_nblks;	/* number of blocks in the file */
	unsigned short	uf_bytes;	/* number of bytes in last blk	*/
	unsigned short	uf_sblk;	/* starting blk number of file	*/
};

/* format of a UFD block */

struct	ufd_block	{
	unsigned short	ufd_link;	/* link to next ufd blk (if one)*/
	struct ufd_entry ufd[42];	/* 42 file entries per ufd blk	*/
};

/*
 *	AMOS bad block table format
 */

struct	amos_bb		{
	unsigned short	bb_link;	/* link to next sector in file	*/
	unsigned short	bb_flg;		/* bad block table flags	*/
#		define	BB_ALC	0100000		/* allocated		*/
#		define	BB_LBB	010		/* logical/split table	*/
#		define	BB_LNG	04		/* long word entries	*/
#		define	BB_HD	02		/* head track format	*/
#		define	BB_BLK	01		/* alt blk format	*/
	char		bb_sn[10];	/* ascii serial number		*/
	unsigned long	bb_hash;	/* hash total			*/
	unsigned long	bb_blk[1];	/* start of block numbers	*/
};

