/*
 * XEBEC Disk Controller Definitions for the AM1000-E
 *
 * 1 March 84	Alpha Microsystems Inc.
 */

/* xebec device structure */

struct	xebdev	{
	u_char	xeb_cmd;	/* command port			*/
	u_char	xeb_data;	/* data port			*/
};

/* SASI port */

#define	XEBADDR	0x0ffffffc8 /* xebec port address	*/

/* controller status bits (input) */

#define	CSI_BMSG	0x01		/* message bit			*/
#define	CSI_BBUSY	0x02		/* buss busy bit		*/
#define	CSI_BREQ	0x04		/* data request bit		*/
#define	CSI_DIR		0x08		/* direction			*/
					/*   =0 - output to controller	*/
					/*   =1 - input from controller	*/
#define	CSI_BCB		0x10		/* buss used for control byte	*/
#define	CSI_CMD		0x18		/* command to controller ready	*/

/* controller status bits (output) */

#define	CSO_UNIT	0x01		/* this controller select bit	*/
#define	CSO_SEL		0x10		/* select contoller bit		*/
#define	CSO_RESET	0x40		/* reset controller bit		*/
#define	CSO_INTEN	0x80		/* enable interrupts		*/

/* command packet  format */

struct	cmdpak	{
		u_char	cp_opcode;	/* command opcode		*/
		u_char	cp_lun;		/* logical unit and hi blk # 	*/
		u_char	cp_blk1;	/* logical block number mid	*/
		u_char	cp_blk0;	/* logical block number low	*/
		u_char	cp_nrblk;	/* nuber of blocks		*/
		u_char	cp_cbyte;	/* control byte 		*/
};

/* command opcodes */

#define	CMD_READY	0x00		/* test drive ready		*/
#define	CMD_RECAL	0x01		/* recalibrate drive		*/
#define	CMD_STAT	0x03		/* request sense status		*/
#define	CMD_FDRV	0x04		/* format drive			*/
#define	CMD_CFMT	0x05		/* check track format 		*/
#define	CMD_FTRK	0x06		/* format track			*/
#define	CMD_BTRK	0x07		/* format bad  track		*/
#define	CMD_READ	0x08		/* read the disk		*/
#define	CMD_WRITE	0x0A		/* write the disk		*/
#define	CMD_SEEK	0x0B		/* seek to specified track	*/
#define	CMD_INIT	0x0C		/* initialize drive parameters	*/
#define	CMD_RECC	0x0D		/* get ecc burst error length	*/
#define	CMD_DRAM	0x70		/* ram diagnostic		*/
#define	CMD_DDRV	0x73		/* drive diagnostic		*/
#define	CMD_DCTRL	0x74		/* controller diagnostic	*/
#define	CMD_LREAD	0x75		/* long read			*/
#define	CMD_LWRIT	0x76		/* long write			*/

/* control byte definition */

#define	CB_FSEEK	0x06		/* fast seek option		*/
#define	CB_NTRY		0x80		/* disable controller retries	*/

/* command status byte masks */

#define	SB_ERR		0x02		/* error during command		*/
#define	SB_DRV		0x20		/* unit number err occurred on	*/

/* sense buffer format */

struct	sense_buf	{
		u_char	sb_err;		/* error code number		*/
		u_char	sb_lun;		/* logical unit and hi blk # 	*/
		u_char	sb_blk1;	/* logical block number mid	*/
		u_char	sb_blk0;	/* logical block number low	*/
};

/* drive and controller errors */

/* type 0 - drive errors */

#define	ER_NONE		0		/* no error			*/
#define	ER_NOINDX	1		/* no index signal		*/
#define	ER_NOSEEK	2		/* seek not completed		*/
#define	ER_WFAULT	3		/* write fault			*/
#define	ER_NRDY		4		/* drive not ready		*/
#define	ER_NOSEL	5		/* drive not selected		*/
#define	ER_NTRK00	6		/* no track zero		*/

/* type 1 - data errors */

#define	ER_BADID	16		/* ECC error in ID field	*/
#define	ER_ECC		17		/* uncorrectable data error	*/
#define	ER_NIDADR	18		/* ID address mark not found	*/
#define	ER_NDADR	19		/* data address mark not found	*/
#define	ER_NOREC	20		/* record not found		*/
#define	ER_SEEK		21		/* seek error			*/
#define	ER_DMA		22		/* DMA timeout error		*/
#define	ER_WPRT		23		/* write protected		*/
#define	ER_CDATA	24		/* correctable data error	*/
#define	ER_BADBLK	25		/* bad block found		*/
#define	ER_FMT		26		/* format error			*/

/* type 2 - command errors */

#define	ER_INVLD	32		/* invalid command		*/
#define	ER_ADDR		33		/* illegal address		*/

/* type 3  - diagnostic errors */

#define	ER_RAM		48		/*  ram error			*/
#define	ER_PMC		49		/* program memory chksum err	*/
#define	ER_ECCP		50		/* ECC polynomial error		*/


