/*
 * Core map allocation structure.
 * One allocated per user in the U dot area.
 * MAXMMU*32 entries exist for each process.
 * These structures point to dp strucures
 * for those memory segments that are currently
 * mapped in.
 */
struct cmap {
	char	c_type;		/* type of region */
	struct dp *c_dp;	/* pointer to active descriptor pointer */
	click_t	c_caddr;	/* base address of core click */
	mem_t	c_vaddr;	/* base virtual address for this segment */
	mem_t	c_size;		/* size in clicks */
};
