/*
 * AM300.H - Include file to define am300 board
 *
 * Edit History:
 *
 *[100]	12 December 1883
 *	Initial release.				/PRN
 *
 */

/*
 * AM-300 board definitions
 */

typedef	unsigned char	u_char;


#define	NRPORT		6		/* number of ports per board */

struct am300dev	{
	u_char	ucr1;		/* USART control register 1 */
	u_char	ucr2;		/* USART control register 2 */
	u_char	usr;		/* USART status register */
	char	udata;		/* USART xmt/rcv data register */
	u_char	cmux;		/* AM-300 control mux register */
#define	M_PMSK	0x07			/* port selection mask */
#define	M_BRS	0x08			/* buad rate selection */
#define	M_INTE	0x10			/* interrupt enable bit */
#define	M_INTP	0x20			/* interrupt process bit */
#define	RCV_INT	0x04			/* receive interrupt */
};

/*
 * ASTRO status register bit definitions
 */

#define	SR_XMT	0x01	/* xmtr holding regsiter empty */
#define SR_RCV	0x02	/* data received */
#define	SR_OVR	0x04	/* data overrun error */
#define	SR_DLE	0x08	/* DLE character detected */
#define	SR_PAR	0x08	/* parity error */
#define	SR_FRM	0x10	/* framing error */
#define	SR_SYN	0x10	/* SYN character detected */
#define	SR_CAR	0x20	/* carrier detect */
#define	SR_DSR	0x40	/* data set ready */
#define	SR_DSC	0x80	/* data set change */

/*
 * ASTRO control register 1 bit definitions 
 */

#define	C1_DTR	0x01	/* data set ready */
#define	C1_RTS	0x02	/* request to send */
#define	C1_RCV	0x04	/* receiver enable */
#define	C1_PAR	0x08	/* parity enable */
#define	C1_ECH	0x10	/* set echo mode */
#define	C1_SDLE	0x10	/* enable DLE stripping */
#define	C1_SMSC	0x10	/* SYNC misc output control */
#define	C1_1SB	0x20	/* one stop bit */
#define	C1_AMSC	0x20	/* ASYNC misc output control */
#define	C1_SXP	0x20	/* enable sync transmit parity */
#define	C1_FDLE	0x20	/* sync mode force DLE char */
#define	C1_BRK	0x40	/* async break mode */
#define	C1_TRN	0x40	/* sync enable transparent mode */
#define	C1_NRM	0x80	/* normal mode */

/*
 * ASTRO control register 2 bit definitions
 */

#define	C2_1X	0x00	/* 1X clock select */
#define	C2_C1	0x01	/* clock select 1 */
#define	C2_C2	0x02	/* clock select 2 */
#define	C2_C3	0x03	/* clock select 3 */
#define	C2_C4	0x04	/* clock slecet 4 */
#define	C2_C4D2	0x05	/* clock select 4 divided by 2 */
#define	C2_C4D4	0x06	/* clock select 4 divided by 4 */
#define	C2_C4D8	0x07	/* clock select 4 didvied by 8 */
#define	C2_CSEL	0x08	/* select clock from bits 0-2 */
#define	C2_SSYN	0x08	/* enable sync stripping */
#define	C2_PODD	0x10	/* odd parity */
#define	C2_SYNC	0x20	/* enable sync mode */
#define	C2_8BC	0x00	/* 8 bit chars */
#define	C2_7BC	0x40	/* 7 bit chars */
#define	C2_6BC	0x80	/* 6 bit chars */
#define	C2_5BC	0xC0	/* 5 bit chars */

/*
 * BAUD rate values
 */

#define BAUD50		0x0
#define BAUD75		0x1
#define BAUD110		0x2
#define BAUD134		0x3
#define BAUD150		0x4
#define BAUD200		0x5
#define BAUD300		0x6
#define BAUD600		0x7
#define BAUD1200	0x8
#define BAUD1800	0x9
#define BAUD2400	0xA
#define BAUD3600	0xB
#define BAUD4800	0xC
#define BAUD7200	0xD
#define BAUD9600	0xE
#define BAUD19200	0xF

