/*
 * Include file for AM-415 Disk Controller
 *
 * Alpha Microsystems, Irvine CA	5 March 84
 */

/* controller parameters */

#define	NDRIVE		4		/* max number of physical drvs	*/
#define	NRETRY		8		/* number of retries		*/

/* structure of AM-415 board */

struct device {
	unsigned char	am_csr;		/* command/status register */
	unsigned char	am_data;	/* data (and disk fault code) reg. */
};

#define	AMADDR	((struct device *)0xFFFFD0)	/* device register address */

/* status codes */

#define NOTRDY	0x05	/* disk not ready */
#define WRPROT	0x0B	/* disk write protected */
#define DFAULT	0x0F	/* disk fault */
#define CMDBIT	0x80	/* command register status bit (for handshaking) */

/* Fault bits (from data register on disk fault) */

#define DF_FL	0x01	/* fault: drive fault */
#define DF_SE	0x02	/* seek error: invalid cylinder number */
#define DF_OC	0x04	/* on cylinder: drive did not arrive on cyl. in time */
#define DF_UR	0x08	/* unit ready: (always cleared) */
#define DF_AM	0x10	/* address mark: (not used, always cleared) */
#define DF_WP	0x20	/* write protect: write protected (always cleared) */
#define DF_CR	0x40	/* ecc: ecc error occured */
#define DF_DN	0x80	/* done: dma transfer status (always cleared) */

/*
 * interrupt enable command (for both disk and non-disk commands)
 * Do not use IENABLE by itself, only when doing a command !!
 */

#define IENABLE	0x80	/* enable interrupts */

/* non-disk i/o commands */

#define DMARBRD 0x02	/* read dma buffer at base */
#define DMARBWR 0x06	/* write dma buffer at base */
#define DMADBRD 0x12	/* read dma buffer at data offset */
#define DMADBWR 0x16	/* write dma buffer at data offset */
#define CLRINTR	0x40	/* clear interrupt (don't enable interrupts!) */

/* disk i/o commands */

#define CRECAL	0x03	/* reset disk logic and seek to track 0 */
#define CREAD	0x15	/* read data */
#define CWRITE	0x19	/* write data */
#define CWSC	0x0B	/* Write Status Check (test if disk write protected) */
#define CSEEK	0x11	/* seek (Read Status Check) */


