/*
 *
 * AM-415 Disk Drive Specifications
 *
 * Alpha Microsystems, Irvine CA	5 March 84
 *
 * Edit History:
 *
 *[100]	14 Febuary 1984
 *	Initial release.				/PRN
 */

/*
 * drive spec table
 */

struct	am_dspec {
		int	am_type;	/* drive type 			*/
		int	am_nheads;	/* number of heads 		*/
		int	am_ncyl;	/* number of cylinders 		*/
		int	am_nsec;	/* number of sectors 		*/
		int	am_nbpcyl;	/* number of blocks per cyl 	*/
		long	am_maxblk;	/* number of block on disk 	*/
		long	am_bbloc;	/* blk number of alt sectors	*/
		int	am_maxbb;	/* number of bad blocks 	*/
		long	am_bbsiz;	/* size of bad block table 	*/
};


/*
 * Fujitsu drive paramters
 */

#define	DSSIZE		550		/* true drive sector size	*/
					/* including ecc		*/

/*
 * 70MB Fujitsu drive specs
 */

#define	F70MB		1		/* drive type			*/
#define	F70NHEAD	7		/* number of heads		*/
#define	F70NCYL		589		/* number of cylinders		*/
#define	F70NSEC		36		/* number of sectors		*/
#define	F70NBPCYL	252		/* number of blocks per cyl	*/
#define	F70MAXBLK	148428		/* total number of blocks	*/
#define	F70BBLOC	72		/* blk # of alt sectors		*/
#define	F70MAXBB	1008		/* total number of bad blocks	*/
#define	F70ROOT		"am(0,9108)"	/* block number of root fs 	*/

/* bad block table definition */

struct	f70_map {
		struct	a_map	_map[F70MAXBB - 1]; /* table map	*/
};

struct	f70_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	f70_map	bb_map;		/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct f70_map)) % BSIZE)];
};

#define	F70BBSIZ	sizeof(struct f70_altblk)


/*
 * 160MB Fujitsu drive specs
 */

#define	F160MB		2		/* drive type			*/
#define	F160NHEAD	10		/* number of heads		*/
#define	F160NCYL	823		/* number of cylinders		*/
#define	F160NSEC	36		/* number of sectors		*/
#define	F160NBPCYL	360		/* number of blocks per cyl	*/
#define	F160MAXBLK	296280		/* total number of blocks	*/
#define	F160BBLOC	72		/* blk # of alt sectors		*/
#define	F160MAXBB	2160		/* total number of bad blocks	*/
#define	F160ROOT	"am(0,9108)"	/* block number of root fs 	*/

/* bad block table definition */

struct	f160_map {
		struct	a_map	_map[F160MAXBB - 1]; /* table map	*/
};

struct	f160_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	f160_map bb_map;	/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct f160_map)) % BSIZE)];
};

#define	F160BBSIZ	sizeof(struct f160_altblk)

/*
 * 400MB Fujitsu drive specs
 */

#define	F400MB		3		/* drive type			*/
#define	F400NHEAD	20		/* number of heads		*/
#define	F400NCYL	842		/* number of cylinders		*/
#define	F400NSEC	50		/* number of sectors		*/
#define	F400NBPCYL	1000		/* number of blocks per cyl	*/
#define	F400MAXBLK	842000		/* total number of blocks	*/
#define	F400BBLOC	100		/* blk # of alt sectors		*/
#define	F400MAXBB	3000		/* total number of bad blocks	*/
#define	F400ROOT	"am(0,9108)"	/* block number of root fs 	*/

/* bad block table definition */

struct	f400_map {
		struct	a_map	_map[F400MAXBB - 1]; /* table map	*/
};

struct	f400_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	f400_map bb_map;	/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct f400_map)) % BSIZE)];
};

#define	F400BBSIZ	sizeof(struct f400_altblk)


