/*
 * AM607.H Include file mag tape  controller
 *
 *	31 April 84		/PRN
 *
 */


#define NDRIVE	8		/* number of tape drives */
#define NRETRY	8		/* maximum number of retries */

typedef unsigned char	u_char;

struct device {
	u_char	mt_tsec;	/* transport status, external control reg. */
	u_char	mt_fsfc;	/* formatter status, formatter command reg. */
	char	mt_null1;	/* not used */
	u_char	mt_ic;		/* internal control reg. */
	u_char	mt_dmal;	/* dma low address byte */
	u_char	mt_dmah;	/* dma high address byte */
	u_char	mt_dmae;	/* dma extended byte (dma is 24 bit address) */
	char	mt_null2;	/* not used */
};

#define MTADDR		((struct device *)0xFFFFA0)	/* device address */

/* external control register commands */

#define EC_RDTH1	0x08	/* high threshold for read after write op. */
#define EC_RDTH2	0x10	/* extra low threshold for tape electronics */
#define EC_LOWDEN	0x20	/* low density select */
#define EC_LDONLINE	0x40	/* load/online: option on various formatters */

/* transport status register bits */

#define TS_7TRACK	0x01	/* 7 track mode */
#define TS_NRZI		0x02	/* NRZI mode */
#define TS_EOT		0x04	/* end of tape during previous command */
#define TS_LOADPT	0x08	/* load point reached */
#define TS_FILEPROT	0x10	/* file protected */
#define TS_REWIND	0x20	/* transport is rewinding */
#define TS_ONLINE	0x40	/* transport is on line */
#define TS_READY	0x80	/* transport ready */

/* formatter command register bits */

#define FC_REVERSE	0x01	/* reverse motion */
#define FC_WRITE	0x02	/* write mode */
#define FC_WRFMARK	0x04	/* write file mark if in write mode */
#define FC_EDIT		0x08	/* edit mode */
#define FC_ERASE	0x10	/* erase mode */
#define FC_REWIND	0x20	/* setting then resetting causes rewind */
#define FC_OFFLINE	0x40	/* setting then resetting causes off line */
#define FC_GO		0x80	/* setting then resetting starts command */

/* formatter status register bits */

#define FS_DONE		0x01	/* pre-programmed byte count satisfied */
#define FS_ERROR	0x02	/* hard read error (ignore if FS_FMARK set) */
#define FS_FMARK	0x04	/* tape file mark detected */
#define FS_PETAPE	0x08	/* phase encoded tape present */
#define FS_READY	0x10	/* interface ready for more read/write */
#define FS_LOSTDATA	0x20	/* data lost during read/write */
#define FS_INTR		0x40	/* interrupt (valid only after FC_GO issued) */
#define FS_BUSY		0x80	/* formatter busy processing command */

/* internal control register commands */

#define IC_LENABLE	0x08	/* enable interface and formatter logic */
#define IC_IENABLE	0x10	/* enable interrupts */

/*
 * The following are DMA register instructions and are part of the internal
 * control register commands.  Before issuing any read/write command, the
 * DMA registers must be enabled (IC_DMAENABLE).  Each intruction is shifted
 * 5 bits left.
 */

#define IC_WRCNTL	0x00	/* write control register */
#define IC_RDCNTL	0x20	/* read control register */
#define IC_RDWORD	0x40	/* read word counter */
#define IC_RDADDR	0x60	/* read address counter */
#define IC_INIT		0x80	/* reinitialize counters */
#define IC_LDADDR	0xA0	/* load address counter */
#define IC_LDWORD	0xC0	/* load word counter */
#define IC_DMAENABLE	0xE0	/* enable registers */

