/*
 * Alpha Micro Bad block remapping structure
 */

#define ALTMAGIC	0xDBDF	/* bad block information is valid flag */


/*
 * define some disk types
 */

#define	UNKN		0		/* drive type not checked yet */
#define	NODSK		-1		/* no drive for this unit */


/*
 * structure for alternate block mapping
 */

struct a_map {
	long a_altbk;			/* bad block */
	long a_index;			/* relative bad block index */
};


/*
 * disk header block format for alternate block mapping
 * note that the first disk block on track 0 is reserved, so we skip it
 */

struct altblk {
	unsigned long a_chksum;		/* altblk chksum */
	long a_magic;			/* verification code (ALTMAGIC) */
	long a_dtype;			/* disk type (see defines above) */
	long a_nicbad;			/* max number of bad blocks */
	long a_count;			/* bad block count */
	long a_maxalt;			/* max alt block used so far */
	struct a_map a_map[1];		/* mapping */
};

