/*
 * CN100.H - Include file  for AM100L  console  driver
 *
 *    31 April 84			/PRN
 */

/* console UART device structure (MC6850) */

struct cndevice {
	char	cn_stat;	/*  stat/control port */
	char	dummy1;
	char	cn_data;	/*  data port */
	char	dummy2;
};


#define BAUD50		0x0
#define BAUD75		0x100
#define BAUD110		0x200
#define BAUD134		0x300
#define BAUD150		0x400
#define BAUD300		0x500
#define BAUD600		0x600
#define BAUD1200	0x700
#define BAUD1800	0x800
#define BAUD2000	0x900
#define BAUD2400	0xA00
#define BAUD3600	0xB00
#define BAUD4800	0xC00
#define BAUD7200	0xD00
#define BAUD9600	0xE00
#define BAUD19200	0xF00

/* Command register bits */

#define CLKX16	0x01	/* 16x clock */
#define RESET	0x03	/* Reset chip */
#define ENMODE	0x15	/* Set chip modes (8 bits, 1 stop, div by 16 clock) */
#define DTR	0x0	/* Turn on DTR (RTS) */
#define NODTR	0x40	/* Turn off transmitter interupts and DTR (RTS) */
#define XIENABLE 0x20	/* Transmit interupt enable */
#define RIENABLE 0x80	/* Receive interupt enable */
#define XRIENABLE 0xA0	/* Transmit and Receive interupt enable */
#define BITS8	0x10	/* 8 bits */
#define PODD	0x4	/* odd parity */
#define STOP1	0x8	/* one stop bit */

/* Status register bits */

#define RXRDY	0x01	/* Receiver is ready */
#define TXRDY	0x02	/* Transmitter is ready */
#define NODCD	0x04	/* DCD lost, no carrier present */
#define CLRTX	0x08	/* Clear to send */
#define FR_ERR	0x10	/* Framing error */
#define OV_ERR	0x20	/* Overrun error on receiver */
#define PE_ERR	0x40	/* Parity error */
#define CN_ERR	0x40	/* Framing, Overrun and Parity error */
#define IRQ	0x80	/* Interrupt request, cleared on R/W of data reg. */

