/*
 * Bad block remapping structure
 */

#define ALTMAGIC	0xDBDF	/* bad block information is valid flag */

/* disk constants for fujitsu (change this info according to disk type) */

#define NSECT	17			/* last block in altblk map */

/*
 * structure for alternate block mapping
 */
struct a_map {
	long a_altbk;			/* bad block */
	long a_index;			/* relative bad block index */
};

/*
 * disk header block format for alternate block mapping
 * note that the first disk block on track 0 is reserved, so we skip it
 */
struct altblk {
		/* fill to make structure (NSECT - 1) * BSIZE bytes long */
	char a_fill[((NSECT-1)*BSIZE)-sizeof(struct a_map)-(6*sizeof(long))];
	struct a_map a_map[1];		/* mapping */
	long a_magic;			/* verification code (ALTMAGIC) */
	long a_count;			/* bad block count */
	long a_nicbad;			/* max number of bad blocks */
	long a_maxalt;			/* max alt block used so far */
	unsigned long a_chksum;		/* altblk chksum */
	long a_dummy;
};

/* maximum number of bad blocks */

#define NICALT	(((sizeof(struct altblk) - (6 * sizeof(long))) /\
		sizeof(struct a_map)) - 1)
