/*
 *
 * XEBEC Disk Drive Specifications
 *
 * Alpha Microsystems, Irvine CA
 *
 * Edit History:
 *
 *[100]	20 Febuary 1984
 *	Initial release.				/PRN
 */

/*
 * drive spec table
 */

struct	xeb_dspec {
		int	xeb_type;	/* drive type 			*/
		int	xeb_nheads;	/* number of heads 		*/
		int	xeb_ncyl;	/* number of cylinders 		*/
		int	xeb_rdwrt;	/* reduced write cylinder	*/
		int	xeb_wrtpcmp;	/* write precomp cylinder	*/
		int	xeb_fmt;	/* format type flag		*/
		long	xeb_maxblk;	/* number of block on disk 	*/
		long	xeb_bbloc;	/* blk number of alt sectors	*/
		int	xeb_mxbb;	/* number of bad blocks 	*/
		long	xeb_bbsiz;	/* size of bad block table 	*/
};


/*
 * 30MB CDC drive specs
 */

#define	CDC30MB		4		/* drive type			*/
#define	C30NHEAD	5		/* number of heads		*/
#define	C30NCYL		697		/* number of cylinders		*/
#define	C30RDWRT	697		/* reduced write cylider	*/
#define	C30WRTPCMP	128		/* write precomp cylinder	*/
#define	C30FMT		0		/* format type flags		*/
#define	C30MAXBLK	59245		/* total number of blocks	*/
#define	C30BBLOC	51		/* blk # of alt sectors		*/
#define	C30MAXBB	170		/* total number of bad blocks	*/
#define	C30ROOT		"xeb(0,4233)"	/* block number of root fs 	*/

/* bad block table definition */

struct	c30_map {
		struct	a_map	_map[C30MAXBB - 1]; /* table map	*/
};

struct	c30_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	c30_map	bb_map;		/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct c30_map)) % BSIZE)];
};

#define	C30BBSIZ	sizeof(struct c30_altblk)


/*
 * 30MB CMI drive specs
 */

#define	CMI30MB		5		/* drive type			*/
#define	CM30NHEAD	6		/* number of heads		*/
#define	CM30NCYL	640		/* number of cylinders		*/
#define	CM30RDWRT	639		/* reduced write cylider	*/
#define	CM30WRTPCMP	256		/* write precomp cylinder	*/
#define	CM30FMT		0x10		/* format type flags		*/
#define	CM30MAXBLK	65280		/* total number of blocks	*/
#define	CM30BBLOC	51		/* blk # of alt sectors		*/
#define	CM30MAXBB	204		/* total number of bad blocks	*/
#define	CM30ROOT	"xeb(0,4267)"	/* block number of root fs 	*/

/* bad block table definition */

struct	cm30_map {
		struct	a_map	_map[CM30MAXBB - 1]; /* table map	*/
};

struct	cm30_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	cm30_map bb_map;	/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct cm30_map)) % BSIZE)];
};

#define	CM30BBSIZ	sizeof(struct cm30_altblk)


/*
 * 30MB Quantum drive specs
 */

#define	QUANTUM30MB	6		/* drive type			*/
#define	Q30NHEAD	8		/* number of heads		*/
#define	Q30NCYL		512		/* number of cylinders		*/
#define	Q30RDWRT	512		/* reduced write cylider	*/
#define	Q30WRTPCMP	256		/* write precomp cylinder	*/
#define	Q30FMT		0x10		/* format type flags		*/
#define	Q30MAXBLK	69632		/* total number of blocks	*/
#define	Q30BBLOC	51		/* blk # of alt sectors		*/
#define	Q30MAXBB	272		/* total number of bad blocks	*/
#define	Q30ROOT		"xeb(0,4335)"	/* block number of root fs 	*/

/* bad block table definition */

struct	q30_map {
		struct	a_map	_map[Q30MAXBB - 1]; /* table map	*/
};

struct	q30_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	q30_map	bb_map;		/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct q30_map)) % BSIZE)];
};

#define	Q30BBSIZ	sizeof(struct q30_altblk)


/*
 * 30MB Atasi drive specs
 */

#define	ATASI30MB	7		/* drive type			*/
#define	A30NHEAD	7		/* number of heads		*/
#define	A30NCYL		645		/* number of cylinders		*/
#define	A30RDWRT	645		/* reduced write cylider	*/
#define	A30WRTPCMP	320		/* write precomp cylinder	*/
#define	A30FMT		0		/* format type flags		*/
#define	A30MAXBLK	76755		/* total number of blocks	*/
#define	A30BBLOC	51		/* blk # of alt sectors		*/
#define	A30MAXBB	238		/* total number of bad blocks	*/
#define	A30ROOT		"xeb(0,4301)"	/* block number of root fs 	*/

/* bad block table definition */

struct	a30_map {
		struct	a_map	_map[A30MAXBB - 1]; /* table map	*/
};

struct	a30_altblk	{
		struct	altblk	bb_hdr;		/* bad block table hdr 	*/
		struct	a30_map	bb_map;		/* table map		*/
		/* the below filler pads it out to a block size		*/
		char	fill[BSIZE - ((sizeof(struct altblk) +
				sizeof(struct a30_map)) % BSIZE)];
};

#define	A30BBSIZ	sizeof(struct a30_altblk)


