/*
 * 68451 pseudo page table entry.
 * The page table is actually one bit per page
 * and are manipulated by the page table routines.
 * The arrays are per user and consist of
 * for the valid bit and the zero fill on demand bit.
 */

#define PTRESOL	4096		/* page table resolution (bytes) */
#define BPC	8		/* bits per character */
#define LBPC	3		/* log 2 of bits per character */
#define NUMPT	(btoc(UEND-USTART)/btoc(PTRESOL)/BPC)

/*
 * macros to set, clear, and test single bits in linear char
 * arrays of bits describing page valid and zero fill on
 * demand pages.
 */
#define bitset(n,v)	(((char *)v)[(n)>>LBPC] |= 1 << ((n) & (BPC-1)))
#define bittest(n,v)	(((char *)v)[(n)>>LBPC] & (1 << ((n) & (BPC-1))))
#define bitclear(n,v)	(((char *)v)[(n)>>LBPC] &= ~(1 << ((n) & (BPC-1))))
