/*    CDC 114 SYSTEM EXERCISER
 
      File - patgen.c
 
This function creates 3 files (display.s, print1.s, and print2.s)
  containing a test pattern of 95 ASCII characters.
 
  Input parameters are
    1 Printer type
       1 - CDC 725-10 Matrix Printer        (150 cps "SCAMP")
       2 - CDC 727-40 Letter Quality Printer (40 cps "C.ITOH")
       3 - CDC 727-55 Letter Quality Printer (55 cps "C.ITOH")
       4 - EPSON MX80 Matrix Printer         (80 cps)
       n - No printer selected
    2 Paper width
       n - Narrow (80-column)
       w - Wide  (132-column)
  This function returns a 1 char. error code: 0= no errors, 1="file open"
  error.
  the following is the 1st 2 lines and 2 middle lines in the file:
 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmno
!"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnop
    
opqrstuvwxyz{|}~ !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_
pqrstuvwxyz{|}~ !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`
*/
 
#include<stdio.h>
main(argc, argv)
int argc;
char *argv[];
{
int ptype;
char pwidth;
int nchars=80;
int nline1=24;
int nline2=12;
int value=32;      /* first ASCII char. "space" */
int i;
int p=0;
int linect=0;
int np = 0x0c;      /* new page function code */
FILE *fp1,*fopen();
FILE *fp2,*fopen();
FILE *fp3,*fopen();
ptype = atoi(argv[1]);
++argv;
pwidth = (*++argv)[0];

     if((fp1=fopen("display.s","w")) ==NULL) return(1);
     while(linect<96)     /* start of loop to put out 96 lines of char.*/
     {
          for(i=0;i<80;i++)     /* start of loop to put out an 80 char. line */
          {
               if(value==127)          /* ck for last ASCII char. "~"*/
                    value=32;       /* and reset to first char. */
               putc(value,fp1);
               ++value;
          }
          ++linect;
          value=32+linect;     /* start next line with new char. */
     }
putc('\n', fp1);    /*  add 'newline' to end of file  */
fclose(fp1);
 
if(ptype == 1)  nline1 = nline2 = 96;
if(ptype == 2)  nline1 = nline2 = 24;
if(ptype == 3)  { nline1 = 96; nline2 = 24;
   if(pwidth == 'w')  nline2 = 12;  }
if(ptype == 4)  { nline1 = 96; nline2 = 48; }
 
if (pwidth == 'n')  nchars =  80;
              else  nchars = 132;
 
     if((fp2=fopen("print1.s","w")) ==NULL) return(1);
putc(np, fp2);
putc('\n', fp2);
linect = 0;
value = 0x20;
while(linect < nline1)
  { for(i=0; i<nchars; i++)
    { if(value == 0x7f) value = 0x20;
      putc(value, fp2);
      ++value;
    }
    putc('\n', fp2);
    ++linect;
    value = linect + 0x20;
  }
fclose(fp2);
 
     if((fp3=fopen("print2.s","w")) == NULL) return(1);
putc(np, fp3);
putc('\n', fp3);
linect = 0;
value  = 0x20;
 
while(linect < nline2)
  { for(i=0; i<nchars; i++)
     { if(value == 0x7f) value = 0x20;
         putc(value, fp3);
         ++value;
     }
     putc('\n', fp3);
     ++linect;
     value = linect + 0x20;
  }
fclose(fp3);
 
return(p);     /* p=0=no errors; p=1= "file" open error  */
}
