:    CDC 114 SYSTEM EXERCISER
:
:    Copyright 1982 Control Data Corporation
:
: File - sysx.sh 
: 
: This is the initial control shell for the CDC 114 System Exerciser.
: It engages the operator in a dialogue to determine the system
: configuration for subsequent testing.
: . . . . . . . . . . . . . . . . . . . .
:
: Maximum number of terminals on system.
Maxterm=8
:
: Maximum number of test passes in each stage.
Maxpass=999
: . . . . . . . . . . . . . . . . . . . .
:
: Display introduction.
:
:
echo CDC114 SYSTEM EXERCISER  Version 1.1
echo
echo The System Exerciser runs in two stages.
echo In Stage I,  tests are run sequentially.
echo In Stage II, tests are run concurrently.
echo
echo System Configuration Information.
: . . . . . . . . . . . . . . . . . . . . . 
:
: Ask operator if system has expansion hard disk drive.
:
entry=bad
until test $entry = good
  do
    echo
    echo -n Does your system include the expansion hard disk drive? [y or n].
    read hdexp
    if test $hdexp
       then if test $hdexp = y -o $hdexp = n
               then entry=good
            fi
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
:
: Get and validate number of terminals on system.
: Hold the value in nt.
:
echo
echo How many terminals, including System Console,
echo on your system ?
entry=bad
until test $entry = good
  do
    echo -n Enter a number from 1 to $Maxterm.
    read nt
    if test $nt
       then if test $nt -ge 1
               then if test $nt -le $Maxterm
                       then entry=good
                    fi
            fi
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
:
: Get Serial I/O Loopback sending and receiving port numbers,
: if any.
: Hold sending port number in srcp,
: and receiving p.number in dstport.
: Condition the ports for loopback test.
:
echo
echo The Serial I/O loopback test requires the installation
echo of a jumper cable between two serial port connectors.
echo If you want this test to be run, install the jumper cable
echo between two ports when requested to do so.
entry=bad
until test $entry = good
  do
    echo Enter the first port number [2 - $Maxterm].
    echo -n If not, enter n.
    read srcp
    if test $srcp
       then if test $srcp = n
               then entry=good
               elif test $srcp -ge 2
                    then if test $srcp -le $Maxterm
                            then entry=good
                         fi
            fi
    fi
  done
if test $srcp = n
   then dstp=n
   else
   { echo
     entry=bad
     until test $entry = good
       do
         echo -n Now enter the other port number [2 - $Maxterm].
         read dstp
         if test $dstp
            then if test $dstp -ge 2
                 then if test $dstp -le $Maxterm
                         then if test $dstp != $srcp
                                 then entry=good
                              fi
                      fi
                 fi
         fi
       done
       p1=`sleeptty.sh $srcp`
       p2=`sleeptty.sh $dstp`
       sioinit.sh $srcp $dstp
   }
fi
: . . . . . . . . . . . . . . . . . . . .
:
: Find out whether or not there is a serial printer on the system.
: Hold result in prf.
:
echo
entry=bad
until test $entry = good
  do
    echo Is there a Serial Printer on your system ?
    echo -n [y or n].
    read prf
    if test $prf
       then if test $prf = y -o $prf = n
               then entry=good
            fi
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
: Find out what kind of printer it is.
:
if test $prf = y
   then { entry=bad
          until test $entry = good
            do
              echo
              echo Please enter
              echo    "  1 if it is CDC 725-10 Matrix Printer."
              echo    "  2 if it is CDC 727-40 Letter Quality Printer."
              echo    "  3 if it is CDC 727-55 Letter Quality Printer."
              echo -n "  4 if it is EPSON MX80 Matrix Printer."
              read prf
              if test $prf
                 then if test $prf = 1 -o $prf = 2 -o $prf = 3 -o $prf = 4
                      then entry=good
                      fi
              fi
            done
            entry=bad
            if test $prf = 4
               then pwidth=n
               else until test $entry = good
                do
                  echo Please enter
                  echo    "  n  for narrow (80-column) paper."
                  echo -n "  w  for wide  (132-column) paper."
                  read pwidth
                  if test $pwidth
                     then if test $pwidth = n -o $pwidth = w
                          then entry=good
                          fi
                  fi
                done
             fi
         }
fi
 
: . . . . . . . . . . . . . . . . . . . .
:
: Find out if the operator wants to run the flexible disk check.
: Hold the result in fdf.
:
echo
echo
echo
echo
echo
echo
echo WARNING!!! THE FLEXIBLE DISK TEST WRITES OVER DATA ON THE DISKETTE.
echo
echo
echo
echo
echo
echo
entry=bad
until test $entry = good
  do
    echo If you want this test to be run, insert a XENIX DS DD FORMATTED
    echo scratch diskette in the flexible disk drive, and enter y.
    echo -n If not, enter n.
    read fdf
    if test $fdf
       then if test $fdf = y -o $fdf = n
               then entry=good
            fi
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
:
: Find out if the operator wants to run Stage I tests.
: Hold the result in stageI.
:
echo
entry=bad
until test $entry = good
  do
    echo If you want to run Stage I tests, enter y.
    echo -n If you want to go directly to Stage II, enter n.
    read stageI
    if test $stageI
       then if test $stageI = y -o $stageI = n
               then entry=good
            fi
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
:
: Delete any previous version of the test log file.
:
rm -f sysck.log
:
: Generate data files for -
:   disk tests
:   crt output
:   printer output
:
hexpat.o
patgen.o $prf $pwidth
export entry npass passn nmemerr nfcerr nrderr nfderr nserr stopgo sfile
: . . . . . . . . . . . . . . . . . . . .
:
: Execute Stage I control shell, if Stage I testing is requested.
:
if test $stageI = y
then
  exec stageI.sh $Maxpass $hdexp $fdf $prf $nt $srcp $dstp $p1 $p2 
: . . . . . . . . . . . . . . . . . . . .
:
: If not, execute Stage II control shell.
:
else
  exec stageII.sh $Maxpass $hdexp $fdf $prf $nt $srcp $dstp $p1 $p2 
fi
: . . . . . . . . . . . . . . . . . . . .
:
: End of initial control shell.
:
