/*************************************************************************
*
*
*	Name:		chgtype.c
*
*	Description:	Convert items on stack to appropriate type
*
*	History:
*	Date		By	Comments
*
*	04/21/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "opcodes.h"
#include "vartab.h"

fixtos(ltype,rtype)
int ltype, rtype;
{
   if (ltype == rtype) return ltype;
   switch (ltype) {
   case typeJ:
      switch (rtype) {
      case typeL:
	 genop(FXLJ);
	 break;
      default:
	 synerr("Cannot convert to single integer.");
      }
      break;
   case typeL:
      switch (rtype) {
      case typeJ:
	 genop(FXJL);
	 break;
      default:
	 synerr("Cannot convert to double integer.");
      }
      break;
   default:
      synerr("Unimplemented type conversion");
   }
   return ltype;
}

sametype(ltype,rtype)
int ltype, rtype;
{
   if (ltype == rtype) return ltype;
   if (ltype > rtype) return fixtos(ltype,rtype);
   switch (ltype) {
   case typeJ:
      switch(rtype) {
      case typeL:
	 genop(CVLJ);
	 break;
      default:
	 synerr("Cannot convert to single integer");
      }
      break;
   default:
      synerr("Unimplemented type conversion");
   }
   return rtype;
}
