/*************************************************************************
*
*
*	Name:		iostmt.c
*
*	Description:	Input/output and file statements
*
*	History:
*	Date		By	Comments
*
*	05/19/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "tokens.h"
#include "opcodes.h"
#include "vartab.h"
#include "symbols.h"
unsigned pc;

/* blkiostmt := BLOCK ( READ | WRITE ) ( FILE filespec )? (strvar | arraydesc)
*/
blkiostmt()
{
   int op;
   struct VTAB *p;

   if (token == TREAD) {
      op = BLKRD;
      gettoken();
   } else if (token == TWRITE) {
      op = BLKWR;
      gettoken();
   } else synerr("READ or WRITE expected.");
   if (token == TFILE) filespec("j/=0l");
   else {
      genLDCJ(16);
      genLDCL(0L);
   }
   if (token == STRVAR) {
      strvar();
      genop(op);
   } else if (token == NUMVAR) {
      p = findsym(symbol);
      if ((p->numsubs) == 0) synerr("array variable required");
      else {
	 genJ(LDAV,p->voffset);
	 gettoken();
      }
      if (op == BLKRD) genop(BLKRDD);
      else genop(BLKWRD);
   } else synerr("variable expected.");
}
/* readstmt := READ ( FILE filespec )? varlist
   varlist  := (numvar | strvar) ( comma (numvar | strvar) )*
*/
readstmt()
{
   int rtype;
   if (token == TFILE) filespec("j");
   else genLDCJ(16);
   genop(RDSET);
   do {
      if (token == COMMA) gettoken();
      if (token == STRVAR) {
	 strvar();
	 genop(RDA);
      } else if (token == NUMVAR && symtype == SSINGLE) {
	 rtype = numadr();
	 if (rtype == typeL) genop(RDLJ);
	 else if (rtype == typeJ) genop(RDJ);
	 else synerr("Double integer variable expected");
      } else {
	 rtype = numadr();
	 genop(RDJ+rtype);
      }
   } while (token == COMMA);
   genop(RDEND);
}

/* writestmt := WRITE FILE filespec explist
   explist := expresion ( comma expression )*
*/
writestmt()
{
   int rtype;
   if (token == TFILE) filespec("j");
   else {
      synerr("FILE expected");
      genLDCJ(16);
   }
   genop(WRSET);
   do {
      if (token == COMMA) gettoken();
      if (token == NUMVAR && symtype == SSINGLE) {
	 fixtos(typeL,numexp(typeL));
	 genop(WRLJ);
      } else {
	 rtype = expression(typeL);
	 if (rtype == typeA) genop(WRA);
	 else {
	    fixtos(typeL,rtype);
	    genop(WRL);
	 }
      }
   } while (token == COMMA);
   genop(WREND);
}

/* lopenstmt := LOPEN errvar FILE ( lparen | lbrack ) numexp comma lopentail
   lopentail := strvar ( comma numexp )? ( rparen | rbrack ) comma strexp
	      | numexp ( comma numexp )? ( rparen | rbrack ) comma strexp comma
		strexp comma numexp ( comma numexp ( comma numexp 
		( comma numexp ( comma numexp )? )? )? )?
*/
lopenstmt()
{
   errvar();
   if (token == TFILE) gettoken();
   else synerr("FILE expected");
   if (token == LPAREN || token == LBRACK) gettoken();
   else synerr("[ expected");
   fixtos(typeJ,numexp(typeJ));
   if (token == COMMA) gettoken();
   else synerr(", expected");
   if (token == STRVAR) {
      explist("$/=0l");
      if (token == RPAREN || token == RBRACK) gettoken();
      else synerr("] expected");
      if (token == COMMA) gettoken();
      else synerr(", expected");
      explist("a");
      genop(LOPNB);
   } else {
      explist("j/=0l");
      if (token == RPAREN || token == RBRACK) gettoken();
      else synerr("] expected");
      if (token == COMMA) gettoken();
      else synerr(", expected");
      explist("aal/=16777215l=0l=0j");
      genop(LOPNC);
   }
}

/* lreadstmt := LREAD FILE filespec comma strvar
*/
lreadstmt()
{
   if (token == TFILE) filespec("jl");
   else synerr("FILE expected");
   strvar();
   genop(LRD);
}

/* lwritestmt := LWRITE FILE filespec comma strexp
*/
lwritestmt()
{
   if (token == TFILE) filespec("jl");
   else synerr("FILE expected");
   strexp();
   genop(LWR);
}

/* closestmt := CLOSE (FILE filespec)?
*/
closestmt()
{
   if (token == TFILE) {
      filespec("j");
   } else
      genLDCJ(16);
   genop(CLOSE);
}

/* openstmt := OPEN errvar FILE filespec strexp
*/
openstmt()
{
   errvar();
   if (token == TFILE) {
      filespec("j/=0l");
      strexp();
      genop(OPEN);
   } else
      synerr("FILE expected.");
}

/* posfilstmt := POSITION FILE filespec
*/
posfilstmt()
{
   if (token == TFILE) {
      filespec("j/=0l");
      genop(SPOS);
   } else
      synerr("FILE expected.");
}

/* input-stmt := ( INPUT | TINPUT numexp comma) (FILE filespec)?
		 (USING strexp comma)? inarglist semicolon?
   inarglist  := inargelem ( comma inargelem )*
   inargelem  := strlit | strvar | numadr | @termcntrl
*/
inputstmt()
{
   int op;

   if (token == TTINPUT) {
      gettoken();
      fixtos(typeJ,numexp(typeJ));
      op = TISET;
      if (token == COMMA) gettoken();
      else synerr(", expected");
   } else {
      gettoken();
      op = INSET;
   }
   if (token == TFILE)
      filespec("j");
   else
      genLDCJ(16);
   if (token == TUSING) {
      gettoken();
      if (token == STRLIT || token == STRVAR)
	 gettoken();
      else
	 synerr("String expected.");
      if (token == COMMA) gettoken();
      else synerr(", expected.");
      op = (op == INSET)? INUSET : TIUSET;
   }
   genop(op);
   do {
      if (token == COMMA) gettoken();
      if (token == STRLIT) {
	 strexp(); genop(INPRM);
      } else if (token == STRVAR) {
	 strvar(); genop(INA);
      } else if (token == NUMVAR) {
	 genop(INJ+numadr());
      } else if (token == ATSIGN) {
	 termcntrl(INCTL);
      }
   } while (token == COMMA);
   if (token == SEMI) {
      gettoken();
      genop(INEND);
   } else 
      genop(INCR);
}

/* print-stmt := PRINT (FILE filespec)? print-list
               | PRINT (FILE filespec)? USING strexp comma explist?
   print-list := ( prntelem? ( comma | semicolon) )* prntelem?
   prntelem   := @termcntrl | ( TAB open numexp close ) | expression
*/
prntstmt()
{
   int type, cr=0;
   gettoken();
   if (token == TFILE)
      filespec("j");
   else
      genLDCJ(16);
   if (token == TUSING) {
      gettoken();
      strexp();
      genop(PRUSET);
      while (token == COMMA) {
	 gettoken();
	 if (token == EOLN || token == TELSE) break;
	 type = expression(typeJ);
	 if (type == typeA) genop(PRUA);
	 else genop(PRUJ+type);
      }
      genop(PRUEND);
   } else {
      genop(PRSET);
      while (token != EOLN && token != TELSE) {
	 if (token == COMMA) {
	    gettoken();
	    genop(PRCOM);
	    cr = 1;
	 } else if (token == SEMI) {
	    gettoken();
	    cr = 1;
	 } else if (token == ATSIGN) {
	    termcntrl(PRCTL);
	    cr = 0;
	 } else if (token == TTAB) {
	    gettoken();
	    if (token == LPAREN) gettoken();
	    else synerr ("( expected.");
	    type = numexp(typeJ);
	    fixtos(typeJ,type);
	    if (token == RPAREN) gettoken();
	    else synerr(") expected.");
	    genop(PRTAB);
	    cr = 0;
	 } else {
	    type = expression(typeJ);
	    if (type == typeA)
	       genop(PRA);
	    else
	       genop(PRJ+type);
	    cr = 0;
	 }
      }
      if (cr == 0) genop(PRCR);
      else genop(PREND);
   }
}

/* termcntrl := @ open expression ( comma expression )? close
*/
termcntrl(op)
int op;
{
   gettoken();
   if (token == LPAREN) gettoken();
   else synerr ("( expected.");
   explist("j/=0j");
   if (token == RPAREN) gettoken();
   else synerr (") expected.");
   genop(op);
}

/* filespec := FILE (open | lbrack) explist (close | rbrack)
*/
filespec(s)
char *s;
{
   gettoken();
   if (token == LPAREN || token == LBRACK) gettoken();
   else synerr("[ expected.");
   explist(s);
   if (token == RPAREN || token == RBRACK) gettoken();
   else synerr("] expected.");
   if (token == COMMA) gettoken();
   else if (token != EOLN && token != TELSE) synerr(", expected.");
}
