/*************************************************************************
*
*
*	Name:		expression.c
*
*	Description:	Expressions and addesses
*
*	History:
*	Date		By	Comments
*
*	11/10/83	jle
*	02/23/84	jle	logical expressions
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "tokens.h"
#include "opcodes.h"
#include "vartab.h"
#include "symbols.h"

/* numadr := numvar subscript?
*/
numadr()
{
   int ns;
   struct VTAB *p;
   if (token != NUMVAR) {
      synerr("Variable name expected");
      return typeL;
   }
   if (strcmp(symbol,argsym) == 0) {
      synerr("Illegal use of function argument.");
      return typeL;
   } else
      p = findsym(symbol);
   gettoken();
   if (token == LPAREN || token == LBRACK) {
      ns = subscript(p->numsubs);
      makevar(p,typeUNDF,ns);
      genJ(SBAJ+(p->vtype),p->voffset);
   } else if ((ns = p->numsubs) != 0) {
      while (ns-- > 0)
	 genLDCJ(0);
      genJ(SBAJ+(p->vtype),p->voffset);
   } else {
      makevar(p,typeUNDF,0);
      genJ(LDAV,p->voffset);
   }
   return(p->vtype);
}

numdsc()
{
   int ns;
   struct VTAB *p;
   if (token != NUMVAR) {
      synerr("Variable name expected");
      return typeL;
   }
   if (strcmp(symbol,argsym) == 0) {
      synerr("Illegal use of function argument.");
      return typeL;
   } else
      p = findsym(symbol);
   gettoken();
   if (token == LPAREN || token == LBRACK) {
      ns = subscript(p->numsubs);
      makevar(p,typeUNDF,ns);
      genJ(SBDJ+(p->vtype),p->voffset);
   } else if ((ns = p->numsubs) != 0) {
      while (ns-- > 0)
	 genLDCJ(0);
      genJ(SBDJ+(p->vtype),p->voffset);
   } else {
      makevar(p,typeUNDF,0);
      genJ(LDDJ+(p->vtype),p->voffset);
   }
   return(p->vtype);
}

/* smpadr := numvar
*/
smpadr(symptr)
struct VTAB **symptr;
{
   int ns;
   struct VTAB *p;
   if (token != NUMVAR) {
      synerr("Variable name expected");
      return typeL;
   }
   p = findsym(symbol);
   gettoken();
   if ((ns = p->numsubs) != 0) {
      while (ns-- > 0)
	 genLDCJ(0);
      genJ(SBAJ+(p->vtype),p->voffset);
   } else {
      makevar(p,typeUNDF,0);
      genJ(LDAV,p->voffset);
   }
   *symptr = p;
   return(p->vtype);
}

numstore(ltype,rtype)
int ltype, rtype;
{
   fixtos(ltype,rtype);
   genop(STIJ+ltype);
}

/* relexp := numexp ( relop numexp )?
           | strexp relop strexp
*/
relexp()
{
   int ltype, rtype, op;
   ltype = expression(typeL);
   op = token;
   if (ltype == typeA) {
      if (token >= LESS && token <= GREATER) {
	 gettoken();
         strexp();
	 genop(CMPA);
	 genop(LTZJ+op-LESS);
      }
   } else {
      if (token >= LESS && token <= GREATER) {
	 gettoken();
	 rtype = numexp(ltype);
	 genop(CMPJ+sametype(ltype,rtype));
	 genop(LTZJ+op-LESS);
      } else {
	 genop(LD0J+ltype);
	 genop(CMPJ+ltype);
	 genop(NEZJ);
      }
   }
   return(typeJ);
}

/* expression := numexp | strexp
*/
expression(dtype)
int dtype;
{
   if (token == STRLIT || token == STRVAR) {
      strexp();
      return typeA;
   } else
      return numexp(dtype);
}

/* numexp := ( plus | minus )? term ( plus | minus ) term
*/
numexp(dtype)
int dtype;
{
   int op, ltype, rtype;
   if (token == PLUS || token == MINUS) {
      op = token; gettoken();
   } else
      op = PLUS;
   ltype = term(dtype);
   if (op == MINUS) genop(NEGJ+ltype);
   while (token == PLUS || token == MINUS) {
      op = token;
      gettoken();
      rtype = term(ltype);
      ltype = sametype(ltype,rtype);
      if (op == PLUS) genop(ADDJ+ltype);
      else genop(SUBJ+ltype);
   }
   return(ltype);
}

/* term := factor ( ( asterisk | slash ) factor )*
*/
term(dtype)
int dtype;
{
   int op, ltype, rtype;
   ltype = factor(dtype);
   while (token == TIMES || token == SLASH) {
      op = token;
      gettoken();
      rtype = factor(ltype);
      ltype = sametype(ltype,rtype);
      if (op == TIMES) genop(MULJ+ltype);
      else genop(DIVJ+ltype);
   }
   return(ltype);
}

/* factor := primary ( up-arrow primary )*
*/
factor(dtype)
int dtype;
{
   int ltype, rtype;
   ltype = primary(dtype);
   while (token == UPARROW) {
      gettoken();
      rtype = primary(ltype);
      ltype = sametype(ltype,rtype);
      genop(EXPJ+ltype);
   }
   return(ltype);
}

/* primary := numvar subscript?
	    | numlit
	    | open numexp close
	    | numeric-function open explist close
	    | FNCNAM open numexp close
*/
primary(dtype)
int dtype;
{
   struct VTAB *p;
   int xtype, ns, fncnum;

   switch (token) {
case NUMVAR:
      if (strcmp(symbol,argsym) == 0) {
	 genLDD(LDV,0,typeL,-4); /* refers to argument */
	 gettoken();
	 return typeL;
      }
      p = findsym(symbol);
      gettoken();
      if (token == LPAREN || token == LBRACK) {
	 ns = subscript(p->numsubs);
	 makevar(p,typeUNDF,ns);
	 genJ(SBVJ+(p->vtype),p->voffset);
      } else if ((ns = p->numsubs) != 0) {
	 while (ns-- > 0)
	    genLDCJ(0);
	 genJ(SBVJ+(p->vtype),p->voffset);
      } else {
	 makevar(p,typeUNDF,0);
	 genJ(LDVJ+(p->vtype),p->voffset);
      }
      return(p->vtype);
case NUMLIT:
      return(numcon(dtype));
case LPAREN:
      gettoken();
      xtype = numexp(dtype);
      if (token == RPAREN) gettoken();
      else synerr("Missing )");
      return(xtype);
case FNCNAM:
      fncnum = symtype;
      genLDCL(0L);
      xtype = typeL;
      gettoken();
      if (token == LPAREN) gettoken();
      else synerr("( expected");
      explist("l");
      if (token == RPAREN) gettoken();
      else synerr(") expected");
      genI(CALLFN,fncnum);
      return typeL;
case TINT:
      gettoken();
      if (token == LPAREN) gettoken();
      else synerr("( expected");
      xtype = numexp(dtype);
      if (token == RPAREN) gettoken();
      else synerr(") expected");
      return xtype;
default:
      if (token >= TABS && token <= TVAL) return(funcall());
   }
   synerr("Invalid primary");
   return dtype;
}

/* numcon := numlit
*/
numcon(dtype)
int dtype;
{
   int xtype;
   if (token == MINUS) {
      gettoken();
      if (token == NUMLIT)
	 value = -value;
      else
	 synerr("numeric constant expected");
   }
   if (dtype == typeJ && value >= -32767L && value <= 32767L) {
      genLDCJ((int) value);
      xtype = typeJ;
   } else {
      genLDCL(value);
      xtype = typeL;
   }
   gettoken();
   return xtype;
}

/* strexp := strlit
	   | strvar
*/
strexp()
{
   if (token == STRLIT)
      strcon();
   else 
      strvar();
   return(typeA);
}

strcon()
{
   if (token == STRLIT) {
      genLDCA(symbol,symlen);
      gettoken();
   } else
      synerr("String constant expected.");
   return typeA;
}


/* strvar := strnam subscript?
*/
strvar()
{
   struct VTAB *p;
   if (token == STRVAR) {
      p = findsym(symbol);
      makevar(p,typeA,0);
      gettoken();
      if (token == LPAREN || token == LBRACK) {
	 subscript(2);
	 genJ(SBDA,p->voffset);
      } else {
	 genJ(LDDA,p->voffset);
      }
      return(p->vtype);
   } else synerr("Invalid string variable");
   return typeA;
}

/* subscript := open numexp ( comma numexp )? close
*/
subscript(nsubs)
int nsubs;
{
   int ns=1;
   gettoken();
   fixtos(typeJ,numexp(typeJ));
   while (token == COMMA) {
      gettoken();
      fixtos(typeJ,numexp(typeJ));
      ns++;
   } 
   while (ns < nsubs) {
      genLDCJ(0);
      ns++;
   }
   if (token == RPAREN || token == RBRACK) {
      gettoken();
   } else
      synerr(") expected");
   return ns;
}

/* dumvar := STRVAR
	   | NUMVAR dumsub?
*/
dumvar()
{
   int ns;
   struct VTAB *p;
   if (token == STRVAR) {
      p = findsym(symbol);
      makevar(p,typeA,0);
      gettoken();
   } else if (token == NUMVAR) {
      p = findsym(symbol);
      gettoken();
      if (token == LPAREN || token == LBRACK) {
	 ns = dumsub(p->numsubs);
	 makevar(p,typeUNDF,ns);
      } else {
	 makevar(p,typeUNDF,0);
      }
   } else {
      synerr("Variable name expected");
   }
}

/* dumsub := open numexp ( comma numexp )? close
*/
dumsub(nsubs)
int nsubs;
{
   int ns=1;
   gettoken();
   if (token == TIMES) gettoken();
   else synerr("* expected.");
   while (token == COMMA) {
      gettoken();
      if (token == TIMES) gettoken();
      else synerr("* expected.");
      ns++;
   } 
   if (token == RPAREN || token == RBRACK) {
      gettoken();
   } else
      synerr(") expected");
   return ns;
}
