/*************************************************************************
*
*
*	Name:  debinit.c
*
*	Description:  Debugger - initialization.
*
*
*	History:
*	Date		By		Comments
*
*	04/14/83	waf		chk for symbol table present.
*	04/25/83	waf		chk for line# table present.
*	05/02/83	waf		allow line# table & symbol table to be in
*					either the .pm or .bp file.
*	08/29/83	waf		Handle int & quit keys.
*	09/01/83	waf 	Handle int & quit keys better.
*	10/25/83	waf		Save, modify, & restore term characteristics on
*					entry/exit.
*	11/16/83	waf		Chk dincbs value in header. Disallow line table
*					or sym table refs if set.
*	11/29/83	waf		Chk file type.
*						Add '.pm' ext to filename given if open error.
*	12/14/83	waf		Chk revision level of pmd file.
*	02/09/84	waf		Reset CBREAK and RAW term characteristics on entry.
*						Use /bb/include/prevision.h for rev #.
*	04/06/84	waf		Fixed version number display.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */


/*  Notes -

09/01/83	waf
  Interrupts are ignored during initialization.
  During command execution, interrupts are vectored to ikey().

11/29/83	waf
  The name in the cmdline is used for the filename. If that filename is not
found, a '.pm' is appended to the name given.

02/09/84	waf
  Note that the p-mach already handles setting and resetting the terminal
characteristics on entry to and return from the debugger, so the code here
is redundant. The code here may be useful, however, if the debugger is being
run from the shell.

02/09/84	waf
  The file prevision.h is used both by the pmach and the debugger, so that 
they will agree on the current rev. Note that the debugger should be remade
after every new rev of the pmach.

*/




#include	"debug.h"
#include	"/bb/include/prevision.h"
#include	<signal.h>
#include	<stdio.h>
#include	<sgtty.h>

/* constants to force options ( for debugging ) */
#define	NOLT	0		/* line table not present */
#define	NOST	0		/* symbol table not present */
#define	NOBP	0		/* .bp file not present */


int	ikey();				/* ikey/quit handler */
int	initikey();			/* ikey/quit handler during initialization */

setup ( argc, argv )

int	argc;
char	*argv[];
{
	char	fn[15];		/* filename var */
	int	x,i,j,k,ix;
	int	argptr;
	int	retval;
	int	fd;
	int	size;
	char	buf[64];
	unsigned rev;


	dbug = DBUG;		/* debug flag */
	base = 10;			/* default base = dec */
	argptr = 1;			/* arg# of filename in shell cmd */


	/** Ignore int & quit during initialization **/
	signal( SIGINT, SIG_IGN );
	signal( SIGQUIT, SIG_IGN );


	/** Set terminal characteristics **/
	set_chars();


	/** chk caller **/
	if ( argc == 1 ) {

		/** called by p-machine **/
		caller = PMACH ;
		pmfd = PFCHN ;			/* fd of push file */
		if (dbug)
			puts( ">> called by p-mach" );
		}
	else {

		/** called by shell (pmd) **/
		caller = PMD ;
		printf("\nDebugger  vers. %x\.%02d\n",
				(REVISION >> 8), REVISION & 0xff) ;
		/* chk for debug switch (-d) */
		if ( strcmp( argv[argptr], "-d" ) == 0 ) {
			argptr++ ;
			dbug = 1 ;
			}

		/* open dump file */
		/* Try to open name given.
		  If unsuccessful, append '.pm' extension */
		strcpy( fn, argv[argptr] ) ;	/* filename in cmd line */
		pmfd = open( fn, 2 );
		if ( pmfd < 0 ) {
			/* append '.pm' to filename given */
			strcpy( buf, fn );
			strcat( buf, ".pm" );
			pmfd = open(buf, 2) ;
			}
		if ( pmfd < 0 ) {
			printf( "debug: Can't open file - %s.\n", fn );
			exit( -1 );
			}
		}


	/** get header **/
	headfp = lseek( pmfd, 0L, 1 ) ;		/* save pos of header */
	x = read( pmfd, &pmhead, sizeof(pmhead) );
	if ( x!= sizeof(pmhead) ) {
		printf( "debug: header read - %s.\n", fn );
		exit(-1);
		}
	pcodbase = pmhead.begmem ;		/* pcode starting addr */

	/* chk compatability */
	/* chk type */
	if ( pmhead.magic != NORMPGM ) {
		printf( "debug: Incompatable file type - %u.", pmhead.magic );
		exit( -1 );
		}
	/* chk revision */
	rev = pmhead.revision ;
	if ( (rev & 0xff00) != (REVISION & 0xff00)		/* different major rev's */
	  || (rev & 0xff) > (REVISION & 0xff) ) {		/* higher minor rev */
		/* bad revision */
		printf("debug: Incompatable revision number - %x\n", rev);
		exit(-1) ;
		}


	/** define file ptrs **/
	/* some of these (i.e. line# table & sym table)
			may be redefined to be .bp file ptrs */
	pcdfp = headfp + (long) 512 ;				/* p-code */
	ltfp = pcdfp + (long) pmhead.codsiz ;	/* line# table */
	symfp = ltfp + (long) pmhead.ltabsiz ;	/* sym table */
	sffp = symfp + (long) pmhead.symsiz ;	/* sys frame */
	gffp = sffp + (long) sizeof(sframe) ;	/* global frame */
	estkfp = gffp ;								/* evaluation stack */
	ustfp = sffp + (long) pmhead.stksiz ;	/* symbol table */
	if (dbug) {
		printf(">> file ptrs (hex) are -\n" );
		printf(" head %X\n pcd %X\n lt %X\n symtbl %X\n sf %X\n gf %X\n",
		headfp,pcdfp,ltfp,symfp,sffp,gffp );
		printf(" estk %X\n ust %X\n", estkfp, ustfp );
		}


	/** get UST **/
	lseek( pmfd, ustfp, 0 );
	x = read( pmfd, &ust, pmhead.ustsiz );
	if ( x != pmhead.ustsiz ) {
		printf( "debug: ust read error\n" );
		exit( -1 );
		}


	/** open .bp file & get header **/
	strcpy( fn, ust.pname );	/* program name root */
	strcat( fn, ".bp" );			/* extension of pcode file */
	bpfd = open( fn, 2 );		/* open p-code file */
	if ( bpfd < 0 || NOBP ) {

		/* no .bp file available */
		/* if ( pmcall() == FALSE ) */
		printf( "** p-code file (%s) not available **\n", fn );
		}
	else {

		/* get .bp header */
		x = read( bpfd, &bphead, sizeof(bphead) );
		if ( x!= sizeof(bphead) ) {
			printf( "debug: .bp header read - %s\n", fn );
			exit(-1);
			}
		}


	/** get line# table **/
	if ( NOLT ) goto nolt ;
	if ( pmhead.dincbs )
		goto nolt ;		/* incompatable base pgm - don't support lt ops */

	if ( pmhead.ltabsiz != 0 ) {

		/* use line table in .pm file */
		ltfd = pmfd ;		/* use .pm file */
		size = pmhead.ltabsiz ;		/* line table size */
		}
	else {

		/* use line table in .bp file, if it exists */
		if ( bpfd < 0 || bphead.ltabsiz == 0 ) {

nolt:
			/** line table not present **/
			/* if ( pmcall() == FALSE ) */
			printf( "** line number table is not available **\n" );
			ltfd = -1 ;		/* flag 'no line table' */
			ltfp = 0L ;
			}
		else {
			ltfd = bpfd ;		/* use .bp file */
			size = bphead.ltabsiz ;
			ltfp = 512L + bphead.codsiz ;		/* line table ptr in .bp file */
			}
		}
	if (dbug)
		printf( ">> lt fp = %X\n", ltfp );

	/* bring in line# table */
	if ( ltfd != -1 )		/* if line# table exists */ {
		lseek( ltfd, ltfp, 0 );
		x = read( ltfd, linetbl, size );
		ltnent = ( size >> 2 ) ;		/* # entries in line# table */
		/* stop at first '32767' entry found in linetbl */
		for ( i=0 ; linetbl[i].lineno != 32767 && i < ltnent ; i++ ) ;
		i++ ;		/* # 'real' entries in line table */
		if (dbug)
			printf(">> line table - #entries, real entries = %d %d\n",
		ltnent,i );
		ltnent = i ;
		}


	/** get evaluation stack and global frame **/
	/* 'evaluation stack' in file starts at (GFP - sizeof(SFRAME)) */
	/* evaluation stack array in memory starts at (GFP + 0) */
	lseek( pmfd, estkfp, 0 );
	estksiz = pmhead.stksiz ;		/* size of eval stk array */
	if (dbug)
		printf( ">> eval stk size = %d\n", pmhead.stksiz );
	if ( estksiz > ESTKSIZE ) {
		printf( "debug: eval stack too big\n" );
		exit( -1 );
		}
	x = read( pmfd, evalstk, estksiz );
	if ( x != estksiz ) {
		printf( "debug: eval stack read\n" );
		exit( -1 );
		}
	/* read global frame structure ( for GF info ) */
	lseek( pmfd, gffp, 0 );		/* backup to start of GF */
	read( pmfd, &gframe, sizeof(gframe) );	/* get GFRAMEA struct also */
	gfbase = pmhead.gfp.B ;	/* memory addr of GFP */


	/** get symbol table **/
	if ( NOST )  goto nost;
	if ( pmhead.dincbs )
		goto nost;		/* incompatable base pgm - don't support sym table */
	if ( pmhead.symsiz != 0 ) {

		/* symbol table is in .pm file */
		stfd = pmfd ;
		size = pmhead.symsiz;
		}

	else  if ( bpfd != -1 && bphead.symsiz != 0 ) {

		/* symbol table is in .bp file */
		stfd = bpfd ;
		size = bphead.symsiz ;
		symfp = 512L + bphead.codsiz + bphead.ltabsiz ;	/* sym table ptr */
		}

	else {

nost:
		/* symbol table not available */
		stfd = -1 ;
		symfp = 0L ;
		/* if ( pmcall() == FALSE ) */
		printf( "** symbol table is not available **\n" );
		}

	/* read in sym table */
	if ( stfd != -1 )		/* if symtbl exists */ {
		lseek( stfd, symfp, 0 );		/* seek to symbol table */
		x = read( bpfd, &vtab, bphead.symsiz );	/* read in symbol table */
		if ( x != bphead.symsiz ) {
			printf( "debug: sym table read error\n" );
			exit( -1 );
			}
		if (0) {
			printf( ">> var table is -\n" );
			for ( i=0 ; i < 348 ; i++ ) {
				if ( vtab[i].vname[0] == '\0' ) break ;
				printf( "  %d %s\n", i, vtab[i].vname );
				}
			}
		}

	if (0)  showptrs();
	}

/**/

ikey ()

/*  ikey/quit handler  */
{

	signal( SIGINT, ikey );
	signal( SIGQUIT, ikey );

	puts( "\n\7  ** Interrupted **" );
	puts( "  Enter 'HELP' for commands to exit Debugger" );

	longjmp(ikeyenv);
	}


		/**  Terminal characteristics  **/

/* define characteristics to be set on entry to debugger */
#define	SETCHARS	ECHO

/* define characteristics to be reset on entry to debugger */
#define	RSTCHARS	CBREAK | RAW


struct sgttyb	oldchars,newchars;	/* terminal characteristics buffers */


set_chars()

/*	Save term characteristics on entry, and set characteristics
	for debugger.
*/
{


	if ( isatty(0) == FALSE )
		return;		/* not terminal input */

	ioctl( 0, TIOCGETP, &oldchars );	/* get characteristics */
	if (dbug)
		printf( "oldchars.sg_flags = %o\n", oldchars.sg_flags );

	/* set characteristics for debugger */
	newchars = oldchars ;
	newchars.sg_flags |= SETCHARS ;		/* set bits */
	newchars.sg_flags &= (~RSTCHARS) ;	/* reset bits */
	if (dbug)
		printf( "newchars.sg_flags = %o\n", newchars.sg_flags );
	ioctl( 0, TIOCSETP, &newchars );	/* set new characteristics*/
	}



rset_chars()

/*	Reset terminal characteristics to what they were when we entered
	the debugger. 
*/
{


	if ( isatty(0) == TRUE )
		ioctl( 0, TIOCSETP, &oldchars );
	}
