/*************************************************************************
*
*
*	Name:  pextern.h
*
*	Description:  External data definitions for the p-machine
*
*
*	History:
*	Date		By	Comments
*
*	03/01/83	mas
*	10/18/83	waf		Add gflags.
*	11/07/83	waf		Added system & BB externs.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include <setjmp.h>

	/* global flags */
extern	union gflg	gflags ;

	/* I/O buffer */
extern	char	iobuf[];

	/* Input status structure */
extern	struct ios iostat;

	/* Terminal buffer  */
extern	char	termbuf[];
extern	int	termcount;

	/* Default terminal characteristics */
extern	int	defterm;
extern	int	deflcan;
extern	int	defdel;
extern	int	defunp1;
extern	int	defunp2;
extern	int	defik1;
extern	int	defik2;

	/* valid IKEY jump vector flag */
extern	int	valikey;

	/* IKEY long jump environment */
extern	jmp_buf	ikeyenv;

	/* ERROR long jump environment */
extern	jmp_buf	errenv;

	/* valid alarm jump vector flag */
extern	int	valalarm;

	/* Alarm long jump environment */
extern	jmp_buf	alarmenv;

	/* Last error number */
extern	int	lasterrno;

	/* PC of line in which IKEY occurred */
extern	char	*pcint;

	/* PC of Last line in error */
extern	char	*pcerr;

	/* PC of Last line executed */
extern	char	*pclast;

	/* Last file number used */
extern	int	lastfileno;

	/* Random number generator seed */
extern	unsigned randseed;

	/* Time left after timed input */
extern	unsigned timeleft;

	/* Time requested for timed input */
extern	unsigned alarmreq;

	/* CRM$ chararacters */
extern	char	cram[];

	/*	User Status Table	*/
extern	struct usrtable ust;

	/* P-code and push file header */
extern	struct phead pcheader;
	/* Base pgm header */
extern	struct bhead basheader;

	/* Environment of p-code */
extern	unsigned penviron;

	/* Begin of memory area */
extern	char	*begmem;

	/* End of memory */
extern	char	*endmem;

	/* begin of avaluation stack */
extern	char	*begstk;

	/*  Base frame pointer - always points to bottom of stack */
extern	struct SFRAME *BFP;

	/* Global Frame Pointer - points to current global frame */
extern	struct GFRAME *GFP;

	/* Frame Pointer - points the the local frame */
extern	POINTER	FP;

	/* Line to begin execution at (used by START p-code) */
extern	unsigned startline;

	/* PMD DUMP switch - pmdump() checks this before allowing dump */
extern	unsigned pmdsw;

	/* Debug switch - causes a call to the debugger if START executed */
extern	unsigned debugsw;

	/* last error or int location */
extern	char	*sys20pc;

	/* dummy system and global frames used to capture errors during */
	/* periods where there is no stack as in a swap or chain */
extern	struct	SFRAME	DSF;
extern	struct	GFRAME	DGF;

	/* TRACE fd used to write trace output */
extern	int	tracefd;

	/* Temp holding area for PC and SP */
extern	char	*TPC;
extern	char	*TSP;

	/* Global switch word set by parsecmd and used by sys(11) */
extern	long	globsw;

	/* crt control table (in crts.c) */
extern	CRTCTRL	*crtctrl[];

	/* INPUT label of next statement */
extern	int	inlabel;

	/* tty structures used by terminit + termreset + crts.c */
#include <sgtty.h>
extern	struct	sgttyb	oldmode;
extern	struct	sgttyb	newmode;
extern	struct	tchars	oldchar;

	/* PUSH file descriptor */
extern	int	pushfd;

	/* pointer to BBPATH string in environ */
extern	char	*bbpath;

	/* continue switch - when set the p-machine  registers are loaded
	   from the p-code header */
extern	int	contsw;

	/* fd of the error file (/bb/syslib/basic.er) */
extern	int	errfd;

	/* fd of the special number file (/bb/syslib/basic.no) */
extern	int	numfd;

	/* spool directory used in open ?xxx */
extern	char	*xspooldir;

	/* debugger file name - must be complete path name */
extern	char	*xdebugger;

	/* library directory - used in chkpath as second dir to search */
extern	char	*xlibdir;

	/* error file  - complete path name */
extern	char	*xerrfile;

	/* system program library - complete path name */
extern	char	*xproglib;

	/* basic number file - job numbers and serial number */
extern	char	*xnumfile;

	/* push stack - keeps track of next location in push file */
extern	long	pushstk[12];

	/* push file name - if given */
extern	char	*pushname;

	/** Declare system and BB global var's & fn's **/


/** System **/
extern	long	lseek();
extern	int		errno;


/** BB **/
extern long	getvl();
extern long	pctoline();
extern long	rndl();
extern long	sys();
extern char	*dasm();
extern char *prstr();
extern char	opstr[];
extern int	opcnt;
