|*************************************************************************
|
|
|	Name:  blkmov.s
|
|	Description:  Block move, byte & word.
|				  Block fill, byte.
|					
|
|
|	History:
|	Date		By		Comments
|
|	09/16/83	waf
|	09/29/83	waf		Chk for count = 0
|	10/06/83	waf		Added blkfilb().
|	10/24/83	waf		Chk for count <= 0.
|
|
|
|  This document contains confidential/proprietary information.
|
|  Copyright 1983 by Digital Communications Assoc.
|
|************************************************************************
| /* BB/Xenix Runtime Module */
|
|
|
|
|  Notes -
|
|  NOTE - blkmovb() & blkmovw() do not chk for overwrite.
|
|  These fn's can be used for a 'fast' block move when the # bytes/words to be
|  moved is known.
|  It is the user's responsibility to chk for overwriting (e.g. chk for
|  exclusive data spaces).
|
|

	.text

	.globl	_blkmovb	| block move bytes
	.globl	_blkmovw	| block move words

	| blkmov ( from, to, count )
	| char *from,*to;
	| unsigned count;

| NOTE - Overlap of source and dest is not checked.

_blkmovb:
	mov		bx,sp
	push	di
	push	si

	mov	cx,*6(bx)	| count (bytes)
	cmp	cx,*0
	jle	exit2		| count <= 0

	mov	si,*2(bx)	| source
	mov	di,*4(bx)	| destination
	cld				| inc ptrs
	rep
	movsb			| move bytes

exit2:
	pop		si
	pop		di
	ret

_blkmovw:
	mov		bx,sp
	push	di
	push	si

	mov	cx,*6(bx)	| count (words)
	cmp	cx,*0
	jle	exit2		| count <= 0

	mov	si,*2(bx)	| source
	mov	di,*4(bx)	| destination
	cld				| inc ptrs
	rep
	movs			| move words

	jmp		exit2

|
	.globl	_blkfilb	| block fill bytes

	| blkfil ( dest, count, fill_val )
	| char	*dest;
	| unsigned	count;
	| char	fill_val

_blkfilb:
	mov		bx,sp
	push	di

	mov		cx,4(bx)	| count
	cmp		cx,*0
	jle		exit1		| count <= 0

	mov		ax,6(bx)	| fill_val
	mov		di,2(bx)	| dest
	cld					| inc ptr
	rep
	stob				| fill it

exit1:
	pop		di
	ret
