/*************************************************************************
*
*
*	Name:  crt control
*
*	Description:  device dependent operations
*
*
*	History:
*	Date		By	Comments
*
*	03/01/83	WEB
*	04/22/83	WEB	added 'defterm' to be used by ustinit to
*				initialize the p-machine.
*	05/16/83	WEB	added functions to determine the default
*				terminal type based on $TERM, changed default
*				characteristics to global (def- items)
*	6/24/83 	mas	changed to use registers where possible
*	9/03/83		cba     added 'cdc114AII' terminal definition (type 1)
*	9/03/83		cba     added 'cdc114A2w'terminal definition(type 2 - wide)
*					(Note: changed prctl.c for additional @(-xx)fns.
*	12/08/83	waf		Optimized for space.
*	12/12/83	waf		crt7attrib[] - fixed -36 & -37.
*	02/03/84	waf		Changed name of type 1 & type 2 (altos/cdc) terminals.
*						Re-fixed -36 & -37 crt7attrib's.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -	this module contains the device dependent routines and
		table to support the various terminal types for BASIC.
		Each type requires three items for full support, a table
		of control codes for the user status table (ust), a table
		of attribute strings for print control items -20 thru -67,
		and a function to implement cursor positioning. These are
		supplied initially for terminal type 6. All others default
		to a "glass teletype" (tty) mode of operation with minimal
		features. Additional terminal types can be defined by supplying
		the qppropriate tables and functions and re-compiling and
		re-loading BASIC.


12/08/83	waf
  Space optimization -
Optimized numeric comparisons.
Used constants for bufptr in crt_*() fns. 'bufst' defines start of buffer.
Used unsigned args for easier comparisons.
Eliminated redundant code.

12/12/83	waf
  It is assmmed that, when a crt_n() fn is invoked, the arguments are both
> 0 (they are both chk'ed by prctl()).
  The arguments are converted to unsigned, so that grossly large values will
be converted to managable values.

*/



#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"


/* define start of buffer (allows use of constants in crt_*() fn's) */
#define	bufst	0

/*   This module defines the terminal dependent operations for
   cursor positioning and control. The appropriate tables must be
   defined for each type of terminal. Also, a function must be
   be defined to perform the cursor positioning operation.
*/



/*******************************************************/
/*                                                     */
/*       terminal control table for @(...) items       */
/*       (see also the CRTCTRL structure in ptype.h    */
/*       for further documentation on the order and    */
/*       mnemonics of the items in the table)          */
/*                                                     */
/*******************************************************/

CRTCTRL crt1ctrl = {				/* terminal type 1 */
	'\210',					/* sneaky: set hi bit of bs */
	80,
	14,
	132,
	'\377',
	'\134',
	'\n',
	'\0',
	0,
	'\377'
	}; /* end-of-table */

CRTCTRL crt2ctrl = {				/* terminal type 2 */
	'\210',					/* sneaky: set hi bit of bs */
	132,
	14,
	132,
	'\377',
	'\134',
	'\n',
	'\0',
	0,
	'\377'
	}; /* end-of-table */

CRTCTRL crt6ctrl = {				/* terminal type 6 */
	'\231',
	80,
	14,
	132,
	'\377',
	'\134',
	'\n',
	'\0',
	0,
	'\377'
	}; /* end-of-table */

CRTCTRL crt7ctrl = {				/* terminal type 7 */
	'\231',
	80,
	14,
	132,
	'\377',
	'\134',
	'\n',
	'\0',
	0,
	'\377'
	}; /* end-of-table */

CRTCTRL ttyctrl = {				/* undefined terminal type */
	'\134',
	72,
	14,
	72,
	'\377',
	'\134',
	'\n',
	'\0',
	0,
	'\377'
	}; /* end-of-table */

CRTCTRL *crtctrl[] = {
	&ttyctrl,		      /* terminal type 0 (undefined) */
	&crt1ctrl,		      /* terminal type 1 (ALTOS II - 80 column) */
	&crt2ctrl,		      /* terminal type 2 (ALTOS II - 132 column) */
	&ttyctrl,		      /* terminal type 3 */
	&ttyctrl,		      /* terminal type 4 */
	&ttyctrl,		      /* terminal type 5 */
	&crt6ctrl,		      /* terminal type 6 (dg 6053 monster) */
	&crt7ctrl,		      /* terminal type 7 (cdc722 beastie) */
	&ttyctrl,		      /* terminal type 8 */
	&ttyctrl 		      /* terminal type 9 */
	}; /* end-of-table */

/********************************************************/
/*                                                      */
/* terminal control table for @(...) items -20 thru -67 */
/*                                                      */
/********************************************************/

char *ttyattrib[] = {		/* undefined terminal type */
	"\377",			/* -20 home cursor */
	"\377",			/* -21 cursor right */
	"\377",			/* -22 cursor down */
	"\377",			/* -23 cursor left */
	"\377",			/* -24 cursor up */
	"\007",			/* -25 bell */
	"\377",			/* -26 tab */
	"\015",			/* -27 return (no line-feed) */
	"\015\012",		/* -28 new-line */
	"\377",			/* -29 back tab */
	"\377",			/* -30 clear all to spaces */
	"\377",			/* -31 clear unprotected to spaces */
	"\377",			/* -32 clear to end of line */
	"\377",			/* -33 clear to end of page */
	"\377",			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\377",			/* -36 insert line */
	"\377",			/* -37 delete line */
	"\377",			/* -38 start protect (low intensity) */
	"\377",			/* -39 start unprotect (high intensity) */
	"\377",			/* -40 start blink */
	"\377",			/* -41  end blink */
	"\377",			/* -42 set format mode */
	"\377",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\377",			/* -48 set flag 1 */
	"\377",			/* -49 clear flag 1 */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\377",			/* -52 start underscore */
	"\377",			/* -53 end under score */
	"\377",			/* -54 start field (bright & underscore ) */
	"\377",			/* -55 end field (dim & normal ) */
	"\377",			/* -56 return to normal */
	"\377",			/* -57 north-south bar  */
	"\377",			/* -58 east-west  bar   */
	"\377",			/* -59 cross            */
	"\377",			/* -60 north tee        */
	"\377",			/* -61 south   tee      */
	"\377",			/* -62 west  tee        */
	"\377",			/* -63 east tee         */
	"\377",			/* -64 northwest  corner*/
	"\377",			/* -65 northeast   corner*/
	"\377",			/* -66 southwest  corner*/
	"\377" 			/* -67 southeast   corner*/
	}; /* end-of-table */

char *crt1attrib[] = {		/* terminal type 1 */
	"\033[0;0H",	/* -20 home cursor */
	"\033[1C",		/* -21 cursor right */
	"\033[1B",		/* -22 cursor down */
	"\010",   		/* -23 cursor left */
	"\033[1A",		/* -24 cursor up */
	"\007",			/* -25 bell */
	"\011",			/* -26 tab */
	"\015",			/* -27 return (no line-feed) */
	"\015\012",		/* -28 new-line */
	"\377",			/* -29 back tab */
	"\033[2J\033[0;0H",		/* -30 clear all to spaces */
	"\377",			/* -31 clear unprotected to spaces */
	"\033[0K",		/* -32 clear to end of line */
	"\033[0J",		/* -33 clear to end of page */
	"\377",			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\033[1L",		/* -36 insert line */
	"\033[1M",		/* -37 delete line */
	"\033[2m",		/* -38 start protect (low intensity) */
	"\033[0m",		/* -39 stop unprotect (high intensity) */
	"\033[5m",		/* -40 start blink */
	"\033[0m",		/* -41  end blink */
	"\377",			/* -42 set format mode */
	"\377",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\033[7m",		/* -48 set flag 1 (Reverse video) */
	"\033[0m",		/* -49 clear flag 1 (Reverse video off) */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\033[4m",		/* -52 start underscore */
	"\033[0m",		/* -53 end under score */
	"\033[0m\033[4m",	/* -54 start field (bright & underscore ) */
	"\033[0m\033[2m",	/* -55 end field (dim & normal ) */
	"\033[0m",	        	/* -56 return to normal */
	"\033(0\063\033(B",		/* -57 north-south bar  */
	"\033(0\104\033(B",		/* -58 east-west  bar   */
	"\033(0\105\033(B",		/* -59 cross            */
	"\033(0\102\033(B",		/* -60 north tee        */
	"\033(0\101\033(B",		/* -61 south   tee      */
	"\033(0\103\033(B",		/* -62 west  tee        */
	"\033(0\064\033(B",		/* -63 east tee         */
	"\033(0\132\033(B",		/* -64 northwest  corner*/
	"\033(0\077\033(B",		/* -65 northeast   corner*/
	"\033(0\100\033(B",		/* -66 southwest  corner*/
	"\033(0\131\033(B" 		/* -67 southeast   corner*/
	}; /* end-of-table */

char *crt2attrib[] = {		/* terminal type 2 */
	"\033[0;0H",		/* -20 home cursor */
	"\033[1C",			/* -21 cursor right */
	"\033[1B",			/* -22 cursor down */
	"\010",   			/* -23 cursor left */
	"\033[1A",			/* -24 cursor up */
	"\007",				/* -25 bell */
	"\011",				/* -26 tab */
	"\015",				/* -27 return (no line-feed) */
	"\015\012",			/* -28 new-line */
	"\377",				/* -29 back tab */
	"\033[2J\033[0;0H",	/* -30 clear all to spaces */
	"\377",				/* -31 clear unprotected to spaces */
	"\033[0K",			/* -32 clear to end of line */
	"\033[0J",			/* -33 clear to end of page */
	"\377",				/* -34 keyboard lock */
	"\377",				/* -35 keyboard unlock */
	"\033[1L",			/* -36 insert line */
	"\033[1M",			/* -37 delete line */
	"\033[2m",			/* -38 start protect (low intensity) */
	"\033[0m",			/* -39 stop unprotect (high intensity) */
	"\033[5m",			/* -40 start blink */
	"\033[0m",			/* -41  end blink */
	"\377",				/* -42 set format mode */
	"\377",				/* -43 end format mode */
	"\377",				/* -44 set program mode */
	"\377",				/* -45 end program mode */
	"\377",				/* -46 set block mode */
	"\377",				/* -47 set conversation mode */
	"\033[7m",			/* -48 set flag 1 (Reverse video) */
	"\033[0m",			/* -49 clear flag 1 (Reverse video off) */
	"\377",				/* -50 send line (field) unprotected */
	"\377",				/* -51 send line (field) all */
	"\033[4m",			/* -52 start underscore */
	"\033[0m",			/* -53 end under score */
	"\033[0m\033[4m",	/* -54 start field (bright & underscore ) */
	"\033[0m\033[2m",	/* -55 end field (dim & normal ) */
	"\033[0m",			/* -56 return to normal */
	"\033(0\063\033(B",	/* -57 north-south bar  */
	"\033(0\104\033(B",	/* -58 east-west  bar   */
	"\033(0\105\033(B",	/* -59 cross            */
	"\033(0\102\033(B",	/* -60 north tee        */
	"\033(0\101\033(B",	/* -61 south   tee      */
	"\033(0\103\033(B",	/* -62 west  tee        */
	"\033(0\064\033(B",	/* -63 east tee         */
	"\033(0\132\033(B",	/* -64 northwest  corner*/
	"\033(0\077\033(B",	/* -65 northeast   corner*/
	"\033(0\100\033(B",	/* -66 southwest  corner*/
	"\033(0\131\033(B" 	/* -67 southeast   corner*/
	}; /* end-of-table */

char *crt6attrib[] = {		/* terminal type 6 */
	"\010",			/* -20 home cursor */
	"\030",			/* -21 cursor right */
	"\032",			/* -22 cursor down */
	"\031",			/* -23 cursor left */
	"\027",			/* -24 cursor up */
	"\007",			/* -25 bell */
	"\011",			/* -26 tab */
	"\015",			/* -27 return (no line-feed) */
	"\012",			/* -28 new-line */
	"\377",			/* -29 back tab */
	"\014",			/* -30 clear all to spaces */
	"\377",			/* -31 clear unprotected to spaces */
	"\013",			/* -32 clear to end of line */
	"\377",			/* -33 clear to end of page */
	"\377",			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\377",			/* -36 insert line */
	"\377",			/* -37 delete line */
	"\034",			/* -38 start protect (low intensity) */
	"\035",			/* -39 start unprotect (high intensity) */
	"\016",			/* -40 start blink */
	"\017",			/* -41  end blink */
	"\023",			/* -42 set format mode */
	"\022",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\377",			/* -48 set flag 1 */
	"\377",			/* -49 clear flag 1 */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\024",			/* -52 start underscore */
	"\025",			/* -53 end under score */
	"\035\024",		/* -54 start field (bright & underscore ) */
	"\025\034",		/* -55 end field (dim & normal ) */
	"\025\035\017\022",	/* -56 return to normal */
	"\377",			/* -57 north-south bar  */
	"\377",			/* -58 east-west  bar   */
	"\377",			/* -59 cross            */
	"\377",			/* -60 north tee        */
	"\377",			/* -61 south   tee      */
	"\377",			/* -62 west  tee        */
	"\377",			/* -63 east tee         */
	"\377",			/* -64 northwest  corner*/
	"\377",			/* -65 northeast   corner*/
	"\377",			/* -66 southwest  corner*/
	"\377" 			/* -67 southeast   corner*/
	}; /* end-of-table */

char CLS7[] = { 
	'\014',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\200', '\200', '\200', '\200', '\200',  '\200', '\200', '\200',
	'\0' };

char *crt7attrib[] = {		/* terminal type 7 */
	"\010",			/* -20 home cursor */
	"\030",			/* -21 cursor right */
	"\032",			/* -22 cursor down */
	"\031",			/* -23 cursor left */
	"\027",			/* -24 cursor up */
	"\007",			/* -25 bell */
	"\011",			/* -26 tab */
	"\015",			/* -27 return (no line-feed) */
	"\012",			/* -28 new-line */
	"\377",			/* -29 back tab */
	"\014",			/* -30 clear all to spaces */
	"\036\100",		/* -31 clear unprotected to spaces */
	"\013",			/* -32 clear to end of line */
	"\036\120",		/* -33 clear to end of page */
	CLS7+1,			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\036R",		/* -36 insert line */
	"\036Q",		/* -37 delete line */
	"\034",			/* -38 start protect (low intensity) */
	"\035",			/* -39 start unprotect (high intensity) */
	"\016",			/* -40 start blink */
	"\017",			/* -41  end blink */
	"\023",			/* -42 set format mode */
	"\022",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\036\034",		/* -48 set flag 1 */
	"\036\035",		/* -49 clear flag 1 */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\024",			/* -52 start underscore */
	"\025",			/* -53 end under score */
	"\035\024",		/* -54 start field (bright & underscore ) */
	"\025\034",		/* -55 end field (dim & normal ) */
	"\025\035\017\022",   	/* -56 return to normal */
	"\036\034\041\036\035",	/* -57 north-south bar  */
	"\036\034\040\036\035",	/* -58 east-west bar    */
	"\036\034\052\036\035",	/* -59 cross            */
	"\036\034\046\036\035",	/* -60 north tee        */
	"\036\034\047\036\035",	/* -61 south tee        */
	"\036\034\050\036\035",	/* -62 west tee         */
	"\036\034\051\036\035",	/* -63 east tee         */
	"\036\034\042\036\035",	/* -64 north-west corner*/
	"\036\034\043\036\035",	/* -65 north-east corner*/
	"\036\034\044\036\035",	/* -66 south-west corner*/
	"\036\034\045\036\035" 	/* -67 south-east  corner*/
	}; /* end-of-table */

char *(*crtattrib[])[0] = {
	ttyattrib,			/* terminal type 0 */
	&crt1attrib,
	&crt2attrib,
	ttyattrib,
	ttyattrib,
	ttyattrib,
	&crt6attrib,
	&crt7attrib,
	ttyattrib,
	ttyattrib			
	};

/************************************************************************/
/*                                                                      */
/* functions to perform cursor positioning are defined in the following */
/* array and referenced by position based on the terminal type          */
/*                                                                      */
/************************************************************************/

int crt_tty(), crt_1(), crt_2(), crt_6(), crt_7();

int (*posncurs[])() = {				/* cursor position functions */
	crt_tty,		/* terminal type 0 */
	crt_1,
	crt_2,
	crt_tty,
	crt_tty,
	crt_tty,
	crt_6,
	crt_7,
	crt_tty,
	crt_tty			/* terminal type 9 */
	}; /* end-of-table */

/************************************************************************/
/*                                                                      */
/* functions to determine the default terminal type are referenced in   */
/* the following array and are referenced to set 'defterm'              */
/*                                                                      */
/************************************************************************/

int chk_tty(), chk_1(), chk_2(), chk_6(), chk_7();

int (*chkterm[])() = {				/* terminal typing functions */
	chk_tty,		/* terminal type 0 */
	chk_1,
	chk_2,
	chk_tty,
	chk_tty,
	chk_tty,
	chk_6,
	chk_7,
	chk_tty,
	chk_tty			/* terminal type 9 */
	}; /* end-of-table */

/*							 */
/*   terminal type 1 - Altos II / VT-100  (80x24 screen) */
/*							 */

#define C_WR1   '\033['
#define MAXROW1 24
#define MAXCOL1 80

static	crt_1(iarg1, iarg2, buf)				/* cursor position function */
int iarg1, iarg2;
char buf[];
{
	register unsigned	arg1,arg2;


	arg1 = iarg1 ; arg2 = iarg2 ;	/* put args in reg vars */

	/* adjust for screen size */
	if ( arg1 > MAXROW1 )
		arg1 = MAXROW1 ;
	if ( arg2 > MAXCOL1 )
		arg2 = MAXCOL1 ;

	/* sprintf(buf,"\033[%02d;%02df",arg1,arg2 );   set row;column       */
	/* i += 8;                                      increment for 6 chars*/ 
	strcpy(buf+bufst, "\033[nn;nnf") ;
	buf[bufst+2] = (arg1 > 9 ? (arg1/10) + '0' : '0');
	buf[bufst+3] = (arg1 % 10) + '0';
	buf[bufst+5] = (arg2 > 9 ? (arg2/10) + '0' : '0');
	buf[bufst+6] = (arg2 % 10) + '0';

	return(bufst+8);			/* return length of buffer */
	}



static	chk_1(termid)
char *termid;
{
	return((strcmp(termid,"cdcAII")) ? FALSE : TRUE );
	}

/*							 */
/*   terminal type 2 - Altos II / VT-100 (80x24 screen)  */
/*							 */

#define C_WR2   '\033['
#define MAXROW2 24
#define MAXCOL2 132

static	crt_2(iarg1, iarg2, buf)				/* cursor position function */
int iarg1, iarg2;
char buf[];
{
	register unsigned	arg1,arg2;
	char	c;


	arg1 = iarg1 ; arg2 = iarg2 ;	/* put args in reg vars */

	/* adjust for screen size */
	if ( arg1 > MAXROW2 )
		arg1 = MAXROW2 ;
	if ( arg2 > MAXCOL2 )
		arg2 = MAXCOL2 ;

	/* sprintf(buf,"\033[%02d;%03df",arg1,arg2 );  set row;column           */
	/* i += 9;                                     increment for 6 chars*/ 
	strcpy(buf+bufst, "\033[nn;nnnf") ;
	buf[bufst+2] = (arg1 > 9 ? (arg1/10) + '0' : '0');
	buf[bufst+3] = (arg1 % 10) + '0';
	c = '0' ;
	if ( arg2 > 99 ) {
		c++ ;
		arg2 -= 100 ;
		}
	buf[bufst+5] = c ;
	buf[bufst+6] = (arg2 > 9 ? (arg2/10) + '0' : '0');
	buf[bufst+7] = (arg2 % 10) + '0';

	return(bufst+9);		/* return length of buffer */
	}



static	chk_2(termid)
char *termid;
{
	return((strcmp(termid,"cdcAIIw")) ? FALSE : TRUE );
	}

/*							 */
/*   terminal type 6 - Data General 6053, D/100, D/200   */
/*							 */

#define C_WR6   '\020'
#define C_LEFT6 '\031'
#define C_UP6   '\027'
#define MAXROW6 24
#define MAXCOL6 80

static	crt_6(iarg1, iarg2, buf)				/* cursor position function */
int iarg1, iarg2;
char buf[];
{
	register unsigned	arg1,arg2;
	int	colflag;
	int	rowflag;


	arg1 = iarg1 ; arg2 = iarg2 ;	/* use reg vars */

	colflag = rowflag = 0 ;

	buf[bufst+0] = C_WR6;		/* cursor-write lead in */

	/* adjust for screen size */
	arg1 = ((arg1 > MAXROW6)? MAXROW6 : arg1) - 1;
	arg2 = ((arg2 > MAXCOL6)? MAXCOL6 : arg2) - 1;

	/* chk for strangeness at certain pixels.
	   Xenix will not accept certain binary strings, so we have to
	   fool it by going past the desired position, and then
	   backing up.
	   Note - assumes arg1 & arg2 have 0 hi bytes. */
	if ( arg2 == 9 || arg2 == 4 || arg2 == 10 || arg2 == 13 ) {
		arg2++;
		colflag++;	/* set col flag */
		}
	buf[bufst+1] = arg2 | 0200;
	if ( arg1 == 9 || arg1 == 4 || arg1 == 10 || arg1 == 13 ) {
		arg1++;
		rowflag++;	/* set row flag */
		}
	buf[bufst+2] = arg1 | 0200;
	/* backup, if necessary */
	arg1 = bufst + 3 ;		/* buf len before correction chars added */
	if ( colflag )
		buf[arg1++] = C_LEFT6;
	if ( rowflag )
		buf[arg1++] = C_UP6;

	return(arg1);		/* return length of buffer */
	}



static	chk_6(termid)
char *termid;
{
	return((strcmp(termid,"dg6053")) ? FALSE : TRUE );
	}

/*							 */
/*   terminal type 7 - Control Data terminal             */
/*							 */

#define C_WR7   '\020'
#define C_LEFT7 '\031'
#define C_UP7   '\027'
#define MAXROW7 24
#define MAXCOL7 80

static	crt_7(iarg1, iarg2, buf)				/* cursor position function */
int iarg1, iarg2;
char buf[];
{
	register unsigned	arg1,arg2;


	/* puts args in reg vars */
	arg1 = iarg1 ;
	arg2 = iarg2 ;

	buf[bufst+0] = C_WR7;				/* cursor-write lead in */

	/* adjust for screen size */
	arg1 = (((arg1 > MAXROW7)? MAXROW7 : arg1) - 1) + 32;
	arg2 = (((arg2 > MAXCOL7)? MAXCOL7 : arg2) - 1) + 32;

	buf[bufst+1] = arg2 ;			/* set column */
	buf[bufst+2] = arg1 ;			/* set row */

	return(bufst+3);		/* return length of buffer */
	}



static	chk_7(termid)
char *termid;
{
	return((strcmp(termid,"cdc722")) ? FALSE : TRUE );
	}

/*								   */
/*   undefined terminal type - functions like a "glass teletype"   */
/*								   */

static	crt_tty(arg1, arg2, buf)			/* undefined terminal type */
int arg1, arg2;
char buf[];
{
	return(0);
	} /* end-crt_tty */



static	chk_tty(termid)
char *termid;
{
	return((strcmp(termid,"tty")) ? FALSE : TRUE );
	}
