/*************************************************************************
*
*
*	Name:  dumpregs.c
*
*	Description:  Debugging print of registers and stack used by pmach.c
*
*
*	History:
*	Date		By	Comments
*
*	04/07/83	mas
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/pcondcomp.h"

#ifdef DEBDEF

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"


dumpregs(PC,SP)
POINTER	PC,SP;
{
	int	tempj;

	printf("\034FP = %d\n",((char *)FP.B)-begstk);
	printf("GFP = %d\n",((char *)GFP)-begstk);
	printf("BFP = %d\n",((char *)BFP)-begstk);
	printf("BSP = %d\n",((char *)GFP->BSP.B)-begstk);
	printf("GSP = %d\n",((char *)GFP->GSP.B)-begstk);
	printf("FNSP= %d\n",((char *)GFP->FNSP)-begstk);
	printf("LTP = %d\n",((char *)GFP->LTP)-begmem);
	printf("DTP = %d\n",((char *)GFP->DTP.B)-begmem);
	printf("p-code: %d  PC = %d ",*PC.B,(int)(PC.B - begmem));
	tempj = (*PC.B > 0 && *PC.B < 10) ? ((unsigned)*(PC.B+1))
					     + (unsigned)(*PC.B * 256) : *PC.B;
	printf("opcode: %s\n\035",dasm(tempj));

}

dumpstk(SP)
POINTER	SP;
{
	int	*jptr;

	jptr = SP.J - begstk;
	printf("\034SP = %d   %04x %04x %04x %04x %04x %04x %04x %04x\n\035"
		,jptr,*(SP.J-8),*(SP.J-7),*(SP.J-6),*(SP.J-5),
		    *(SP.J-4),*(SP.J-3),*(SP.J-2),*(SP.J-1));
}
#endif
